/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.IndexId;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.DebugLogger;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.player.MediaPlayer;
import jpsxdec.modules.sharedaudio.DiscItemAudioStream;
import jpsxdec.modules.sharedaudio.ISectorAudioDecoder;
import jpsxdec.modules.video.AudioStreamsCombiner;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.DiscItemVideoStream;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.ISectorClaimToDemuxedFrame;
import jpsxdec.modules.video.ParallelAudio;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.modules.video.replace.ReplaceFrames;
import jpsxdec.modules.video.sectorbased.SectorBasedVideoInfo;
import jpsxdec.modules.video.sectorbased.SectorBasedVideoSaverBuilder;
import jpsxdec.modules.xa.DiscItemXaAudioStream;
import jpsxdec.util.Fraction;
import jpsxdec.util.Misc;
import jpsxdec.util.TaskCanceledException;
import jpsxdec.util.player.PlayController;

public abstract class DiscItemSectorBasedVideoStream
extends DiscItemVideoStream {
    @Nonnull
    private final SectorBasedVideoInfo _vidInfo;
    private static final String DISC_SPEED_KEY = "Disc Speed";
    private int _iDiscSpeed = -1;
    private final ParallelAudio _parallelAudio = new ParallelAudio();

    public DiscItemSectorBasedVideoStream(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, @Nonnull Dimensions dim, @Nonnull IndexSectorFrameNumber.Format indexSectorFrameNumberFormat, @Nonnull SectorBasedVideoInfo vidInfo) {
        super(cd, iStartSector, iEndSector, dim, indexSectorFrameNumberFormat);
        this._vidInfo = vidInfo;
    }

    public DiscItemSectorBasedVideoStream(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._vidInfo = new SectorBasedVideoInfo(fields);
        this._iDiscSpeed = fields.getInt(DISC_SPEED_KEY, -1);
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem serial = super.serialize();
        this._vidInfo.serialize(serial);
        int iDiscSpeed = this.getDiscSpeed();
        if (iDiscSpeed > 0) {
            serial.addNumber(DISC_SPEED_KEY, iDiscSpeed);
        }
        return serial;
    }

    @Override
    public int getDiscSpeed() {
        if (this._iDiscSpeed > 0) {
            return this._iDiscSpeed;
        }
        int iAudioDiscSpeed = this._parallelAudio.getAudioDiscSpeed();
        if (iAudioDiscSpeed > 0) {
            return iAudioDiscSpeed;
        }
        return -1;
    }

    @Override
    public final int getAbsolutePresentationStartSector() {
        return this.getStartSector() + this._vidInfo.getFirstFrameLastSector();
    }

    @Override
    @Nonnull
    public final Fraction getSectorsPerFrame() {
        return this._vidInfo.getSectorsPerFrame();
    }

    @Override
    public final boolean addChild(@Nonnull DiscItem other) {
        return this._parallelAudio.addChild(other, this.getParentRating(other));
    }

    @Override
    public final boolean setIndexId(@Nonnull IndexId id) {
        super.setIndexId(id);
        this._parallelAudio.setIndexId(id.createChild());
        return true;
    }

    @Override
    public final int getChildCount() {
        return this._parallelAudio.getCount();
    }

    @Nonnull
    public final Iterable<DiscItemAudioStream> getChildren() {
        return this._parallelAudio.getChildren();
    }

    public final boolean hasAudio() {
        return this._parallelAudio.hasAudio();
    }

    @CheckForNull
    public final List<DiscItemAudioStream> getParallelAudioStreams() {
        return this._parallelAudio.getParallelAudioStreams();
    }

    @Override
    public final double getApproxDuration() {
        int iDiscSpeed = this.getDiscSpeed();
        if (iDiscSpeed < 1) {
            iDiscSpeed = 2;
        }
        return (double)this.getSectorLength() / (double)(iDiscSpeed * 75);
    }

    @Override
    @Nonnull
    public final ILocalizedMessage getInterestingDescription() {
        int iDiscSpeed = this.getDiscSpeed();
        int iFrameCount = this.getFrameCount();
        if (iDiscSpeed > 0) {
            int iSectorsPerSecond = iDiscSpeed * 75;
            Date secs = Misc.dateFromSeconds(Math.max(this.getSectorLength() / iSectorsPerSecond, 1));
            return I.GUI_STR_VIDEO_DETAILS(this.getWidth(), this.getHeight(), iFrameCount, Fraction.divide(iSectorsPerSecond, this.getSectorsPerFrame()).asDouble(), secs);
        }
        Date secs150 = Misc.dateFromSeconds(Math.max(this.getSectorLength() / 150, 1));
        Date secs75 = Misc.dateFromSeconds(Math.max(this.getSectorLength() / 75, 1));
        return I.GUI_STR_VIDEO_DETAILS_UNKNOWN_FPS(this.getWidth(), this.getHeight(), iFrameCount, Fraction.divide(150L, this.getSectorsPerFrame()).asDouble(), secs150, Fraction.divide(75L, this.getSectorsPerFrame()).asDouble(), secs75);
    }

    @Override
    @Nonnull
    public SectorBasedVideoSaverBuilder makeSaverBuilder() {
        return new SectorBasedVideoSaverBuilder(this);
    }

    @CheckForNull
    public List<DiscItemAudioStream> getLongestNonIntersectingAudioStreams() {
        return this._parallelAudio.getLongestNonIntersectingAudioStreams();
    }

    public abstract int findAudioSplitPoint(@Nonnull DiscItemXaAudioStream var1);

    public abstract void fpsDump(@Nonnull PrintStream var1) throws IOException;

    public void fpsDump2(final @Nonnull PrintStream ps) throws CdFileSectorReader.CdReadException {
        ISectorClaimToDemuxedFrame demuxer = this.makeDemuxer();
        demuxer.setFrameListener(new IDemuxedFrame.Listener(){

            @Override
            public void frameComplete(IDemuxedFrame frame) {
                ps.println(frame.getStartSector() - DiscItemSectorBasedVideoStream.this.getStartSector() + "-" + (frame.getEndSector() - DiscItemSectorBasedVideoStream.this.getStartSector()));
            }
        });
        SectorClaimSystem it = this.createClaimSystem();
        demuxer.attachToSectorClaimer(it);
        while (it.hasNext()) {
            IIdentifiedSector isect = it.next(DebugLogger.Log);
        }
        it.close(DebugLogger.Log);
    }

    @Override
    @Nonnull
    public PlayController makePlayController() {
        MediaPlayer mp;
        if (this.hasAudio()) {
            List<DiscItemAudioStream> audios = this._parallelAudio.getLongestNonIntersectingAudioStreams();
            assert (audios != null);
            ISectorAudioDecoder decoder = audios.size() == 1 ? audios.get(0).makeDecoder(1.0) : new AudioStreamsCombiner(audios, 1.0);
            int iStartSector = Math.min(decoder.getStartSector(), this.getStartSector());
            int iEndSector = Math.max(decoder.getEndSector(), this.getEndSector());
            mp = new MediaPlayer(this, this.makeDemuxer(), decoder, iStartSector, iEndSector);
        } else {
            mp = new MediaPlayer(this, this.makeDemuxer());
        }
        return mp.getPlayController();
    }

    public void replaceFrames(@Nonnull ProgressLogger pl, @Nonnull String sXmlFile) throws LoggedFailure, TaskCanceledException {
        ReplaceFrames replacers;
        try {
            replacers = new ReplaceFrames(sXmlFile);
        }
        catch (ReplaceFrames.XmlFileNotFoundException ex) {
            throw new LoggedFailure(pl, Level.SEVERE, I.IO_OPENING_FILE_NOT_FOUND_NAME(sXmlFile), ex);
        }
        catch (ReplaceFrames.XmlReadException ex) {
            throw new LoggedFailure(pl, Level.SEVERE, I.IO_READING_FILE_ERROR_NAME(sXmlFile), ex);
        }
        catch (LocalizedDeserializationFail ex) {
            throw new LoggedFailure(pl, Level.SEVERE, ex.getSourceMessage(), ex);
        }
        replacers.replaceFrames(this, this.getSourceCd(), pl);
    }
}

