/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.indexing.DiscIndexer;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.ac3.DiscIndexerAceCombat3Video;
import jpsxdec.modules.dredd.DiscIndexerDredd;
import jpsxdec.modules.strvideo.DiscIndexerStrVideo;
import jpsxdec.modules.video.sectorbased.DiscItemSectorBasedVideoStream;
import jpsxdec.modules.xa.DiscItemXaAudioStream;

public class DiscIndexerSectorBasedVideo
extends DiscIndexer {
    private static final Logger LOG = Logger.getLogger(DiscIndexerSectorBasedVideo.class.getName());
    private final Collection<DiscItemSectorBasedVideoStream> _completedVideos = new ArrayList<DiscItemSectorBasedVideoStream>();
    @Nonnull
    private final SubIndexer[] _sectorBasedVideoIndexers;

    public DiscIndexerSectorBasedVideo(@Nonnull ILocalizedLogger log) {
        for (SubIndexer vidIndexer : this._sectorBasedVideoIndexers = new SubIndexer[]{new DiscIndexerStrVideo(), new DiscIndexerAceCombat3Video(log), new DiscIndexerDredd()}) {
            vidIndexer._parentIndexer = this;
        }
    }

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        for (SubIndexer indexer : this._sectorBasedVideoIndexers) {
            indexer.attachToSectorClaimer(scs);
        }
    }

    @Override
    @CheckForNull
    public DiscItem deserializeLineRead(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        for (SubIndexer indexer : this._sectorBasedVideoIndexers) {
            DiscItem item = indexer.deserializeLineRead(fields);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @Override
    public void listPostProcessing(@Nonnull Collection<DiscItem> allItems) {
        if (!this._completedVideos.isEmpty()) {
            DiscIndexerSectorBasedVideo.audioSplit(this._completedVideos, allItems);
        }
    }

    @Override
    public boolean filterChild(@CheckForNull DiscItem parent, @Nonnull DiscItem child) {
        boolean blnIsSilentXa;
        boolean bl = blnIsSilentXa = child instanceof DiscItemXaAudioStream && !(parent instanceof DiscItemSectorBasedVideoStream) && ((DiscItemXaAudioStream)child).isConfirmedToBeSilent();
        if (blnIsSilentXa) {
            LOG.log(Level.INFO, "Discarding silent XA {0}", child);
        }
        return blnIsSilentXa;
    }

    private static void audioSplit(@Nonnull Collection<? extends DiscItemSectorBasedVideoStream> videos, @Nonnull Collection<DiscItem> allItems) {
        ArrayList<DiscItemXaAudioStream> added = new ArrayList<DiscItemXaAudioStream>();
        Iterator<DiscItem> it = allItems.iterator();
        block0: while (it.hasNext()) {
            DiscItem item = it.next();
            if (!(item instanceof DiscItemXaAudioStream)) continue;
            DiscItemXaAudioStream audio = (DiscItemXaAudioStream)item;
            for (DiscItemSectorBasedVideoStream discItemSectorBasedVideoStream : videos) {
                int iSector = discItemSectorBasedVideoStream.findAudioSplitPoint(audio);
                if (iSector < 0) continue;
                DiscItemXaAudioStream[] aoSplit = audio.split(iSector);
                it.remove();
                added.add(aoSplit[0]);
                added.add(aoSplit[1]);
                continue block0;
            }
        }
        it = added.listIterator();
        block2: while (it.hasNext()) {
            DiscItemXaAudioStream audio = (DiscItemXaAudioStream)it.next();
            for (DiscItemSectorBasedVideoStream discItemSectorBasedVideoStream : videos) {
                int n = discItemSectorBasedVideoStream.findAudioSplitPoint(audio);
                if (n < 0) continue;
                DiscItemXaAudioStream[] aoSplit = audio.split(n);
                it.remove();
                it.add(aoSplit[0]);
                it.add(aoSplit[1]);
                it.previous();
                it.previous();
                continue block2;
            }
        }
        allItems.addAll(added);
    }

    @Override
    public void indexGenerated(@Nonnull DiscIndex index) {
    }

    public static abstract class SubIndexer {
        private DiscIndexerSectorBasedVideo _parentIndexer;

        protected final void addVideo(@Nonnull DiscItemSectorBasedVideoStream video) {
            this._parentIndexer._completedVideos.add(video);
            this._parentIndexer.addDiscItem(video);
        }

        @Nonnull
        protected final CdFileSectorReader getCd() {
            return this._parentIndexer.getCd();
        }

        public abstract void attachToSectorClaimer(@Nonnull SectorClaimSystem var1);

        @CheckForNull
        public abstract DiscItem deserializeLineRead(@Nonnull SerializedDiscItem var1) throws LocalizedDeserializationFail;
    }
}

