/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.sectorbased;

import java.io.PrintStream;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameReplace;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.DemuxedData;
import jpsxdec.util.Fraction;

public class DemuxedFrameWithNumberAndDims
implements IDemuxedFrame {
    @Nonnull
    private final DemuxedData<SectorBasedFrameReplace.IReplaceableVideoSector> _demux;
    private final int _iWidth;
    private final int _iHeight;
    private final int _iHeaderFrameNumber;
    @CheckForNull
    private FrameNumber _frameNumber;

    public DemuxedFrameWithNumberAndDims(int iWidth, int iHeight, int iHeaderFrameNumber, @Nonnull List<? extends SectorBasedFrameReplace.IReplaceableVideoSector> sectors) {
        this._demux = new DemuxedData<SectorBasedFrameReplace.IReplaceableVideoSector>(sectors);
        this._iWidth = iWidth;
        this._iHeight = iHeight;
        this._iHeaderFrameNumber = iHeaderFrameNumber;
    }

    public void setFrame(@Nonnull FrameNumber frameNumber) {
        this._frameNumber = frameNumber;
    }

    @Override
    @Nonnull
    public FrameNumber getFrame() {
        if (this._frameNumber == null) {
            throw new IllegalStateException();
        }
        return this._frameNumber;
    }

    @Override
    @CheckForNull
    public MdecInputStream getCustomFrameMdecStream() {
        return null;
    }

    @Override
    public int getWidth() {
        return this._iWidth;
    }

    @Override
    public int getHeight() {
        return this._iHeight;
    }

    @Override
    public int getStartSector() {
        return this._demux.getStartSector();
    }

    @Override
    public int getEndSector() {
        return this._demux.getEndSector();
    }

    @Override
    @Nonnull
    public Fraction getPresentationSector() {
        return new Fraction(this.getEndSector());
    }

    public int getHeaderFrameNumber() {
        return this._iHeaderFrameNumber;
    }

    @Override
    public int getDemuxSize() {
        return this._demux.getDemuxSize();
    }

    @Override
    @Nonnull
    public byte[] copyDemuxData() {
        return this._demux.copyDemuxData();
    }

    @Override
    public void printSectors(@Nonnull PrintStream ps) {
        for (SectorBasedFrameReplace.IReplaceableVideoSector vidSector : this._demux) {
            ps.println(vidSector);
        }
    }

    @Override
    public void writeToSectors(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull CdFileSectorReader cd, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        SectorBasedFrameReplace.writeToSectors(existingFrame, newFrame, cd, log, this._demux);
    }

    public String toString() {
        return String.format("Frame %d sectors %d-%d %dx%d chunks:%d bytes:%d", this.getHeaderFrameNumber(), this.getStartSector(), this.getEndSector(), this.getWidth(), this.getHeight(), this._demux.getPieceCount(), this._demux.getDemuxSize());
    }

    public int getChunkCount() {
        return this._demux.getPieceCount();
    }

    public static interface Listener {
        public void frameComplete(@Nonnull DemuxedFrameWithNumberAndDims var1, @Nonnull ILocalizedLogger var2) throws LoggedFailure;

        public void endOfSectors(@Nonnull ILocalizedLogger var1);
    }
}

