/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.save;

import javax.annotation.Nonnull;
import jpsxdec.util.Fraction;

public class VideoSync {
    private final int _iFirstPresentationSector;
    private final int _iSectorsPerSecond;
    @Nonnull
    private final Fraction _sectorsPerFrame;
    @Nonnull
    private final Fraction _secondsPerFrame;
    private static final Fraction NegPoint5 = new Fraction(-5L, 10L);
    private static final Fraction NegPoint8 = new Fraction(-8L, 10L);

    public VideoSync(int iFirstPresentationSector, int iSectorsPerSecond, @Nonnull Fraction sectorsPerFrame) {
        this._iFirstPresentationSector = iFirstPresentationSector;
        this._iSectorsPerSecond = iSectorsPerSecond;
        this._sectorsPerFrame = sectorsPerFrame;
        this._secondsPerFrame = this._sectorsPerFrame.divide(this._iSectorsPerSecond);
    }

    public int getSectorsPerSecond() {
        return this._iSectorsPerSecond;
    }

    @Nonnull
    public Fraction getSecondsPerFrame() {
        return this._secondsPerFrame;
    }

    @Nonnull
    public Fraction getSectorsPerFrame() {
        return this._sectorsPerFrame;
    }

    @Nonnull
    public Fraction calcPresentationTime(@Nonnull Fraction framePresentationSector) {
        return framePresentationSector.subtract(this._iFirstPresentationSector).divide(this._iSectorsPerSecond);
    }

    public int calculateFramesToCatchUp(@Nonnull Fraction framePresentationSector, long lngFramesWritten) {
        Fraction movieTime;
        Fraction presentationTime = this.calcPresentationTime(framePresentationSector);
        Fraction timeDiff = presentationTime.subtract(movieTime = this._secondsPerFrame.multiply(lngFramesWritten));
        Fraction framesDiff = timeDiff.divide(this._secondsPerFrame);
        int iFrameCatchupNeeded = framesDiff.compareTo(NegPoint5) > 0 ? (int)Math.round(framesDiff.asDouble()) : (framesDiff.compareTo(NegPoint8) > 0 ? 0 : (int)Math.round(framesDiff.asDouble()));
        return iFrameCatchupNeeded;
    }

    public int getInitialVideo() {
        return 0;
    }

    public long getFpsNum() {
        return this.getSecondsPerFrame().getDenominator();
    }

    public long getFpsDenom() {
        return this.getSecondsPerFrame().getNumerator();
    }
}

