/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.save;

import com.jhlabs.awt.ParagraphLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.File;
import javax.annotation.Nonnull;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jpsxdec.discitems.CombinedBuilderListener;
import jpsxdec.discitems.ParagraphPanel;
import jpsxdec.i18n.I;
import jpsxdec.modules.video.save.MdecDecodeQuality;
import jpsxdec.modules.video.save.VideoSaverBuilder;
import jpsxdec.psxvideo.mdec.ChromaUpsample;
import jpsxdec.util.Fraction;

public abstract class VideoSaverPanel<T extends VideoSaverBuilder>
extends ParagraphPanel {
    @Nonnull
    protected final CombinedBuilderListener<T> _bl;

    protected VideoSaverPanel(@Nonnull CombinedBuilderListener<T> bl) {
        this._bl = bl;
        this._bl.addListeners(new FileName(), new VideoFormat(), new Crop(), new DiscSpeed(), new DecodeQuality(), new ChromaUpsampling());
    }

    static /* synthetic */ JTextArea access$000(int x0) {
        return VideoSaverPanel.makeMultiLineJLabel(x0);
    }

    private class FileName
    implements ChangeListener {
        final JLabel __label = new JLabel(I.GUI_SAVE_AS_LABEL().getLocalizedMessage());
        final JTextArea __files = VideoSaverPanel.access$000(2);

        public FileName() {
            VideoSaverPanel.this.add((Component)this.__label, ParagraphLayout.NEW_PARAGRAPH);
            VideoSaverPanel.this.add((Component)this.__files, ParagraphLayout.STRETCH_H);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateEndings();
        }

        private void updateEndings() {
            File[] aoFiles = ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getOutputFileRange();
            if (aoFiles.length == 1) {
                String sPath = aoFiles[0].toString();
                if (!sPath.equals(this.__files.getText())) {
                    this.__files.setText(sPath);
                }
            } else {
                String s = I.GUI_OUTPUT_VIDEO_FILE_RANGE(aoFiles[0], aoFiles[1]).getLocalizedMessage();
                if (!s.equals(this.__files.getText())) {
                    this.__files.setText(s);
                }
            }
        }
    }

    private class DiscSpeed
    implements ChangeListener,
    ActionListener {
        final ButtonGroup __grp = new ButtonGroup();
        final JLabel __label = new JLabel(I.GUI_DISC_SPEED_LABEL().getLocalizedMessage());
        final JLabel __fps = new JLabel();
        boolean __cur;
        final JRadioButton __1x = new JRadioButton(I.DISC_SPEED_1X().getLocalizedMessage());
        final JRadioButton __2x = new JRadioButton(I.DISC_SPEED_2X().getLocalizedMessage());

        public DiscSpeed() {
            VideoSaverPanel.this.add((Component)this.__label, ParagraphLayout.NEW_PARAGRAPH);
            VideoSaverPanel.this.add(this.__1x);
            VideoSaverPanel.this.add(this.__2x);
            this.__grp.add(this.__1x);
            this.__grp.add(this.__2x);
            this.__1x.addActionListener(this);
            this.__2x.addActionListener(this);
            VideoSaverPanel.this.add(this.__fps);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateFps();
            boolean blnEnabled = ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getSingleSpeed_enabled();
            this.__label.setEnabled(blnEnabled);
            this.__1x.setEnabled(blnEnabled);
            this.__2x.setEnabled(blnEnabled);
            if (((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getSingleSpeed()) {
                this.__grp.setSelected(this.__1x.getModel(), true);
            } else {
                this.__grp.setSelected(this.__2x.getModel(), true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.__1x) {
                ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).setSingleSpeed(true);
            } else {
                ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).setSingleSpeed(false);
            }
        }

        private void updateFps() {
            Fraction fps = ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getFps();
            if (fps.getNumerator() % fps.getDenominator() == 0L) {
                this.__fps.setText(I.GUI_FPS_LABLE_WHOLE_NUMBER(fps.getNumerator() / fps.getDenominator()).getLocalizedMessage());
            } else {
                this.__fps.setText(I.GUI_FPS_LABEL_FRACTION(fps.asDouble(), fps.getNumerator(), fps.getDenominator()).getLocalizedMessage());
            }
        }
    }

    private class Crop
    extends JToggleButton.ToggleButtonModel
    implements ChangeListener {
        final JCheckBox __chk = new JCheckBox(I.GUI_CROP_CHECKBOX().getLocalizedMessage());
        final JLabel __label = new JLabel(I.GUI_DIMENSIONS_LABEL().getLocalizedMessage());
        @Nonnull
        final JLabel __dims;
        boolean __cur = this.isSelected();

        public Crop() {
            this.__chk.setModel(null);
            this.__dims = new JLabel(I.GUI_DIMENSIONS_WIDTH_X_HEIGHT_LABEL(((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getWidth(), ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getHeight()).getLocalizedMessage());
            VideoSaverPanel.this.add((Component)this.__label, ParagraphLayout.NEW_PARAGRAPH);
            VideoSaverPanel.this.add(this.__dims);
            VideoSaverPanel.this.add(this.__chk);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.__chk.getModel() == null) {
                this.__chk.setModel(this);
            }
            if (this.isSelected() != this.__cur) {
                this.__cur = this.isSelected();
                this.fireStateChanged();
                this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
            }
            this.__dims.setText(I.GUI_DIMENSIONS_WIDTH_X_HEIGHT_LABEL(((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getWidth(), ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getHeight()).getLocalizedMessage());
        }

        @Override
        public boolean isSelected() {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getCrop();
        }

        @Override
        public void setSelected(boolean b) {
            ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).setCrop(b);
        }

        @Override
        public boolean isEnabled() {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getCrop_enabled();
        }
    }

    private class ChromaUpsampling
    extends ParagraphPanel.AbstractCombo {
        public ChromaUpsampling() {
            super(I.GUI_CHROMA_UPSAMPLING_LABEL(), true);
        }

        @Override
        public int getSize() {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getChromaInterpolation_listSize();
        }

        @Override
        public Object getElementAt(int index) {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getChromaInterpolation_listItem(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).setChromaInterpolation((ChromaUpsample)((Object)anItem));
        }

        @Override
        public Object getSelectedItem() {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getChromaInterpolation();
        }

        @Override
        protected boolean getEnabled() {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getChromaInterpolation_enabled();
        }
    }

    private class DecodeQuality
    extends ParagraphPanel.AbstractCombo {
        public DecodeQuality() {
            super(I.GUI_DECODE_QUALITY_LABEL(), true);
        }

        @Override
        public int getSize() {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getDecodeQuality_listSize();
        }

        @Override
        public Object getElementAt(int index) {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getDecodeQuality_listItem(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).setDecodeQuality((MdecDecodeQuality)((Object)anItem));
        }

        @Override
        public Object getSelectedItem() {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getDecodeQuality();
        }

        @Override
        protected boolean getEnabled() {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getDecodeQuality_enabled();
        }
    }

    private class VideoFormat
    extends ParagraphPanel.AbstractCombo {
        public VideoFormat() {
            super(I.GUI_VIDEO_FORMAT_LABEL(), true);
        }

        @Override
        public int getSize() {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getVideoFormat_listSize();
        }

        @Override
        public Object getElementAt(int index) {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getVideoFormat_listItem(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).setVideoFormat((jpsxdec.modules.video.save.VideoFormat)((Object)anItem));
        }

        @Override
        public Object getSelectedItem() {
            return ((VideoSaverBuilder)VideoSaverPanel.this._bl.getBuilder()).getVideoFormat();
        }

        @Override
        protected boolean getEnabled() {
            return true;
        }
    }
}

