/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.save;

import argparser.BooleanHolder;
import argparser.StringHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.TabularFeedback;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.modules.video.DiscItemVideoStream;
import jpsxdec.modules.video.framenumber.FormattedFrameNumber;
import jpsxdec.modules.video.framenumber.FrameLookup;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.save.MdecDecodeQuality;
import jpsxdec.modules.video.save.VDP;
import jpsxdec.modules.video.save.VideoFileNameFormatter;
import jpsxdec.modules.video.save.VideoFormat;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.ChromaUpsample;
import jpsxdec.util.ArgParser;
import jpsxdec.util.Fraction;
import jpsxdec.util.TaskCanceledException;

public abstract class VideoSaverBuilder
extends DiscItemSaverBuilder {
    private static final Logger LOG = Logger.getLogger(VideoSaverBuilder.class.getName());
    @Nonnull
    private final DiscItemVideoStream _sourceVidItem;
    private final List<VideoFormat> _imgFmtList = VideoFormat.getAvailable();
    private final List<VideoFormat> _imgFmtListNoBs;
    private boolean _blnSingleSpeed = false;
    @Nonnull
    private VideoFormat _videoFormat = VideoFormat.AVI_MJPG;
    private boolean _blnCrop = true;
    @CheckForNull
    private MdecDecodeQuality _decodeQuality = MdecDecodeQuality.HIGH;
    @Nonnull
    private ChromaUpsample _mdecUpsampler = ChromaUpsample.Bicubic;
    private final List<FrameNumber.Type> _types;
    @Nonnull
    private FrameNumber.Type _frameNumberType = FrameNumber.Type.Index;
    @CheckForNull
    private FrameLookup _saveStartFrame = null;
    @CheckForNull
    private FrameLookup _saveEndFrame = null;
    protected final VDP.GeneratedFileListener thisGeneratedFileListener = new VDP.GeneratedFileListener(){

        @Override
        public void fileGenerated(File f) {
            VideoSaverBuilder.this.addGeneratedFile(f);
        }
    };
    private double _dblAudioVolume = 1.0;

    protected VideoSaverBuilder(@Nonnull DiscItemVideoStream vidItem) {
        this._sourceVidItem = vidItem;
        this._types = vidItem.getFrameNumberTypes();
        this._imgFmtListNoBs = new ArrayList<VideoFormat>(this._imgFmtList);
        this._imgFmtListNoBs.remove((Object)VideoFormat.IMGSEQ_BITSTREAM);
    }

    @Override
    public boolean copySettingsTo(@Nonnull DiscItemSaverBuilder otherBuilder) {
        if (otherBuilder instanceof VideoSaverBuilder) {
            VideoSaverBuilder other = (VideoSaverBuilder)otherBuilder;
            other.setVideoFormat(this.getVideoFormat());
            if (this.getCrop_enabled()) {
                other.setCrop(this.getCrop());
            }
            if (this.getDecodeQuality_enabled()) {
                other.setDecodeQuality(this.getDecodeQuality());
            }
            if (this.getChromaInterpolation_enabled()) {
                other.setChromaInterpolation(this.getChromaInterpolation());
            }
            if (this.getSingleSpeed_enabled()) {
                other.setSingleSpeed(this.getSingleSpeed());
            }
            if (this.getAudioVolume_enabled()) {
                other.setAudioVolume(this.getAudioVolume());
            }
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public DiscItemVideoStream getDiscItem() {
        return this._sourceVidItem;
    }

    @Nonnull
    public File[] getOutputFileRange() {
        VideoFormat vf = this.getVideoFormat();
        if (vf.isAvi()) {
            return new File[]{VideoFileNameFormatter.singleFile(null, this._sourceVidItem, vf)};
        }
        VideoFileNameFormatter ff = new VideoFileNameFormatter(null, this._sourceVidItem, vf, false);
        FrameNumber startFrame = this._sourceVidItem.getStartFrame();
        FrameNumber endFrame = this._sourceVidItem.getEndFrame();
        FormattedFrameNumber start = startFrame.getNumber(this.getFileNumberType());
        if (start == null) {
            throw new IllegalStateException("Video should have had a start and end header frame number type");
        }
        if (startFrame.equalValue(endFrame)) {
            return new File[]{ff.format(start, null)};
        }
        FormattedFrameNumber end = endFrame.getNumber(this.getFileNumberType());
        if (end == null) {
            throw new IllegalStateException("Video should have had a start and end header frame number type");
        }
        return new File[]{ff.format(start, null), ff.format(end, null)};
    }

    public boolean getSingleSpeed() {
        switch (this.findDiscSpeed()) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return this._blnSingleSpeed;
    }

    private int findDiscSpeed() {
        return this._sourceVidItem.getDiscSpeed();
    }

    public void setSingleSpeed(boolean val) {
        this._blnSingleSpeed = val;
        this.firePossibleChange();
    }

    public boolean getSingleSpeed_enabled() {
        return this.getVideoFormat().isAvi() && this.findDiscSpeed() < 1;
    }

    @Nonnull
    public Fraction getFps() {
        return Fraction.divide(this.getSingleSpeed() ? 75L : 150L, this._sourceVidItem.getSectorsPerFrame());
    }

    @Nonnull
    public VideoFormat getVideoFormat_listItem(int i) {
        if (this._sourceVidItem.hasIndependentBitstream()) {
            return this._imgFmtList.get(i);
        }
        return this._imgFmtListNoBs.get(i);
    }

    public int getVideoFormat_listSize() {
        if (this._sourceVidItem.hasIndependentBitstream()) {
            return this._imgFmtList.size();
        }
        return this._imgFmtListNoBs.size();
    }

    @Nonnull
    public VideoFormat getVideoFormat() {
        return this._videoFormat;
    }

    public void setVideoFormat(@Nonnull VideoFormat val) {
        if (this._sourceVidItem.hasIndependentBitstream() ? !this._imgFmtList.contains((Object)val) : !this._imgFmtListNoBs.contains((Object)val)) {
            throw new IllegalArgumentException();
        }
        this._videoFormat = val;
        this.firePossibleChange();
    }

    public boolean getCrop() {
        if (this.getCrop_enabled()) {
            return this._blnCrop;
        }
        return false;
    }

    public void setCrop(boolean val) {
        this._blnCrop = val;
        this.firePossibleChange();
    }

    public boolean getCrop_enabled() {
        return this._sourceVidItem.shouldBeCropped() && this.getVideoFormat().isCroppable();
    }

    public int getWidth() {
        if (this.getCrop()) {
            if (this.getVideoFormat().mustHaveEvenDims() && this._sourceVidItem.getWidth() % 2 == 1) {
                return this._sourceVidItem.getWidth() + 1;
            }
            return this._sourceVidItem.getWidth();
        }
        return Calc.fullDimension(this._sourceVidItem.getWidth());
    }

    public int getHeight() {
        if (this.getCrop()) {
            if (this.getVideoFormat().mustHaveEvenDims() && this._sourceVidItem.getHeight() % 2 == 1) {
                return this._sourceVidItem.getHeight() + 1;
            }
            return this._sourceVidItem.getHeight();
        }
        return Calc.fullDimension(this._sourceVidItem.getHeight());
    }

    public boolean makingDimensionsEven() {
        return this.getCrop() && this.getVideoFormat().mustHaveEvenDims() && (this._sourceVidItem.getWidth() | this._sourceVidItem.getHeight() & 1) != 0;
    }

    public int getDecodeQuality_listSize() {
        return this.getVideoFormat().getDecodeQualityCount();
    }

    @Nonnull
    public MdecDecodeQuality getDecodeQuality_listItem(int i) {
        return this.getVideoFormat().getMdecDecodeQuality(i);
    }

    @CheckForNull
    public MdecDecodeQuality getDecodeQuality() {
        if (this.getVideoFormat().getDecodeQualityCount() == 1) {
            return this.getVideoFormat().getMdecDecodeQuality(0);
        }
        return this._decodeQuality;
    }

    public void setDecodeQuality(@Nonnull MdecDecodeQuality val) {
        this._decodeQuality = val;
        this.firePossibleChange();
    }

    public boolean getDecodeQuality_enabled() {
        return this.getVideoFormat().getDecodeQualityCount() > 1;
    }

    public boolean getChromaInterpolation_enabled() {
        MdecDecodeQuality q = this.getDecodeQuality();
        return this.getDecodeQuality_enabled() && q != null && q.canUpsample();
    }

    @Nonnull
    public ChromaUpsample getChromaInterpolation_listItem(int i) {
        return ChromaUpsample.values()[i];
    }

    public int getChromaInterpolation_listSize() {
        return ChromaUpsample.values().length;
    }

    @Nonnull
    public ChromaUpsample getChromaInterpolation() {
        if (this.getChromaInterpolation_enabled()) {
            return this._mdecUpsampler;
        }
        return ChromaUpsample.NearestNeighbor;
    }

    public void setChromaInterpolation(@Nonnull ChromaUpsample val) {
        this._mdecUpsampler = val;
        this.firePossibleChange();
    }

    public boolean getFileNumberType_enabled() {
        return !this.getVideoFormat().isAvi();
    }

    @CheckForNull
    public FrameNumber.Type getFileNumberType_listItem(int i) {
        if (this.getFileNumberType_enabled()) {
            return this._types.get(i);
        }
        return null;
    }

    public int getFileNumberType_listSize() {
        if (this.getFileNumberType_enabled()) {
            return this._types.size();
        }
        return 0;
    }

    @Nonnull
    public FrameNumber.Type getFileNumberType() {
        return this._frameNumberType;
    }

    public void setFileNumberType(@Nonnull FrameNumber.Type val) {
        this._frameNumberType = val;
        this.firePossibleChange();
    }

    @CheckForNull
    public FrameLookup getSaveStartFrame() {
        return this._saveStartFrame;
    }

    public void setSaveStartFrame(@CheckForNull FrameLookup val) {
        this._saveStartFrame = val;
        this.firePossibleChange();
    }

    @CheckForNull
    public FrameLookup getSaveEndFrame() {
        return this._saveEndFrame;
    }

    public void setSaveEndFrame(@CheckForNull FrameLookup val) {
        this._saveEndFrame = val;
        this.firePossibleChange();
    }

    @Override
    public final void printHelp(@Nonnull FeedbackStream fbs) {
        TabularFeedback tfb = new TabularFeedback();
        this.makeHelpTable(tfb);
        tfb.write(fbs.getUnderlyingStream());
    }

    protected void makeHelpTable(@Nonnull TabularFeedback tfb) {
        tfb.setRowSpacing(1);
        tfb.addCell(I.CMD_VIDEO_VF());
        TabularFeedback.Cell c = new TabularFeedback.Cell(I.CMD_VIDEO_VF_HELP(VideoFormat.AVI_MJPG.getCmdLine()));
        for (VideoFormat fmt : VideoFormat.getAvailable()) {
            c.addLine(fmt.getCmdLine(), 2);
        }
        tfb.addCell(c);
        tfb.newRow();
        tfb.addCell(I.CMD_VIDEO_QUALITY());
        c = new TabularFeedback.Cell(I.CMD_VIDEO_QUALITY_HELP(MdecDecodeQuality.HIGH.getCmdLine()));
        for (MdecDecodeQuality mdecDecodeQuality : MdecDecodeQuality.values()) {
            c.addLine(mdecDecodeQuality.getCmdLine(), 2);
        }
        tfb.addCell(c);
        tfb.newRow();
        tfb.addCell(I.CMD_VIDEO_UP());
        c = new TabularFeedback.Cell(I.CMD_VIDEO_UP_HELP(ChromaUpsample.Bicubic.getDescription()));
        for (Enum enum_ : ChromaUpsample.values()) {
            c.addLine(((ChromaUpsample)enum_).getCmdLineHelp(), 2);
        }
        tfb.addCell(c);
        if (this.getSingleSpeed_enabled()) {
            tfb.newRow();
            tfb.addCell(I.CMD_VIDEO_DS()).addCell(I.CMD_VIDEO_DS_HELP());
        }
        tfb.newRow();
        tfb.addCell(I.CMD_VIDEO_FRAMES()).addCell(I.CMD_VIDEO_FRAMES_HELP());
        if (this._sourceVidItem.shouldBeCropped()) {
            tfb.newRow();
            tfb.addCell(I.CMD_VIDEO_NOCROP()).addCell(I.CMD_VIDEO_NOCROP_HELP());
        }
        tfb.newRow();
        tfb.addCell(I.CMD_VIDEO_NUM());
        c = new TabularFeedback.Cell(I.CMD_VIDEO_NUM_HELP(FrameNumber.Type.Index.getLocalizedName()));
        for (FrameNumber.Type type : this._types) {
            c.addLine(type.getLocalizedName(), 2);
        }
        tfb.addCell(c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commandLineOptions(@Nonnull ArgParser ap, @Nonnull FeedbackStream fbs) {
        FrameLookup fl;
        if (!ap.hasRemaining()) {
            return;
        }
        StringHolder vidfmt = ap.addStringOption("-vidfmt", "-vf");
        BooleanHolder nocrop = ap.addBoolOption(false, "-nocrop");
        StringHolder quality = ap.addStringOption("-quality", "-q");
        StringHolder up = ap.addStringOption("-up");
        StringHolder discSpeed = ap.addStringOption("-ds");
        StringHolder startFrame = ap.addStringOption("-start");
        StringHolder endFrame = ap.addStringOption("-end");
        StringHolder num = ap.addStringOption("-num");
        ap.match();
        boolean blnHeaderFrameNumberIgnored = false;
        if (startFrame.value != null) {
            try {
                fl = new FrameLookup(startFrame.value);
                if (this._types.contains((Object)fl.getType())) {
                    this.setSaveStartFrame(fl);
                } else {
                    if (fl.getType() != FrameNumber.Type.Header) throw new RuntimeException("Only header type should ever be unsupported here");
                    blnHeaderFrameNumberIgnored = true;
                }
            }
            catch (LocalizedDeserializationFail ex) {
                fbs.printlnWarn(ex.getSourceMessage());
            }
        }
        if (endFrame.value != null) {
            try {
                fl = new FrameLookup(endFrame.value);
                if (this._types.contains((Object)fl.getType())) {
                    this.setSaveEndFrame(fl);
                } else {
                    if (fl.getType() != FrameNumber.Type.Header) throw new RuntimeException("Only header type should ever be unsupported here");
                    blnHeaderFrameNumberIgnored = true;
                }
            }
            catch (LocalizedDeserializationFail ex) {
                fbs.printlnWarn(ex.getSourceMessage());
            }
        }
        if (num.value != null) {
            FrameNumber.Type t = FrameNumber.Type.fromCmdLine(num.value);
            if (t != null) {
                if (this._types.contains((Object)t)) {
                    this.setFileNumberType(t);
                } else {
                    if (t != FrameNumber.Type.Header) throw new RuntimeException("Only header type should ever be unsupported here");
                    blnHeaderFrameNumberIgnored = true;
                }
            } else {
                fbs.printlnWarn(I.CMD_IGNORING_INVALID_VALUE_FOR_CMD(num.value, "-num"));
            }
        }
        if (blnHeaderFrameNumberIgnored) {
            fbs.printWarn(I.CMD_VIDEO_HEADER_FRAME_NUMBER_UNSUPPORTED());
        }
        if (vidfmt.value != null) {
            VideoFormat vf = VideoFormat.fromCmdLine(vidfmt.value);
            if (vf != null) {
                this.setVideoFormat(vf);
            } else {
                fbs.printlnWarn(I.CMD_IGNORING_INVALID_VALUE_FOR_CMD(vidfmt.value, "-vf,-vidfmt"));
            }
        }
        if (quality.value != null) {
            MdecDecodeQuality dq = MdecDecodeQuality.fromCmdLine(quality.value);
            if (dq != null) {
                this.setDecodeQuality(dq);
            } else {
                fbs.printlnWarn(I.CMD_IGNORING_INVALID_VALUE_FOR_CMD(quality.value, "-q,-quality"));
            }
        }
        if (up.value != null) {
            ChromaUpsample upsampler = ChromaUpsample.fromCmdLine(up.value);
            if (upsampler != null) {
                this.setChromaInterpolation(upsampler);
            } else {
                fbs.printlnWarn(I.CMD_IGNORING_INVALID_VALUE_FOR_CMD(up.value, "-up"));
            }
        }
        this.setCrop(!nocrop.value);
        if (discSpeed.value == null) return;
        if ("1".equals(discSpeed.value)) {
            this.setSingleSpeed(true);
            return;
        } else if ("2".equals(discSpeed.value)) {
            this.setSingleSpeed(false);
            return;
        } else {
            fbs.printWarn(I.CMD_IGNORING_INVALID_VALUE_FOR_CMD(discSpeed.value, "-ds"));
        }
    }

    @Override
    public void printSelectedOptions(@Nonnull ILocalizedLogger log) {
        VideoFormat vidFmt = this.getVideoFormat();
        log.log(Level.INFO, I.CMD_VIDEO_FORMAT(this.getVideoFormat().toString()));
        if (vidFmt.getDecodeQualityCount() > 0) {
            MdecDecodeQuality quality = this.getDecodeQuality();
            log.log(Level.INFO, I.CMD_DECODE_QUALITY(quality.toString()));
            if (quality.canUpsample()) {
                ChromaUpsample chroma = this.getChromaInterpolation();
                log.log(Level.INFO, I.CMD_UPSAMPLE_QUALITY(chroma.getDescription().getLocalizedMessage()));
            }
        }
        if (this.getCrop_enabled()) {
            log.log(Level.INFO, I.CMD_CROPPING(this.getCrop() ? 1 : 0));
        }
        if (this.makingDimensionsEven()) {
            log.log(Level.INFO, I.CMD_VIDEO_MUST_HAVE_EVEN_DIMS(this.getVideoFormat().toString()));
        }
        log.log(Level.INFO, I.CMD_DIMENSIONS(this.getWidth(), this.getHeight()));
        if (vidFmt.isSequence()) {
            File[] _aoOutRng = this.getOutputFileRange();
            if (_aoOutRng.length == 1) {
                log.log(Level.INFO, I.CMD_OUTPUT_FILE(_aoOutRng[0]));
            } else {
                log.log(Level.INFO, I.CMD_OUTPUT_FILES(_aoOutRng[0], _aoOutRng[1]));
            }
        } else {
            File outFile = VideoFileNameFormatter.singleFile(null, this._sourceVidItem, vidFmt);
            log.log(Level.INFO, I.CMD_DISC_SPEED(this.getSingleSpeed() ? 1 : 2, this.getFps().asDouble()));
            if (this.getSavingAudio()) {
                log.log(Level.INFO, I.CMD_SAVING_WITH_AUDIO_ITEMS());
                this.printSelectedAudioOptions(log);
                log.log(Level.INFO, I.CMD_EMULATE_PSX_AV_SYNC_NY(this.getEmulatePsxAvSync() ? 1 : 0));
            } else {
                log.log(Level.INFO, I.CMD_NO_AUDIO());
            }
            log.log(Level.INFO, I.CMD_SAVING_AS(outFile));
        }
        FrameLookup startFrame = this.getSaveStartFrame();
        FrameLookup endFrame = this.getSaveEndFrame();
        if (startFrame != null) {
            log.log(Level.INFO, I.CMD_FRAME_RANGE_BEFORE(startFrame.toString()));
        }
        if (endFrame != null) {
            log.log(Level.INFO, I.CMD_FRAME_RANGE_AFTER(endFrame.toString()));
        }
    }

    protected abstract void printSelectedAudioOptions(@Nonnull ILocalizedLogger var1);

    @Override
    @Nonnull
    public ILocalizedMessage getOutputSummary() {
        if (this.getVideoFormat().isSequence()) {
            File[] _aoOutRng = this.getOutputFileRange();
            if (_aoOutRng.length == 1) {
                return new UnlocalizedMessage(_aoOutRng[0].toString());
            }
            return I.VID_RANGE_OF_FILES_TO_SAVE(_aoOutRng[0], _aoOutRng[1]);
        }
        File outFile = VideoFileNameFormatter.singleFile(null, this._sourceVidItem, this.getVideoFormat());
        return new UnlocalizedMessage(outFile.getPath());
    }

    @Override
    public abstract void startSave(@Nonnull ProgressLogger var1, @CheckForNull File var2) throws LoggedFailure, TaskCanceledException;

    public double getAudioVolume() {
        return this._dblAudioVolume;
    }

    public void setAudioVolume(double val) {
        this._dblAudioVolume = Math.min(Math.max(0.0, val), 1.0);
        this.firePossibleChange();
    }

    public abstract boolean getAudioVolume_enabled();

    public abstract boolean hasAudio();

    public abstract boolean getSavingAudio();

    public abstract boolean getEmulatePsxAvSync();
}

