/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.save;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.formats.JavaImageFormat;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.exception.LocalizedFileNotFoundException;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.sharedaudio.ISectorAudioDecoder;
import jpsxdec.modules.video.DiscItemVideoStream;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.ISectorClaimToDemuxedFrame;
import jpsxdec.modules.video.framenumber.FormattedFrameNumber;
import jpsxdec.modules.video.framenumber.FrameCompareIs;
import jpsxdec.modules.video.framenumber.FrameLookup;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.save.AudioVideoSync;
import jpsxdec.modules.video.save.AutowireVDP;
import jpsxdec.modules.video.save.Frame2Bitstream;
import jpsxdec.modules.video.save.MdecDecodeQuality;
import jpsxdec.modules.video.save.VDP;
import jpsxdec.modules.video.save.VideoFileNameFormatter;
import jpsxdec.modules.video.save.VideoFormat;
import jpsxdec.modules.video.save.VideoSaverBuilder;
import jpsxdec.modules.video.save.VideoSync;
import jpsxdec.psxvideo.mdec.ChromaUpsample;
import jpsxdec.psxvideo.mdec.MdecDecoder;
import jpsxdec.psxvideo.mdec.MdecDecoder_double;
import jpsxdec.util.IO;
import jpsxdec.util.TaskCanceledException;

public class VideoSaver {
    private static final Logger LOG = Logger.getLogger(VideoSaver.class.getName());
    @Nonnull
    private final DiscItemVideoStream _vidItem;
    @Nonnull
    private final VideoSaverBuilder _vsb;
    @Nonnull
    private final VideoFormat _videoFormat;
    @CheckForNull
    private final File _directory;
    private final AutowireVDP _pipeline = new AutowireVDP();
    private final int _iStartSector;
    private final int _iEndSector;
    @Nonnull
    private final FrameToBitstreamFilter _frame2bitstream;
    @CheckForNull
    private final ISectorAudioDecoder _audioDecoder;

    public VideoSaver(@Nonnull DiscItemVideoStream vidItem, @Nonnull VideoSaverBuilder vsb, @Nonnull VDP.GeneratedFileListener genFileListener, @CheckForNull File directory, @Nonnull ILocalizedLogger log, @Nonnull ISectorClaimToDemuxedFrame demuxer, @CheckForNull ISectorAudioDecoder audioDecoder) {
        this._vidItem = vidItem;
        this._vsb = vsb;
        this._videoFormat = vsb.getVideoFormat();
        this._directory = directory;
        this._audioDecoder = audioDecoder;
        this._pipeline.setMap(demuxer);
        this._pipeline.setFileListener(genFileListener);
        VDP.ToAvi toAvi = null;
        switch (this._videoFormat) {
            case IMGSEQ_BITSTREAM: {
                VDP.Bitstream2File bs2f = new VDP.Bitstream2File(this.makeFormatter(), log);
                this._pipeline.setMap(bs2f);
                break;
            }
            case IMGSEQ_MDEC: {
                this.addBitstream2Mdec();
                VDP.Mdec2File m2f = new VDP.Mdec2File(this.makeFormatter(), this._vsb.getWidth(), this._vsb.getHeight(), log);
                this._pipeline.setMap(m2f);
                break;
            }
            case IMGSEQ_BMP: 
            case IMGSEQ_PNG: 
            case IMGSEQ_TIFF: {
                this.addBitstream2Mdec();
                this.addMdec2Decoded(log);
                JavaImageFormat javaImgFmt = this._videoFormat.getImgFmt();
                VDP.Decoded2JavaImage d2j = new VDP.Decoded2JavaImage(this.makeFormatter(), javaImgFmt, this._vsb.getWidth(), this._vsb.getHeight(), log);
                this._pipeline.setMap(d2j);
                break;
            }
            case IMGSEQ_JPG: {
                this.addBitstream2Mdec();
                VDP.Mdec2Jpeg m2jpg = new VDP.Mdec2Jpeg(this.makeFormatter(), this._vsb.getWidth(), this._vsb.getHeight(), log);
                this._pipeline.setMap(m2jpg);
                break;
            }
            case AVI_MJPG: {
                this.addBitstream2Mdec();
                VDP.Mdec2MjpegAvi m2mjpg = this._audioDecoder == null ? new VDP.Mdec2MjpegAvi(this.getAviFile(), this._vsb.getWidth(), this._vsb.getHeight(), this.makeVSync(), log) : new VDP.Mdec2MjpegAvi(this.getAviFile(), this._vsb.getWidth(), this._vsb.getHeight(), this.makeAvSync(this._audioDecoder), this._audioDecoder.getOutputFormat(), log);
                this._pipeline.setToAvi(m2mjpg);
                toAvi = m2mjpg;
                break;
            }
            case AVI_JYUV: {
                this.addBitstream2Mdec();
                this.addMdec2Decoded(log);
                VDP.Decoded2JYuvAvi d2jyuv = this._audioDecoder == null ? new VDP.Decoded2JYuvAvi(this.getAviFile(), this._vsb.getWidth(), this._vsb.getHeight(), this.makeVSync(), log) : new VDP.Decoded2JYuvAvi(this.getAviFile(), this._vsb.getWidth(), this._vsb.getHeight(), this.makeAvSync(this._audioDecoder), this._audioDecoder.getOutputFormat(), log);
                this._pipeline.setToAvi(d2jyuv);
                toAvi = d2jyuv;
                break;
            }
            case AVI_YUV: {
                this.addBitstream2Mdec();
                this.addMdec2Decoded(log);
                VDP.Decoded2YuvAvi d2yuv = this._audioDecoder == null ? new VDP.Decoded2YuvAvi(this.getAviFile(), this._vsb.getWidth(), this._vsb.getHeight(), this.makeVSync(), log) : new VDP.Decoded2YuvAvi(this.getAviFile(), this._vsb.getWidth(), this._vsb.getHeight(), this.makeAvSync(this._audioDecoder), this._audioDecoder.getOutputFormat(), log);
                this._pipeline.setToAvi(d2yuv);
                toAvi = d2yuv;
                break;
            }
            case AVI_RGB: {
                this.addBitstream2Mdec();
                this.addMdec2Decoded(log);
                VDP.Decoded2RgbAvi d2rgb = this._audioDecoder == null ? new VDP.Decoded2RgbAvi(this.getAviFile(), this._vsb.getWidth(), this._vsb.getHeight(), this.makeVSync(), log) : new VDP.Decoded2RgbAvi(this.getAviFile(), this._vsb.getWidth(), this._vsb.getHeight(), this.makeAvSync(this._audioDecoder), this._audioDecoder.getOutputFormat(), log);
                this._pipeline.setToAvi(d2rgb);
                toAvi = d2rgb;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (this._audioDecoder == null) {
            this._iStartSector = this._vidItem.getStartSector();
            this._iEndSector = this._vidItem.getEndSector();
            this._frame2bitstream = new FrameToBitstreamFilter(this._vsb.getFileNumberType(), this._vsb.getSaveStartFrame(), this._vsb.getSaveEndFrame(), log);
        } else {
            this._pipeline.setAudioDecoder(this._audioDecoder);
            if (toAvi != null) {
                this._pipeline.setAudioPacketListener(toAvi);
            }
            this._iStartSector = Math.min(this._vidItem.getStartSector(), this._audioDecoder.getStartSector());
            this._iEndSector = Math.max(this._vidItem.getEndSector(), this._audioDecoder.getEndSector());
            this._frame2bitstream = new FrameToBitstreamFilter(this._vsb.getFileNumberType(), null, null, log);
        }
        this._pipeline.setMap(this._frame2bitstream);
    }

    private void addBitstream2Mdec() {
        VDP.Bitstream2Mdec bs2m = new VDP.Bitstream2Mdec();
        this._pipeline.setMap(bs2m);
    }

    private void addMdec2Decoded(@Nonnull ILocalizedLogger log) {
        MdecDecodeQuality quality = this._vsb.getDecodeQuality();
        MdecDecoder vidDecoder = quality.makeDecoder(this._vidItem.getWidth(), this._vidItem.getHeight());
        if (vidDecoder instanceof MdecDecoder_double) {
            ChromaUpsample chroma = this._vsb.getChromaInterpolation();
            ((MdecDecoder_double)vidDecoder).setUpsampler(chroma);
        }
        VDP.Mdec2Decoded mdec2decode = new VDP.Mdec2Decoded(vidDecoder, log);
        this._pipeline.setMap(mdec2decode);
    }

    private void startup(@Nonnull ILocalizedLogger log) throws LoggedFailure {
        VDP.ToAvi avi = this._pipeline.getAvi();
        if (avi != null) {
            try {
                avi.open();
            }
            catch (LocalizedFileNotFoundException ex) {
                throw new LoggedFailure(log, Level.SEVERE, ex.getSourceMessage(), ex);
            }
            catch (FileNotFoundException ex) {
                throw new LoggedFailure(log, Level.SEVERE, I.IO_OPENING_FILE_ERROR_NAME(avi.getOutputFile().toString()), ex);
            }
            catch (IOException ex) {
                throw new LoggedFailure(log, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(avi.getOutputFile().toString()), ex);
            }
        }
    }

    private void shutdown() {
        VDP.ToAvi avi = this._pipeline.getAvi();
        if (avi != null) {
            IO.closeSilently(avi, LOG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@Nonnull ProgressLogger pl) throws LoggedFailure, TaskCanceledException {
        SectorClaimSystem it = SectorClaimSystem.create(this._vidItem.getSourceCd(), this._iStartSector, this._iEndSector);
        this._pipeline.attachToSectorClaimer(it);
        this._pipeline.autowire();
        pl.progressStart(this._iEndSector - this._iStartSector + 1);
        this.startup(pl);
        try {
            int iSector = 0;
            while (it.hasNext()) {
                try {
                    IIdentifiedSector identifiedSector = it.next(pl);
                }
                catch (CdFileSectorReader.CdReadException ex) {
                    throw new LoggedFailure(pl, Level.SEVERE, I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), ex);
                }
                this.sendLogEvent(pl, this._frame2bitstream);
                pl.progressUpdate(iSector);
                if (this._frame2bitstream.isDone()) break;
                ++iSector;
            }
            it.close(pl);
            this.sendLogEvent(pl, this._frame2bitstream);
            pl.progressEnd();
        }
        finally {
            this.shutdown();
        }
    }

    @Nonnull
    private void sendLogEvent(@Nonnull ProgressLogger pl, @Nonnull FrameToBitstreamFilter f2bs) {
        if (!pl.isSeekingEvent()) {
            return;
        }
        FrameNumber curFrm = f2bs.getCurrentFrame();
        if (curFrm == null) {
            return;
        }
        ILocalizedMessage msg = curFrm.getDescription(this._vsb.getFileNumberType());
        if (msg == null) {
            LOG.log(Level.SEVERE, "The frame builder says to use {0} but the frame {1} does not have it", new Object[]{this._vsb.getFileNumberType(), curFrm});
            msg = curFrm.getIndexDescription();
        }
        pl.event(msg);
    }

    @Nonnull
    private VideoSync makeVSync() {
        VideoSync vidSync = new VideoSync(this._vidItem.getAbsolutePresentationStartSector(), this.getSectorsPerSecond(), this._vidItem.getSectorsPerFrame());
        return vidSync;
    }

    private int getSectorsPerSecond() {
        return this._vsb.getSingleSpeed() ? 75 : 150;
    }

    @Nonnull
    private AudioVideoSync makeAvSync(@Nonnull ISectorAudioDecoder audio) {
        AudioVideoSync avSync = new AudioVideoSync(this._vidItem.getAbsolutePresentationStartSector(), this.getSectorsPerSecond(), this._vidItem.getSectorsPerFrame(), audio.getAbsolutePresentationStartSector(), audio.getSampleFramesPerSecond(), this._vsb.getEmulatePsxAvSync());
        return avSync;
    }

    @Nonnull
    private File getAviFile() {
        return VideoFileNameFormatter.singleFile(this._directory, this._vidItem, this._videoFormat);
    }

    @Nonnull
    private VideoFileNameFormatter makeFormatter() {
        return new VideoFileNameFormatter(this._directory, this._vidItem, this._videoFormat, false);
    }

    private static class FrameToBitstreamFilter
    extends Frame2Bitstream {
        @CheckForNull
        private final FrameLookup _startFrame;
        @CheckForNull
        private final FrameLookup _endFrame;
        @Nonnull
        private final ILocalizedLogger _log;
        @CheckForNull
        private FrameNumber _currentFrame = null;
        private boolean _blnIsDone = false;

        public FrameToBitstreamFilter(@Nonnull FrameNumber.Type frameNumberType, @CheckForNull FrameLookup startFrame, @CheckForNull FrameLookup endFrame, @Nonnull ILocalizedLogger log) {
            super(frameNumberType);
            this._startFrame = startFrame;
            this._endFrame = endFrame;
            this._log = log;
        }

        @Override
        public void frameComplete(@Nonnull IDemuxedFrame frame) throws LoggedFailure {
            this._currentFrame = frame.getFrame();
            if (this._startFrame != null && this._startFrame.compareTo(this._currentFrame) == FrameCompareIs.GREATERTHAN) {
                return;
            }
            if (this._endFrame != null && this._endFrame.compareTo(this._currentFrame) == FrameCompareIs.LESSTHAN) {
                this._blnIsDone = true;
                return;
            }
            FormattedFrameNumber ffn = frame.getFrame().getNumber(this.getFrameNumberType());
            if (ffn == null) {
                this._log.log(Level.SEVERE, I.FRAME_MISSING_FRAME_NUMBER_HEADER(frame.getFrame().getIndexNumber().getFrameValue()));
            }
            super.frameComplete(frame);
        }

        @CheckForNull
        public FrameNumber getCurrentFrame() {
            return this._currentFrame;
        }

        public boolean isDone() {
            return this._blnIsDone;
        }
    }
}

