/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.save;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.formats.JavaImageFormat;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.modules.video.save.MdecDecodeQuality;

public enum VideoFormat {
    AVI_MJPG(I.VID_AVI_MJPG_DESCRIPTION(), I.VID_AVI_MJPG_COMMAND()){

        @Override
        public String getExtension() {
            return ".avi";
        }

        @Override
        public boolean isAvi() {
            return true;
        }

        @Override
        public int getDecodeQualityCount() {
            return 0;
        }

        @Override
        public MdecDecodeQuality getMdecDecodeQuality(int i) {
            throw new IndexOutOfBoundsException();
        }
    }
    ,
    AVI_RGB(I.VID_AVI_RGB_DESCRIPTION(), I.VID_AVI_RGB_COMMAND()){

        @Override
        public String getExtension() {
            return ".avi";
        }

        @Override
        public boolean isAvi() {
            return true;
        }
    }
    ,
    AVI_YUV(I.VID_AVI_YUV_DESCRIPTION(), I.VID_AVI_YUV_COMMAND()){

        @Override
        public String getExtension() {
            return ".avi";
        }

        @Override
        public boolean isAvi() {
            return true;
        }

        @Override
        public int getDecodeQualityCount() {
            return 1;
        }

        @Override
        public MdecDecodeQuality getMdecDecodeQuality(int i) {
            return MdecDecodeQuality.HIGH;
        }

        @Override
        public boolean mustHaveEvenDims() {
            return true;
        }
    }
    ,
    AVI_JYUV(I.VID_AVI_JYUV_DESCRIPTION(), I.VID_AVI_JYUV_COMMAND()){

        @Override
        public String getExtension() {
            return ".avi";
        }

        @Override
        public boolean isAvi() {
            return true;
        }

        @Override
        public int getDecodeQualityCount() {
            return 1;
        }

        @Override
        public MdecDecodeQuality getMdecDecodeQuality(int i) {
            return MdecDecodeQuality.HIGH;
        }

        @Override
        public boolean mustHaveEvenDims() {
            return true;
        }
    }
    ,
    IMGSEQ_PNG(I.VID_IMG_SEQ_PNG_DESCRIPTION(), I.VID_IMG_SEQ_PNG_COMMAND(), JavaImageFormat.PNG){

        @Override
        public String getExtension() {
            return "." + JavaImageFormat.PNG.getExtension();
        }
    }
    ,
    IMGSEQ_JPG(I.VID_IMG_SEQ_JPG_DESCRIPTION(), I.VID_IMG_SEQ_JPG_COMMAND()){

        @Override
        public String getExtension() {
            return ".jpg";
        }

        @Override
        public int getDecodeQualityCount() {
            return 0;
        }

        @Override
        public MdecDecodeQuality getMdecDecodeQuality(int i) {
            throw new IndexOutOfBoundsException();
        }
    }
    ,
    IMGSEQ_BMP(I.VID_IMG_SEQ_BMP_DESCRIPTION(), I.VID_IMG_SEQ_BMP_COMMAND(), JavaImageFormat.BMP){

        @Override
        public String getExtension() {
            return "." + JavaImageFormat.BMP.getExtension();
        }
    }
    ,
    IMGSEQ_TIFF(I.VID_IMG_SEQ_TIFF_DESCRIPTION(), I.VID_IMG_SEQ_TIFF_COMMAND(), JavaImageFormat.TIFF){

        @Override
        public String getExtension() {
            return "." + JavaImageFormat.TIFF.getExtension();
        }
    }
    ,
    IMGSEQ_BITSTREAM(I.VID_IMG_SEQ_BS_DESCRIPTION(), I.VID_IMG_SEQ_BS_COMMAND()){

        @Override
        public String getExtension() {
            return ".bs";
        }

        @Override
        public int getDecodeQualityCount() {
            return 0;
        }

        @Override
        public MdecDecodeQuality getMdecDecodeQuality(int i) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean isCroppable() {
            return false;
        }

        @Override
        public boolean needsDims() {
            return true;
        }
    }
    ,
    IMGSEQ_MDEC(I.VID_IMG_SEQ_MDEC_DESCRIPTION(), I.VID_IMG_SEQ_MDEC_COMMAND()){

        @Override
        public String getExtension() {
            return ".mdec";
        }

        @Override
        public int getDecodeQualityCount() {
            return 0;
        }

        @Override
        public MdecDecodeQuality getMdecDecodeQuality(int i) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean isCroppable() {
            return false;
        }

        @Override
        public boolean needsDims() {
            return true;
        }
    };

    @Nonnull
    private final ILocalizedMessage _guiName;
    @Nonnull
    private final ILocalizedMessage _cmdLineId;
    @CheckForNull
    private final JavaImageFormat _eImgFmt;

    private VideoFormat(ILocalizedMessage description, ILocalizedMessage cmdLine) {
        this(description, cmdLine, (JavaImageFormat)null);
    }

    private VideoFormat(@CheckForNull ILocalizedMessage description, ILocalizedMessage cmdLine, JavaImageFormat imgFormat) {
        this._guiName = description;
        this._cmdLineId = cmdLine;
        this._eImgFmt = imgFormat;
    }

    public String toString() {
        return this._guiName.getLocalizedMessage();
    }

    @Nonnull
    public ILocalizedMessage getCmdLine() {
        return this._cmdLineId;
    }

    public boolean isAvailable() {
        return this._eImgFmt == null ? true : this._eImgFmt.isAvailable();
    }

    public boolean isCroppable() {
        return true;
    }

    public boolean mustHaveEvenDims() {
        return false;
    }

    public int getDecodeQualityCount() {
        return MdecDecodeQuality.values().length;
    }

    @Nonnull
    public MdecDecodeQuality getMdecDecodeQuality(int i) {
        return MdecDecodeQuality.values()[i];
    }

    public boolean isAvi() {
        return false;
    }

    public boolean isSequence() {
        return !this.isAvi();
    }

    @CheckForNull
    public JavaImageFormat getImgFmt() {
        return this._eImgFmt;
    }

    public boolean needsDims() {
        return false;
    }

    @Nonnull
    public abstract String getExtension();

    @CheckForNull
    public static VideoFormat fromCmdLine(@Nonnull String sCmdLine) {
        for (VideoFormat fmt : VideoFormat.getAvailable()) {
            if (!fmt.getCmdLine().equalsIgnoreCase(sCmdLine)) continue;
            return fmt;
        }
        return null;
    }

    @Nonnull
    public static List<VideoFormat> getAvailable() {
        ArrayList<VideoFormat> avalable = new ArrayList<VideoFormat>();
        for (VideoFormat fmt : VideoFormat.values()) {
            if (!fmt.isAvailable()) continue;
            avalable.add(fmt);
        }
        return avalable;
    }
}

