/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.save;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.video.DiscItemVideoStream;
import jpsxdec.modules.video.framenumber.FormattedFrameNumber;
import jpsxdec.modules.video.save.VideoFormat;

public class VideoFileNameFormatter {
    private static final Logger LOG = Logger.getLogger(VideoFileNameFormatter.class.getName());
    @CheckForNull
    private final File _directory;
    @Nonnull
    private final String _sBaseName;
    @CheckForNull
    private final String _sDims;
    @Nonnull
    private final String _sExtension;
    private final boolean _blnIgnoreFrameNumbers;

    @Nonnull
    public static File singleFile(@CheckForNull File directory, @Nonnull DiscItemVideoStream vid, @Nonnull VideoFormat vf) {
        File baseName = vid.getSuggestedBaseName();
        StringBuilder sb = new StringBuilder(baseName.getName());
        if (vf.needsDims()) {
            sb.append('_').append(vid.getWidth()).append('x').append(vid.getHeight());
        }
        sb.append(vf.getExtension());
        String sBaseNameParent = baseName.getParent();
        if (sBaseNameParent == null) {
            return new File(directory, sb.toString());
        }
        return new File(new File(directory, sBaseNameParent), sb.toString());
    }

    public VideoFileNameFormatter(@CheckForNull File directory, @Nonnull String sBaseName, @Nonnull VideoFormat vf, int iWidth, int iHeight) {
        File basePath = new File(sBaseName);
        String sParent = basePath.getParent();
        this._directory = sParent != null ? new File(directory, sParent) : directory;
        this._sBaseName = basePath.getName();
        this._sDims = vf.needsDims() ? "_" + iWidth + "x" + iHeight : null;
        this._sExtension = vf.getExtension();
        this._blnIgnoreFrameNumbers = true;
    }

    public VideoFileNameFormatter(@CheckForNull File directory, @Nonnull DiscItemVideoStream videoItem, @Nonnull VideoFormat vf, boolean blnIgnoreFrameNumbers) {
        File basePath = videoItem.getSuggestedBaseName();
        String sParent = basePath.getParent();
        this._directory = sParent != null ? new File(directory, sParent) : directory;
        this._sBaseName = basePath.getName();
        this._sDims = vf.needsDims() ? "_" + videoItem.getWidth() + "x" + videoItem.getHeight() : null;
        this._sExtension = vf.getExtension();
        this._blnIgnoreFrameNumbers = blnIgnoreFrameNumbers;
    }

    @Nonnull
    public File format(@CheckForNull FormattedFrameNumber frameNumber, @CheckForNull ILocalizedLogger log) {
        if (!this._blnIgnoreFrameNumbers && frameNumber == null && log != null) {
            throw new IllegalArgumentException("Programmer error: formatter expected a frame");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._sBaseName);
        if (this._sDims != null) {
            sb.append(this._sDims);
        }
        if (!this._blnIgnoreFrameNumbers && frameNumber != null) {
            sb.append('[').append(frameNumber.toString()).append(']');
        }
        sb.append(this._sExtension);
        if (log != null && frameNumber != null && frameNumber.digitsAreOutOfBounds()) {
            log.log(Level.WARNING, I.FRAMES_UNEXPECTED_NUMBER());
            LOG.log(Level.WARNING, "Frame number {0} is greater than expected {1}, resulting frame file name {2} will have an inconsistent format", new Object[]{frameNumber.getUnpaddedValue(), frameNumber.getMaxFormat(), sb});
        }
        return new File(this._directory, sb.toString());
    }
}

