/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.save;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import jpsxdec.formats.JavaImageFormat;
import jpsxdec.formats.RgbIntImage;
import jpsxdec.formats.YCbCrImage;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.exception.LocalizedFileNotFoundException;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.modules.video.framenumber.FormattedFrameNumber;
import jpsxdec.modules.video.save.AudioVideoSync;
import jpsxdec.modules.video.save.VideoFileNameFormatter;
import jpsxdec.modules.video.save.VideoSync;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecDecoder;
import jpsxdec.psxvideo.mdec.MdecDecoder_double;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.psxvideo.mdec.MdecInputStreamReader;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.ExposedBAOS;
import jpsxdec.util.Fraction;
import jpsxdec.util.IO;
import jpsxdec.util.aviwriter.AviWriter;
import jpsxdec.util.aviwriter.AviWriterDIB;
import jpsxdec.util.aviwriter.AviWriterMJPG;
import jpsxdec.util.aviwriter.AviWriterYV12;

public class VDP {
    private static final Logger LOG = Logger.getLogger(VDP.class.getName());

    @Nonnull
    private static BufferedImage makeErrorImage(@Nonnull ILocalizedMessage sErr, int iWidth, int iHeight) {
        BufferedImage bi = new BufferedImage(iWidth, iHeight, 1);
        Graphics2D g = bi.createGraphics();
        g.setColor(Color.white);
        g.drawString(sErr.getLocalizedMessage(), 5, 20);
        g.dispose();
        return bi;
    }

    private static class FrameMessage {
        private FrameMessage() {
        }

        @Nonnull
        private static ILocalizedMessage JPEG_ENCODER_FRAME_FAIL(@CheckForNull FormattedFrameNumber frameNumber) {
            if (frameNumber == null) {
                return I.JPEG_ENCODER_FRAME_FAIL_NO_FRAME();
            }
            return I.JPEG_ENCODER_FRAME_FAIL(frameNumber.toString());
        }

        @Nonnull
        private static ILocalizedMessage FRAME_NUM_INCOMPLETE(@CheckForNull FormattedFrameNumber frameNumber) {
            if (frameNumber == null) {
                return I.FRAME_INCOMPLETE();
            }
            return I.FRAME_NUM_INCOMPLETE(frameNumber.getUnpaddedValue());
        }

        @Nonnull
        private static ILocalizedMessage FRAME_NUM_CORRUPTED(@CheckForNull FormattedFrameNumber frameNumber) {
            if (frameNumber == null) {
                return I.FRAME_CORRUPTED();
            }
            return I.FRAME_NUM_CORRUPTED(frameNumber.getUnpaddedValue());
        }

        @Nonnull
        private static ILocalizedMessage FRAME_NUM_AHEAD_OF_READING(@CheckForNull FormattedFrameNumber frameNumber, int iFrameCount) {
            if (frameNumber == null) {
                return I.FRAME_AHEAD_OF_READING(iFrameCount);
            }
            return I.FRAME_NUM_AHEAD_OF_READING(frameNumber.getUnpaddedValue(), iFrameCount);
        }

        @Nonnull
        private static ILocalizedMessage FRAME_WRITE_ERR(File f, @CheckForNull FormattedFrameNumber frameNumber) {
            if (frameNumber == null) {
                return I.IO_WRITING_FILE_ERROR_NAME(f.toString());
            }
            return I.FRAME_WRITE_ERR(f, frameNumber.getUnpaddedValue());
        }

        @Nonnull
        private static ILocalizedMessage FRAME_FILE_WRITE_UNABLE(File f, @CheckForNull FormattedFrameNumber frameNumber) {
            if (frameNumber == null) {
                return I.IO_WRITING_FILE_ERROR_NAME(f.toString());
            }
            return I.FRAME_FILE_WRITE_UNABLE(f.toString(), frameNumber.getUnpaddedValue());
        }

        @Nonnull
        private static ILocalizedMessage UNABLE_TO_DETERMINE_FRAME_TYPE_FRM(@CheckForNull FormattedFrameNumber frameNumber) {
            if (frameNumber == null) {
                return I.UNABLE_TO_DETERMINE_FRAME_TYPE();
            }
            return I.UNABLE_TO_DETERMINE_FRAME_TYPE_FRM(frameNumber.getUnpaddedValue());
        }
    }

    public static class Mdec2MjpegAvi
    extends ToAvi
    implements IMdecListener {
        @Nonnull
        private final jpsxdec.psxvideo.mdec.tojpeg.Mdec2Jpeg _jpegTranslator;
        @Nonnull
        private final ExposedBAOS _buffer = new ExposedBAOS();
        @CheckForNull
        private AviWriterMJPG _mjpegWriter;

        public Mdec2MjpegAvi(@Nonnull File outputFile, int iWidth, int iHeight, @Nonnull VideoSync vidSync, @Nonnull ILocalizedLogger log) {
            super(outputFile, iWidth, iHeight, vidSync, log);
            this._jpegTranslator = new jpsxdec.psxvideo.mdec.tojpeg.Mdec2Jpeg(iWidth, iHeight);
        }

        public Mdec2MjpegAvi(@Nonnull File outputFile, int iWidth, int iHeight, @Nonnull AudioVideoSync avSync, @Nonnull AudioFormat af, @Nonnull ILocalizedLogger log) {
            super(outputFile, iWidth, iHeight, avSync, af, log);
            this._jpegTranslator = new jpsxdec.psxvideo.mdec.tojpeg.Mdec2Jpeg(iWidth, iHeight);
        }

        @Override
        public void open() throws LocalizedFileNotFoundException, FileNotFoundException, IOException {
            if (this._writer == null) {
                IO.makeDirsForFile(this._outputFile);
                this._mjpegWriter = new AviWriterMJPG(this._outputFile, this._iWidth, this._iHeight, this._vidSync.getFpsNum(), this._vidSync.getFpsDenom(), this._af);
                this._writer = this._mjpegWriter;
                if (this._fileGenListener != null) {
                    this._fileGenListener.fileGenerated(this._outputFile);
                }
            }
        }

        @Override
        public void mdec(@Nonnull MdecInputStream mdecIn, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws LoggedFailure {
            Exception fail;
            ILocalizedMessage err;
            if (this._mjpegWriter == null) {
                throw new IllegalStateException("AVI not open.");
            }
            try {
                this._jpegTranslator.readMdec(mdecIn);
                this._buffer.reset();
                try {
                    this._jpegTranslator.writeJpeg(this._buffer);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Should not happen", ex);
                }
                try {
                    this.prepForFrame(frameNumber, presentationSector);
                    this._mjpegWriter.writeFrame(this._buffer.getBuffer(), 0, this._buffer.size());
                }
                catch (IOException ex) {
                    throw new LoggedFailure(this._log, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(this._writer.getFile().toString()), ex);
                }
                return;
            }
            catch (MdecException.ReadCorruption ex) {
                err = FrameMessage.FRAME_NUM_CORRUPTED(frameNumber);
                fail = ex;
            }
            catch (MdecException.EndOfStream ex) {
                err = FrameMessage.FRAME_NUM_INCOMPLETE(frameNumber);
                fail = ex;
            }
            catch (MdecException.TooMuchEnergy ex) {
                err = FrameMessage.JPEG_ENCODER_FRAME_FAIL(frameNumber);
                fail = ex;
            }
            this._log.log(Level.WARNING, err, fail);
            this.error(err, frameNumber, presentationSector);
        }

        @Override
        public void error(@Nonnull ILocalizedMessage errMsg, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws LoggedFailure {
            if (this._mjpegWriter == null) {
                throw new IllegalStateException("AVI not open.");
            }
            try {
                this.prepForFrame(frameNumber, presentationSector);
                this._mjpegWriter.writeFrame(VDP.makeErrorImage(errMsg, this._iWidth, this._iHeight));
            }
            catch (IOException ex) {
                throw new LoggedFailure(this._log, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(this._writer.getFile().toString()), ex);
            }
        }

        @Override
        @Nonnull
        public ILocalizedLogger getLog() {
            return this._log;
        }
    }

    public static class Decoded2JYuvAvi
    extends Decoded2YuvAvi {
        public Decoded2JYuvAvi(@Nonnull File outputFile, int iWidth, int iHeight, @Nonnull AudioVideoSync avSync, @Nonnull AudioFormat af, @Nonnull ILocalizedLogger log) {
            super(outputFile, iWidth, iHeight, avSync, af, log);
        }

        public Decoded2JYuvAvi(@Nonnull File outputFile, int iWidth, int iHeight, @Nonnull VideoSync vidSync, @Nonnull ILocalizedLogger log) {
            super(outputFile, iWidth, iHeight, vidSync, log);
        }

        @Override
        public void decoded(@Nonnull MdecDecoder decoder, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws LoggedFailure {
            if (this._writerYuv == null) {
                throw new IllegalStateException("AVI not open.");
            }
            ((MdecDecoder_double)decoder).readDecoded_JFIF_YCbCr420(this._yuvImgBuff);
            try {
                this.prepForFrame(frameNumber, presentationSector);
                this._writerYuv.write(this._yuvImgBuff.getY(), this._yuvImgBuff.getCb(), this._yuvImgBuff.getCr());
            }
            catch (IOException ex) {
                throw new LoggedFailure(this._log, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(this._writer.getFile().toString()), ex);
            }
        }
    }

    public static class Decoded2YuvAvi
    extends ToAvi
    implements IDecodedListener {
        @CheckForNull
        protected YCbCrImage _yuvImgBuff;
        @CheckForNull
        protected AviWriterYV12 _writerYuv;

        public Decoded2YuvAvi(@Nonnull File outputFile, int iWidth, int iHeight, @Nonnull VideoSync vidSync, @Nonnull ILocalizedLogger log) {
            super(outputFile, iWidth, iHeight, vidSync, log);
            if (((iWidth | iHeight) & 1) != 0) {
                throw new IllegalArgumentException("YUV AVI only supports even dimensions");
            }
        }

        public Decoded2YuvAvi(@Nonnull File outputFile, int iWidth, int iHeight, @Nonnull AudioVideoSync avSync, @Nonnull AudioFormat af, @Nonnull ILocalizedLogger log) {
            super(outputFile, iWidth, iHeight, avSync, af, log);
            if (((iWidth | iHeight) & 1) != 0) {
                throw new IllegalArgumentException("YUV AVI only supports even dimensions");
            }
        }

        @Override
        public void assertAcceptsDecoded(@Nonnull MdecDecoder decoder) throws IllegalArgumentException {
            if (!(decoder instanceof MdecDecoder_double)) {
                throw new IllegalArgumentException(this.getClass().getName() + " can't handle " + decoder.getClass().getName());
            }
        }

        @Override
        public void open() throws LocalizedFileNotFoundException, FileNotFoundException, IOException {
            if (this._writer == null) {
                IO.makeDirsForFile(this._outputFile);
                this._writerYuv = new AviWriterYV12(this._outputFile, this._iWidth, this._iHeight, this._vidSync.getFpsNum(), this._vidSync.getFpsDenom(), this._af);
                this._writer = this._writerYuv;
                if (this._fileGenListener != null) {
                    this._fileGenListener.fileGenerated(this._outputFile);
                }
                this._yuvImgBuff = new YCbCrImage(this._iWidth, this._iHeight);
            }
        }

        @Override
        public void decoded(@Nonnull MdecDecoder decoder, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws LoggedFailure {
            if (this._writerYuv == null) {
                throw new IllegalStateException("AVI not open.");
            }
            ((MdecDecoder_double)decoder).readDecoded_Rec601_YCbCr420(this._yuvImgBuff);
            try {
                this.prepForFrame(frameNumber, presentationSector);
                this._writerYuv.write(this._yuvImgBuff.getY(), this._yuvImgBuff.getCb(), this._yuvImgBuff.getCr());
            }
            catch (IOException ex) {
                throw new LoggedFailure(this._log, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(this._writer.getFile().toString()), ex);
            }
        }

        @Override
        public void error(@Nonnull ILocalizedMessage errMsg, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws LoggedFailure {
            if (this._writerYuv == null) {
                throw new IllegalStateException("AVI not open.");
            }
            BufferedImage bi = VDP.makeErrorImage(errMsg, this._writerYuv.getWidth(), this._writerYuv.getHeight());
            try {
                this.prepForFrame(frameNumber, presentationSector);
                YCbCrImage yuv = new YCbCrImage(bi);
                this._writerYuv.write(yuv.getY(), yuv.getCb(), yuv.getCr());
            }
            catch (IOException ex) {
                throw new LoggedFailure(this._log, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(this._writer.getFile().toString()), ex);
            }
        }
    }

    public static class Decoded2RgbAvi
    extends ToAvi
    implements IDecodedListener {
        @CheckForNull
        private AviWriterDIB _writerDib;
        @CheckForNull
        private int[] _aiImageBuf;

        public Decoded2RgbAvi(@Nonnull File outputFile, int iWidth, int iHeight, @Nonnull VideoSync vidSync, @Nonnull ILocalizedLogger log) {
            super(outputFile, iWidth, iHeight, vidSync, log);
        }

        public Decoded2RgbAvi(@Nonnull File outputFile, int iWidth, int iHeight, @Nonnull AudioVideoSync avSync, @Nonnull AudioFormat af, @Nonnull ILocalizedLogger log) {
            super(outputFile, iWidth, iHeight, avSync, af, log);
        }

        @Override
        public void assertAcceptsDecoded(@Nonnull MdecDecoder decoder) {
        }

        @Override
        public void open() throws LocalizedFileNotFoundException, FileNotFoundException, IOException {
            if (this._writer == null) {
                IO.makeDirsForFile(this._outputFile);
                this._writerDib = new AviWriterDIB(this._outputFile, this._iWidth, this._iHeight, this._vidSync.getFpsNum(), this._vidSync.getFpsDenom(), this._af);
                this._writer = this._writerDib;
                if (this._fileGenListener != null) {
                    this._fileGenListener.fileGenerated(this._outputFile);
                }
                this._aiImageBuf = new int[this._iWidth * this._iHeight];
            }
        }

        @Override
        public void decoded(@Nonnull MdecDecoder decoder, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws LoggedFailure {
            if (this._writerDib == null) {
                throw new IllegalStateException("AVI not open.");
            }
            decoder.readDecodedRgb(this._writerDib.getWidth(), this._writerDib.getHeight(), this._aiImageBuf);
            try {
                this.prepForFrame(frameNumber, presentationSector);
                this._writerDib.writeFrameRGB(this._aiImageBuf, 0, this._writerDib.getWidth());
            }
            catch (IOException ex) {
                throw new LoggedFailure(this._log, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(this._writer.getFile().toString()), ex);
            }
        }

        @Override
        public void error(@Nonnull ILocalizedMessage errMsg, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws LoggedFailure {
            if (this._writerDib == null) {
                throw new IllegalStateException("AVI not open.");
            }
            BufferedImage bi = VDP.makeErrorImage(errMsg, this._writerDib.getWidth(), this._writerDib.getHeight());
            RgbIntImage rgb = new RgbIntImage(bi);
            try {
                this.prepForFrame(frameNumber, presentationSector);
                this._writerDib.writeFrameRGB(rgb.getData(), 0, this._writerDib.getWidth());
            }
            catch (IOException ex) {
                throw new LoggedFailure(this._log, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(this._writer.getFile().toString()), ex);
            }
        }
    }

    public static abstract class ToAvi
    implements Closeable,
    DecodedAudioPacket.Listener {
        @Nonnull
        protected final File _outputFile;
        protected final int _iWidth;
        protected final int _iHeight;
        @Nonnull
        protected final VideoSync _vidSync;
        @CheckForNull
        private final AudioVideoSync _avSync;
        @CheckForNull
        protected final AudioFormat _af;
        @Nonnull
        protected final ILocalizedLogger _log;
        @CheckForNull
        protected AviWriter _writer;
        @CheckForNull
        protected GeneratedFileListener _fileGenListener;

        public ToAvi(@Nonnull File outputFile, int iWidth, int iHeight, @Nonnull VideoSync vidSync, @Nonnull ILocalizedLogger log) {
            this._outputFile = outputFile;
            this._iWidth = iWidth;
            this._iHeight = iHeight;
            this._vidSync = vidSync;
            this._avSync = null;
            this._af = null;
            this._log = log;
        }

        public ToAvi(@Nonnull File outputFile, int iWidth, int iHeight, @Nonnull AudioVideoSync avSync, @Nonnull AudioFormat af, @Nonnull ILocalizedLogger log) {
            this._outputFile = outputFile;
            this._iWidth = iWidth;
            this._iHeight = iHeight;
            this._avSync = avSync;
            this._vidSync = this._avSync;
            this._af = af;
            this._log = log;
        }

        @Nonnull
        public final File getOutputFile() {
            return this._outputFile;
        }

        @CheckForNull
        public final AviWriter getAviWriter() {
            return this._writer;
        }

        public abstract void open() throws LocalizedFileNotFoundException, FileNotFoundException, IOException;

        public abstract void error(@Nonnull ILocalizedMessage var1, @CheckForNull FormattedFrameNumber var2, @Nonnull Fraction var3) throws LoggedFailure;

        protected final void prepForFrame(@CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws IOException {
            int iDupCount;
            if (this._writer == null) {
                throw new IllegalStateException("Avi writer is not open");
            }
            if (this._writer.getVideoFramesWritten() < 1L && this._vidSync.getInitialVideo() > 0) {
                this._log.log(Level.INFO, I.WRITING_BLANK_FRAMES_TO_ALIGN_AV(this._vidSync.getInitialVideo()));
                this._writer.writeBlankFrame();
                for (int i = this._vidSync.getInitialVideo() - 1; i > 0; --i) {
                    this._writer.repeatPreviousFrame();
                }
            }
            if ((iDupCount = this._vidSync.calculateFramesToCatchUp(presentationSector, this._writer.getVideoFramesWritten())) < 0) {
                this._log.log(Level.WARNING, FrameMessage.FRAME_NUM_AHEAD_OF_READING(frameNumber, -iDupCount));
            } else {
                while (iDupCount > 0) {
                    if (this._writer.getVideoFramesWritten() < 1L) {
                        this._log.log(Level.INFO, I.WRITING_BLANK_FRAMES_TO_ALIGN_AV(1));
                        LOG.log(Level.INFO, "Writing blank frame for frame {0}", frameNumber);
                        this._writer.writeBlankFrame();
                    } else {
                        this._log.log(Level.INFO, I.WRITING_DUP_FRAMES_TO_ALIGN_AV(1));
                        LOG.log(Level.INFO, "Writing dup frame for frame {0}", frameNumber);
                        this._writer.repeatPreviousFrame();
                    }
                    --iDupCount;
                }
            }
        }

        @Override
        public final void audioPacketComplete(@Nonnull DecodedAudioPacket packet, @Nonnull ILocalizedLogger log) throws LoggedFailure {
            if (this._writer == null) {
                throw new IllegalStateException("Avi writer is not open");
            }
            try {
                long lngNeededSilence;
                if (this._writer.getAudioSampleFramesWritten() < 1L && this._avSync.getInitialAudio() > 0L) {
                    this._log.log(Level.INFO, I.WRITING_SILECE_TO_SYNC_AV(this._avSync.getInitialAudio()));
                    this._writer.writeSilentSamples(this._avSync.getInitialAudio());
                }
                if ((lngNeededSilence = this._avSync.calculateAudioToCatchUp(packet.getPresentationSector(), this._writer.getAudioSampleFramesWritten())) > 0L) {
                    this._log.log(Level.INFO, I.WRITING_SILENCE_TO_KEEP_AV_SYNCED(lngNeededSilence));
                    this._writer.writeSilentSamples(lngNeededSilence);
                }
                byte[] abData = packet.getData();
                this._writer.writeAudio(abData, 0, abData.length);
            }
            catch (IOException ex) {
                throw new LoggedFailure(this._log, Level.SEVERE, I.IO_WRITING_TO_FILE_ERROR_NAME(this._writer.getFile().toString()), ex);
            }
        }

        @Override
        public void close() throws IOException {
            if (this._writer != null) {
                this._writer.close();
            }
        }

        public void setGenFileListener(@CheckForNull GeneratedFileListener listener) {
            this._fileGenListener = listener;
        }
    }

    public static class Decoded2JavaImage
    implements IDecodedListener {
        @Nonnull
        private final VideoFileNameFormatter _formatter;
        @Nonnull
        private final String _sImageIOid;
        @Nonnull
        private final BufferedImage _rgbImg;
        @Nonnull
        private final ILocalizedLogger _log;
        @CheckForNull
        private GeneratedFileListener _fileGenListener;

        public Decoded2JavaImage(@Nonnull VideoFileNameFormatter formatter, @Nonnull JavaImageFormat eFmt, int iWidth, int iHeight, @Nonnull ILocalizedLogger log) {
            this._formatter = formatter;
            this._sImageIOid = eFmt.getImageIOid();
            this._rgbImg = new BufferedImage(iWidth, iHeight, 1);
            this._log = log;
        }

        @Override
        public void decoded(@Nonnull MdecDecoder decoder, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws LoggedFailure {
            decoder.readDecodedRgb(this._rgbImg.getWidth(), this._rgbImg.getHeight(), ((DataBufferInt)this._rgbImg.getRaster().getDataBuffer()).getData());
            File f = this._formatter.format(frameNumber, this._log);
            try {
                IO.makeDirsForFile(f);
            }
            catch (LocalizedFileNotFoundException ex) {
                this._log.log(Level.SEVERE, ex.getSourceMessage(), ex);
                return;
            }
            try {
                if (ImageIO.write((RenderedImage)this._rgbImg, this._sImageIOid, f)) {
                    if (this._fileGenListener != null) {
                        this._fileGenListener.fileGenerated(f);
                    }
                } else {
                    this._log.log(Level.WARNING, FrameMessage.FRAME_FILE_WRITE_UNABLE(f, frameNumber));
                }
            }
            catch (IOException ex) {
                this._log.log(Level.WARNING, FrameMessage.FRAME_WRITE_ERR(f, frameNumber), ex);
            }
        }

        @Override
        public void error(@Nonnull ILocalizedMessage errMsg, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) {
        }

        @Override
        public void assertAcceptsDecoded(@Nonnull MdecDecoder decoder) {
        }

        public void setGenFileListener(@CheckForNull GeneratedFileListener listener) {
            this._fileGenListener = listener;
        }
    }

    public static interface IDecodedListener {
        public void decoded(@Nonnull MdecDecoder var1, @CheckForNull FormattedFrameNumber var2, @Nonnull Fraction var3) throws LoggedFailure;

        public void error(@Nonnull ILocalizedMessage var1, @CheckForNull FormattedFrameNumber var2, @Nonnull Fraction var3) throws LoggedFailure;

        public void assertAcceptsDecoded(@Nonnull MdecDecoder var1) throws IllegalArgumentException;
    }

    public static class Mdec2Decoded
    implements IMdecListener {
        @Nonnull
        private final MdecDecoder _decoder;
        @Nonnull
        private final ILocalizedLogger _log;
        @CheckForNull
        private IDecodedListener _listener;

        public Mdec2Decoded(@Nonnull MdecDecoder decoder, @Nonnull ILocalizedLogger log) {
            this._decoder = decoder;
            this._log = log;
        }

        @Override
        public void mdec(@Nonnull MdecInputStream mdecIn, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws LoggedFailure {
            try {
                this._decoder.decode(mdecIn);
            }
            catch (MdecException.ReadCorruption ex) {
                this._log.log(Level.SEVERE, FrameMessage.FRAME_NUM_CORRUPTED(frameNumber), ex);
            }
            catch (MdecException.EndOfStream ex) {
                this._log.log(Level.SEVERE, FrameMessage.FRAME_NUM_INCOMPLETE(frameNumber), ex);
            }
            if (this._listener != null) {
                this._listener.decoded(this._decoder, frameNumber, presentationSector);
            }
        }

        @Override
        public void error(@Nonnull ILocalizedMessage errMsg, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws LoggedFailure {
            if (this._listener != null) {
                this._listener.error(errMsg, frameNumber, presentationSector);
            }
        }

        public void setDecoded(@CheckForNull IDecodedListener decoded) {
            if (decoded == null) {
                return;
            }
            decoded.assertAcceptsDecoded(this._decoder);
            this._listener = decoded;
        }

        @Override
        @Nonnull
        public ILocalizedLogger getLog() {
            return this._log;
        }
    }

    public static class Mdec2Jpeg
    implements IMdecListener {
        @Nonnull
        private final VideoFileNameFormatter _formatter;
        @Nonnull
        private final jpsxdec.psxvideo.mdec.tojpeg.Mdec2Jpeg _jpegTranslator;
        @Nonnull
        private final ExposedBAOS _buffer = new ExposedBAOS();
        @Nonnull
        private final ILocalizedLogger _log;
        @CheckForNull
        private GeneratedFileListener _fileGenListener;

        public Mdec2Jpeg(@Nonnull VideoFileNameFormatter formatter, int iWidth, int iHeight, @Nonnull ILocalizedLogger log) {
            this._formatter = formatter;
            this._jpegTranslator = new jpsxdec.psxvideo.mdec.tojpeg.Mdec2Jpeg(iWidth, iHeight);
            this._log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mdec(@Nonnull MdecInputStream mdecIn, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws LoggedFailure {
            File f = this._formatter.format(frameNumber, this._log);
            try {
                IO.makeDirsForFile(f);
            }
            catch (LocalizedFileNotFoundException ex) {
                this._log.log(Level.SEVERE, ex.getSourceMessage(), ex);
                return;
            }
            try {
                this._jpegTranslator.readMdec(mdecIn);
            }
            catch (MdecException.TooMuchEnergy ex) {
                this._log.log(Level.WARNING, FrameMessage.JPEG_ENCODER_FRAME_FAIL(frameNumber), ex);
                return;
            }
            catch (MdecException.ReadCorruption ex) {
                this._log.log(Level.WARNING, FrameMessage.FRAME_NUM_CORRUPTED(frameNumber), ex);
                return;
            }
            catch (MdecException.EndOfStream ex) {
                this._log.log(Level.WARNING, FrameMessage.FRAME_NUM_INCOMPLETE(frameNumber), ex);
                return;
            }
            this._buffer.reset();
            try {
                this._jpegTranslator.writeJpeg(this._buffer);
            }
            catch (IOException ex) {
                throw new RuntimeException("Should not happen", ex);
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                if (this._fileGenListener != null) {
                    this._fileGenListener.fileGenerated(f);
                }
                fos.write(this._buffer.getBuffer(), 0, this._buffer.size());
            }
            catch (FileNotFoundException ex) {
                this._log.log(Level.SEVERE, I.IO_OPENING_FILE_ERROR_NAME(f.toString()), ex);
            }
            catch (IOException ex) {
                this._log.log(Level.WARNING, FrameMessage.FRAME_WRITE_ERR(f, frameNumber), ex);
            }
            finally {
                IO.closeSilently(fos, LOG);
            }
        }

        @Override
        public void error(@Nonnull ILocalizedMessage errMsg, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) {
        }

        @Override
        @Nonnull
        public ILocalizedLogger getLog() {
            return this._log;
        }

        public void setGenFileListener(@CheckForNull GeneratedFileListener listener) {
            this._fileGenListener = listener;
        }
    }

    public static class Mdec2File
    implements IMdecListener {
        @Nonnull
        private final VideoFileNameFormatter _formatter;
        private final int _iTotalBlocks;
        @Nonnull
        private final ILocalizedLogger _log;
        @CheckForNull
        private GeneratedFileListener _fileGenListener;

        public Mdec2File(@Nonnull VideoFileNameFormatter formatter, int iWidth, int iHeight, @Nonnull ILocalizedLogger log) {
            this._formatter = formatter;
            this._iTotalBlocks = Calc.blocks(iHeight, iWidth);
            this._log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void mdec(@Nonnull MdecInputStream mdecIn, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector_ignored) throws LoggedFailure {
            File f = this._formatter.format(frameNumber, this._log);
            try {
                IO.makeDirsForFile(f);
            }
            catch (LocalizedFileNotFoundException ex) {
                this._log.log(Level.SEVERE, ex.getSourceMessage(), ex);
                return;
            }
            BufferedOutputStream bos = null;
            try {
                bos = new BufferedOutputStream(new FileOutputStream(f));
                if (this._fileGenListener != null) {
                    this._fileGenListener.fileGenerated(f);
                }
                try {
                    MdecInputStreamReader.writeMdecBlocks(mdecIn, bos, this._iTotalBlocks);
                }
                catch (MdecException.ReadCorruption ex) {
                    this._log.log(Level.SEVERE, FrameMessage.FRAME_NUM_CORRUPTED(frameNumber), ex);
                }
                catch (MdecException.EndOfStream ex) {
                    this._log.log(Level.SEVERE, FrameMessage.FRAME_NUM_INCOMPLETE(frameNumber), ex);
                }
            }
            catch (FileNotFoundException ex) {
                this._log.log(Level.SEVERE, I.IO_OPENING_FILE_ERROR_NAME(f.toString()), ex);
                IO.closeSilently(bos, LOG);
            }
            catch (IOException ex2) {
                this._log.log(Level.SEVERE, FrameMessage.FRAME_WRITE_ERR(f, frameNumber), ex2);
                {
                    catch (Throwable throwable) {
                        IO.closeSilently(bos, LOG);
                        throw throwable;
                    }
                }
                IO.closeSilently(bos, LOG);
            }
            IO.closeSilently(bos, LOG);
        }

        @Override
        public void error(@Nonnull ILocalizedMessage errMsg, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) {
        }

        @Override
        @Nonnull
        public ILocalizedLogger getLog() {
            return this._log;
        }

        public void setGenFileListener(@CheckForNull GeneratedFileListener listener) {
            this._fileGenListener = listener;
        }
    }

    public static interface IMdecListener {
        public void mdec(@Nonnull MdecInputStream var1, @CheckForNull FormattedFrameNumber var2, @Nonnull Fraction var3) throws LoggedFailure;

        public void error(@Nonnull ILocalizedMessage var1, @CheckForNull FormattedFrameNumber var2, @Nonnull Fraction var3) throws LoggedFailure;

        @Nonnull
        public ILocalizedLogger getLog();
    }

    public static class Bitstream2Mdec
    implements IBitstreamListener {
        @CheckForNull
        private IMdecListener _listener;
        @CheckForNull
        private Class<? extends BitStreamUncompressor> _uncompressorType;

        public Bitstream2Mdec() {
        }

        public Bitstream2Mdec(@Nonnull IMdecListener mdecListener) {
            this._listener = mdecListener;
        }

        public void setMdecListener(@CheckForNull IMdecListener listener) {
            this._listener = listener;
        }

        @Override
        public void bitstream(@Nonnull byte[] abBitstream, int iBitstreamSize, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) throws LoggedFailure {
            block6: {
                try {
                    BitStreamUncompressor uncompressor = BitStreamUncompressor.identifyUncompressor(abBitstream, iBitstreamSize);
                    if (this._uncompressorType != null) {
                        Class<?> newType = uncompressor.getClass();
                        if (!this._uncompressorType.equals(newType)) {
                            String sLog = "Bitstream format changed from " + this._uncompressorType.getSimpleName() + " to " + newType.getSimpleName();
                            System.out.println(sLog);
                            LOG.warning(sLog);
                            this._uncompressorType = newType;
                        }
                    } else {
                        this._uncompressorType = uncompressor.getClass();
                        String sLog = "Bitstream format: " + this._uncompressorType.getSimpleName();
                        LOG.info(sLog);
                    }
                    if (this._listener != null) {
                        this._listener.mdec(uncompressor, frameNumber, presentationSector);
                    }
                }
                catch (BinaryDataNotRecognized ex) {
                    ILocalizedMessage msg = FrameMessage.UNABLE_TO_DETERMINE_FRAME_TYPE_FRM(frameNumber);
                    if (this._listener == null) break block6;
                    this._listener.getLog().log(Level.SEVERE, msg, ex);
                    this._listener.error(msg, frameNumber, presentationSector);
                }
            }
        }
    }

    public static class Bitstream2File
    implements IBitstreamListener {
        @Nonnull
        private final VideoFileNameFormatter _formatter;
        @Nonnull
        private final ILocalizedLogger _log;
        @CheckForNull
        private GeneratedFileListener _fileGenListener;

        public Bitstream2File(@Nonnull VideoFileNameFormatter formatter, @Nonnull ILocalizedLogger log) {
            this._formatter = formatter;
            this._log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void bitstream(@Nonnull byte[] abBitstream, int iSize, @CheckForNull FormattedFrameNumber frameNumber, @Nonnull Fraction presentationSector) {
            File f = this._formatter.format(frameNumber, this._log);
            try {
                IO.makeDirsForFile(f);
            }
            catch (LocalizedFileNotFoundException ex) {
                this._log.log(Level.SEVERE, ex.getSourceMessage(), ex);
                return;
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                if (this._fileGenListener != null) {
                    this._fileGenListener.fileGenerated(f);
                }
                fos.write(abBitstream, 0, iSize);
            }
            catch (FileNotFoundException ex) {
                this._log.log(Level.SEVERE, I.IO_OPENING_FILE_ERROR_NAME(f.toString()), ex);
            }
            catch (IOException ex) {
                this._log.log(Level.SEVERE, FrameMessage.FRAME_WRITE_ERR(f, frameNumber), ex);
            }
            finally {
                IO.closeSilently(fos, LOG);
            }
        }

        public void setGenFileListener(@CheckForNull GeneratedFileListener listener) {
            this._fileGenListener = listener;
        }
    }

    public static interface IBitstreamListener {
        public void bitstream(@Nonnull byte[] var1, int var2, @CheckForNull FormattedFrameNumber var3, @Nonnull Fraction var4) throws LoggedFailure;
    }

    public static interface GeneratedFileListener {
        public void fileGenerated(@Nonnull File var1);
    }
}

