/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.save;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.psxvideo.mdec.MdecDecoder;
import jpsxdec.psxvideo.mdec.MdecDecoder_double;
import jpsxdec.psxvideo.mdec.MdecDecoder_int;
import jpsxdec.psxvideo.mdec.idct.PsxMdecIDCT_double;
import jpsxdec.psxvideo.mdec.idct.PsxMdecIDCT_int;
import jpsxdec.psxvideo.mdec.idct.SimpleIDCT;

public enum MdecDecodeQuality {
    LOW(I.QUALITY_FAST_DESCRIPTION(), I.QUALITY_FAST_COMMAND()){

        @Override
        public MdecDecoder makeDecoder(int iWidth, int iHeight) {
            return new MdecDecoder_int(new SimpleIDCT(), iWidth, iHeight);
        }
    }
    ,
    HIGH(I.QUALITY_HIGH_DESCRIPTION(), I.QUALITY_HIGH_COMMAND()){

        @Override
        public MdecDecoder makeDecoder(int iWidth, int iHeight) {
            return new MdecDecoder_double(new PsxMdecIDCT_double(), iWidth, iHeight);
        }

        @Override
        public boolean canUpsample() {
            return true;
        }
    }
    ,
    PSX(I.QUALITY_PSX_DESCRIPTION(), I.QUALITY_PSX_COMMAND()){

        @Override
        public MdecDecoder makeDecoder(int iWidth, int iHeight) {
            return new MdecDecoder_int(new PsxMdecIDCT_int(), iWidth, iHeight);
        }
    };

    @Nonnull
    private final ILocalizedMessage _guiDescription;
    @Nonnull
    private final ILocalizedMessage _cmdLine;

    public boolean canUpsample() {
        return false;
    }

    @CheckForNull
    public static MdecDecodeQuality fromCmdLine(@Nonnull String sCmdLine) {
        for (MdecDecodeQuality dq : MdecDecodeQuality.values()) {
            if (!dq.getCmdLine().equalsIgnoreCase(sCmdLine)) continue;
            return dq;
        }
        return null;
    }

    private MdecDecodeQuality(ILocalizedMessage description, ILocalizedMessage cmdLine) {
        this._guiDescription = description;
        this._cmdLine = cmdLine;
    }

    @Nonnull
    public abstract MdecDecoder makeDecoder(int var1, int var2);

    @Nonnull
    public ILocalizedMessage getCmdLine() {
        return this._cmdLine;
    }

    public String toString() {
        return this._guiDescription.getLocalizedMessage();
    }
}

