/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.save;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.framenumber.FormattedFrameNumber;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.save.VDP;
import jpsxdec.psxvideo.mdec.MdecInputStream;

public class Frame2Bitstream
implements IDemuxedFrame.Listener {
    @Nonnull
    private final FrameNumber.Type _frameNumberType;
    @CheckForNull
    private VDP.IBitstreamListener _bitstreamListener;
    @CheckForNull
    private VDP.IMdecListener _mdecListener;

    public Frame2Bitstream(@Nonnull FrameNumber.Type frameNumberType) {
        this._frameNumberType = frameNumberType;
    }

    public final void setListener(@CheckForNull VDP.IBitstreamListener bitstreamListener) {
        this._bitstreamListener = bitstreamListener;
    }

    public final void setListener(@CheckForNull VDP.IMdecListener mdecListener) {
        this._mdecListener = mdecListener;
    }

    @Nonnull
    public final FrameNumber.Type getFrameNumberType() {
        return this._frameNumberType;
    }

    @Override
    public void frameComplete(@Nonnull IDemuxedFrame frame) throws LoggedFailure {
        FormattedFrameNumber ffn = frame.getFrame().getNumber(this._frameNumberType);
        MdecInputStream customStream = frame.getCustomFrameMdecStream();
        if (customStream != null) {
            if (this._mdecListener == null) {
                throw new IllegalStateException("No mdec to write to");
            }
            this._mdecListener.mdec(customStream, ffn, frame.getPresentationSector());
        } else {
            if (this._bitstreamListener == null) {
                throw new IllegalStateException("No bitstream to write to");
            }
            byte[] abBitstream = frame.copyDemuxData();
            this._bitstreamListener.bitstream(abBitstream, frame.getDemuxSize(), ffn, frame.getPresentationSector());
        }
    }
}

