/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.save;

import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.modules.sharedaudio.ISectorAudioDecoder;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.ISectorClaimToDemuxedFrame;
import jpsxdec.modules.video.save.Frame2Bitstream;
import jpsxdec.modules.video.save.VDP;

public class AutowireVDP {
    @CheckForNull
    private VDP.IBitstreamListener _bitstreamListener;
    @CheckForNull
    private VDP.IMdecListener _mdecListener;
    @CheckForNull
    private VDP.ToAvi _toAvi;
    @CheckForNull
    private SectorClaimSystem _sectorClaimSystem;
    @CheckForNull
    private ISectorAudioDecoder _sectorAudioDecoder;
    @CheckForNull
    private ISectorClaimToDemuxedFrame _sectorClaimToDemuxedFrame;
    @CheckForNull
    private IDemuxedFrame.Listener _frameListener;
    @CheckForNull
    private Frame2Bitstream _frame2Bitstream;
    @CheckForNull
    private DecodedAudioPacket.Listener _audioListener;
    @CheckForNull
    private VDP.GeneratedFileListener _generatedFileListener;
    @CheckForNull
    private VDP.Bitstream2File _bitstream2File;
    @CheckForNull
    private VDP.Bitstream2Mdec _bitstream2Mdec;
    @CheckForNull
    private VDP.Decoded2JavaImage _decoded2JavaImage;
    @CheckForNull
    private VDP.Mdec2Decoded _mdec2Decoded;
    @CheckForNull
    private VDP.Mdec2File _mdec2File;
    @CheckForNull
    private VDP.Mdec2Jpeg _mdec2Jpeg;
    @CheckForNull
    private VDP.IDecodedListener _decodedListener;
    @CheckForNull
    private VDP.Decoded2JYuvAvi _decoded2JYuvAvi;
    @CheckForNull
    private VDP.Decoded2RgbAvi _decoded2RgbAvi;
    @CheckForNull
    private VDP.Decoded2YuvAvi _decoded2YuvAvi;
    @CheckForNull
    private VDP.Mdec2MjpegAvi _mdec2MjpegAvi;

    @CheckForNull
    public VDP.IBitstreamListener getBitstreamListener() {
        return this._bitstreamListener;
    }

    @CheckForNull
    public VDP.IMdecListener getMdecListener() {
        return this._mdecListener;
    }

    @CheckForNull
    public VDP.ToAvi getAvi() {
        return this._toAvi;
    }

    public void autowire() throws IllegalStateException {
        this._bitstreamListener = AutowireVDP.chooseOnlyOne(this._bitstream2File, this._bitstream2Mdec);
        this._mdecListener = AutowireVDP.chooseOnlyOne(this._mdec2Decoded, this._mdec2File, this._mdec2Jpeg, this._mdec2MjpegAvi);
        if (this._frame2Bitstream != null) {
            this._frame2Bitstream.setListener(this._bitstreamListener);
            this._frame2Bitstream.setListener(this._mdecListener);
        }
        this.wireDecodedIntoMdec();
        this.wireMdecIntoBitstream();
        this._toAvi = AutowireVDP.chooseOnlyOne(this._decoded2JYuvAvi, this._decoded2RgbAvi, this._decoded2YuvAvi, this._mdec2MjpegAvi);
        this.wireGenFileListener();
        this.wireSectorClaim();
        this.wireAudioAndFrame();
    }

    private void wireGenFileListener() {
        if (this._generatedFileListener == null) {
            return;
        }
        if (this._bitstream2File != null) {
            this._bitstream2File.setGenFileListener(this._generatedFileListener);
        }
        if (this._decoded2JavaImage != null) {
            this._decoded2JavaImage.setGenFileListener(this._generatedFileListener);
        }
        if (this._decoded2JYuvAvi != null) {
            this._decoded2JYuvAvi.setGenFileListener(this._generatedFileListener);
        }
        if (this._decoded2RgbAvi != null) {
            this._decoded2RgbAvi.setGenFileListener(this._generatedFileListener);
        }
        if (this._decoded2YuvAvi != null) {
            this._decoded2YuvAvi.setGenFileListener(this._generatedFileListener);
        }
        if (this._mdec2File != null) {
            this._mdec2File.setGenFileListener(this._generatedFileListener);
        }
        if (this._mdec2Jpeg != null) {
            this._mdec2Jpeg.setGenFileListener(this._generatedFileListener);
        }
        if (this._mdec2MjpegAvi != null) {
            this._mdec2MjpegAvi.setGenFileListener(this._generatedFileListener);
        }
    }

    private void wireMdecIntoBitstream() {
        VDP.IMdecListener mdecListener = AutowireVDP.chooseOnlyOne(this._mdec2Decoded, this._mdec2File, this._mdec2Jpeg, this._mdec2MjpegAvi);
        if (this._bitstream2Mdec == null) {
            return;
        }
        if (mdecListener != null) {
            this._bitstream2Mdec.setMdecListener(mdecListener);
        }
    }

    private void wireDecodedIntoMdec() {
        if (this._decodedListener == null) {
            this._decodedListener = AutowireVDP.chooseOnlyOne(this._decoded2JYuvAvi, this._decoded2JavaImage, this._decoded2RgbAvi, this._decoded2YuvAvi);
        }
        if (this._decodedListener == null) {
            return;
        }
        if (this._mdec2Decoded != null) {
            this._mdec2Decoded.setDecoded(this._decodedListener);
        }
    }

    @CheckForNull
    private static <T> T chooseOnlyOne(T ... elements) {
        T nonNull = null;
        for (T element : elements) {
            if (element == null) continue;
            if (nonNull != null) {
                throw new IllegalStateException("More than one set: " + Arrays.toString(elements));
            }
            nonNull = element;
        }
        return nonNull;
    }

    public void attachToSectorClaimer(@Nonnull SectorClaimSystem sectorClaimSystem) {
        AutowireVDP.assertNull(this._sectorClaimSystem);
        this._sectorClaimSystem = sectorClaimSystem;
    }

    private void wireSectorClaim() {
        if (this._sectorClaimSystem == null) {
            return;
        }
        if (this._sectorAudioDecoder != null) {
            this._sectorAudioDecoder.attachToSectorClaimer(this._sectorClaimSystem);
        }
        if (this._sectorClaimToDemuxedFrame != null) {
            this._sectorClaimToDemuxedFrame.attachToSectorClaimer(this._sectorClaimSystem);
        }
    }

    public void setAudioDecoder(@Nonnull ISectorAudioDecoder sectorAudioDecoder) {
        AutowireVDP.assertNull(this._sectorAudioDecoder);
        this._sectorAudioDecoder = sectorAudioDecoder;
    }

    public void setMap(@Nonnull ISectorClaimToDemuxedFrame sectorClaimToDemuxedFrame) {
        AutowireVDP.assertNull(this._sectorClaimToDemuxedFrame);
        this._sectorClaimToDemuxedFrame = sectorClaimToDemuxedFrame;
    }

    public void setFrameListener(@Nonnull IDemuxedFrame.Listener frameListener) {
        AutowireVDP.assertNull(this._frameListener);
        this._frameListener = frameListener;
    }

    public void setMap(@Nonnull Frame2Bitstream frame2Bitstream) {
        this.setFrameListener(frame2Bitstream);
        this._frame2Bitstream = frame2Bitstream;
    }

    public void setAudioPacketListener(@Nonnull DecodedAudioPacket.Listener audioListener) {
        AutowireVDP.assertNull(this._audioListener);
        this._audioListener = audioListener;
    }

    private void wireAudioAndFrame() {
        if (this._sectorAudioDecoder != null && this._audioListener != null) {
            this._sectorAudioDecoder.setAudioListener(this._audioListener);
        }
        if (this._sectorClaimToDemuxedFrame != null && this._frameListener != null) {
            this._sectorClaimToDemuxedFrame.setFrameListener(this._frameListener);
        }
    }

    public void setFileListener(@Nonnull VDP.GeneratedFileListener generatedFileListener) {
        AutowireVDP.assertNull(this._generatedFileListener);
        this._generatedFileListener = generatedFileListener;
    }

    public void setMap(@Nonnull VDP.Bitstream2File bitstream2File) {
        AutowireVDP.assertNull(this._bitstream2File);
        this._bitstream2File = bitstream2File;
    }

    public void setMap(@Nonnull VDP.Bitstream2Mdec bitstream2Mdec) {
        AutowireVDP.assertNull(this._bitstream2Mdec);
        this._bitstream2Mdec = bitstream2Mdec;
    }

    public void setMap(@Nonnull VDP.Decoded2JavaImage decoded2JavaImage) {
        AutowireVDP.assertNull(this._decoded2JavaImage);
        this._decoded2JavaImage = decoded2JavaImage;
    }

    public void setMap(@Nonnull VDP.Mdec2Decoded mdec2Decoded) {
        AutowireVDP.assertNull(this._mdec2Decoded);
        this._mdec2Decoded = mdec2Decoded;
    }

    public void setMap(@Nonnull VDP.Mdec2File mdec2File) {
        AutowireVDP.assertNull(this._mdec2File);
        this._mdec2File = mdec2File;
    }

    public void setMap(@Nonnull VDP.Mdec2Jpeg mdec2Jpeg) {
        AutowireVDP.assertNull(this._mdec2Jpeg);
        this._mdec2Jpeg = mdec2Jpeg;
    }

    public void setDecodedListener(@Nonnull VDP.IDecodedListener decodedListener) {
        AutowireVDP.assertNull(this._decodedListener);
        this._decodedListener = decodedListener;
    }

    public void setToAvi(@Nonnull VDP.Decoded2JYuvAvi decoded2JYuvAvi) {
        AutowireVDP.assertNull(this._decoded2JYuvAvi);
        this._decoded2JYuvAvi = decoded2JYuvAvi;
    }

    public void setToAvi(@Nonnull VDP.Decoded2RgbAvi decoded2RgbAvi) {
        AutowireVDP.assertNull(this._decoded2RgbAvi);
        this._decoded2RgbAvi = decoded2RgbAvi;
    }

    public void setToAvi(@Nonnull VDP.Decoded2YuvAvi decoded2YuvAvi) {
        AutowireVDP.assertNull(this._decoded2YuvAvi);
        this._decoded2YuvAvi = decoded2YuvAvi;
    }

    public void setToAvi(@Nonnull VDP.Mdec2MjpegAvi mdec2MjpegAvi) {
        AutowireVDP.assertNull(this._mdec2MjpegAvi);
        this._mdec2MjpegAvi = mdec2MjpegAvi;
    }

    private static void assertNull(Object o) {
        if (o != null) {
            throw new IllegalStateException(o.getClass() + " was already set");
        }
    }
}

