/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.save;

import javax.annotation.Nonnull;
import jpsxdec.modules.video.save.AudioSync;
import jpsxdec.modules.video.save.VideoSync;
import jpsxdec.util.Fraction;

public class AudioVideoSync
extends VideoSync {
    @Nonnull
    private final AudioSync _audSync;
    @Nonnull
    private final Fraction _sampleFramesPerVideoFrame;
    private final int _iInitialFrameDelay;
    private final long _lngInitialSampleDelay;

    public AudioVideoSync(int iFirstVideoPresentationSector, int iSectorsPerSecond, @Nonnull Fraction sectorsPerFrame, int iFirstAudioPresentationSector, int iSampleFramesPerSecond, boolean blnPreciseAv) {
        super(iFirstVideoPresentationSector, iSectorsPerSecond, sectorsPerFrame);
        this._audSync = new AudioSync(iFirstAudioPresentationSector, iSectorsPerSecond, iSampleFramesPerSecond);
        this._sampleFramesPerVideoFrame = super.getSecondsPerFrame().multiply(this._audSync.getSampleFramesPerSecond());
        if (blnPreciseAv) {
            int iPresentationSectorDiff = iFirstAudioPresentationSector - iFirstVideoPresentationSector;
            Fraction initialSampleDelay = new Fraction(this._audSync.getSampleFramesPerSecond(), this.getSectorsPerSecond()).multiply(iPresentationSectorDiff);
            if (initialSampleDelay.compareTo(0L) < 0) {
                this._iInitialFrameDelay = -((int)Math.floor(initialSampleDelay.divide(this._sampleFramesPerVideoFrame).asDouble()));
                this._lngInitialSampleDelay = Math.round(initialSampleDelay.add(this._sampleFramesPerVideoFrame.multiply(this._iInitialFrameDelay)).asDouble());
            } else {
                this._lngInitialSampleDelay = Math.round(initialSampleDelay.asDouble());
                this._iInitialFrameDelay = 0;
            }
        } else {
            this._lngInitialSampleDelay = 0L;
            this._iInitialFrameDelay = 0;
        }
    }

    @Override
    public int calculateFramesToCatchUp(@Nonnull Fraction framePresentationSector, long lngFramesWritten) {
        return super.calculateFramesToCatchUp(framePresentationSector, lngFramesWritten - (long)this.getInitialVideo());
    }

    public long calculateAudioToCatchUp(@Nonnull Fraction audioPresentationSector, long lngSampleFramesWritten) {
        return this._audSync.calculateAudioToCatchUp(audioPresentationSector, lngSampleFramesWritten - this.getInitialAudio());
    }

    @Nonnull
    public Fraction getSamplesFramesPerSector() {
        return this._audSync.getSampleFramesPerSector();
    }

    public int getSamplesFramesPerSecond() {
        return this._audSync.getSampleFramesPerSecond();
    }

    public long getInitialAudio() {
        return this._lngInitialSampleDelay;
    }

    @Override
    public int getInitialVideo() {
        return this._iInitialFrameDelay;
    }
}

