/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.save;

import javax.annotation.Nonnull;
import jpsxdec.util.Fraction;

public class AudioSync {
    private final int _iFirstPresentationSector;
    private final int _iSectorsPerSecond;
    private final int _iSampleFramesPerSecond;
    @Nonnull
    private final Fraction _sampleFramesPerSector;

    public AudioSync(int iFirstPresentationSector, int iSectorsPerSecond, int iSampleFramesPerSecond) {
        this._iSectorsPerSecond = iSectorsPerSecond;
        this._iSampleFramesPerSecond = iSampleFramesPerSecond;
        this._sampleFramesPerSector = new Fraction(this._iSampleFramesPerSecond, this._iSectorsPerSecond);
        this._iFirstPresentationSector = iFirstPresentationSector;
    }

    public int getSectorsPerSecond() {
        return this._iSectorsPerSecond;
    }

    public int getSampleFramesPerSecond() {
        return this._iSampleFramesPerSecond;
    }

    @Nonnull
    public Fraction getSampleFramesPerSector() {
        return this._sampleFramesPerSector;
    }

    public long calculateAudioToCatchUp(@Nonnull Fraction audioPresentationSector, long lngSampleFramesWritten) {
        Fraction presentationTime = audioPresentationSector.subtract(this._iFirstPresentationSector).divide(this._iSectorsPerSecond);
        Fraction movieTime = new Fraction(lngSampleFramesWritten, this._iSampleFramesPerSecond);
        Fraction timeDiff = presentationTime.subtract(movieTime);
        Fraction sampleDiff = timeDiff.multiply(this._iSampleFramesPerSecond);
        long lngSampleFrameDifference = Math.round(sampleDiff.asDouble());
        return lngSampleFrameDifference;
    }
}

