/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.replace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.ISectorClaimToDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameCompareIs;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.replace.ReplaceFrameFull;
import jpsxdec.modules.video.replace.ReplaceFramePartial;
import jpsxdec.modules.video.sectorbased.DiscItemSectorBasedVideoStream;
import jpsxdec.util.IO;
import jpsxdec.util.TaskCanceledException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReplaceFrames {
    private static final String VERSION = "0.3";
    private final ArrayList<ReplaceFrameFull> _replacers = new ArrayList();

    public ReplaceFrames() {
    }

    public ReplaceFrames(@Nonnull String sXmlConfig) throws XmlFileNotFoundException, XmlReadException, LocalizedDeserializationFail {
        this(new File(sXmlConfig));
    }

    public ReplaceFrames(@Nonnull File xmlConfig) throws XmlFileNotFoundException, XmlReadException, LocalizedDeserializationFail {
        Document doc;
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        try {
            FileInputStream fis;
            try {
                fis = new FileInputStream(xmlConfig);
            }
            catch (FileNotFoundException ex) {
                throw new XmlFileNotFoundException(ex);
            }
            try {
                doc = db.parse(fis);
            }
            catch (IOException ex) {
                throw new XmlReadException(ex);
            }
            finally {
                IO.closeSilently(fis, Logger.getLogger(ReplaceFrames.class.getName()));
            }
        }
        catch (SAXException ex) {
            throw new LocalizedDeserializationFail(I.REPLACE_FRAME_XML_ERROR(ex.getLocalizedMessage()), (Throwable)ex);
        }
        Element root = doc.getDocumentElement();
        root.normalize();
        if (!"str-replace".equals(root.getNodeName())) {
            throw new LocalizedDeserializationFail(I.CMD_REPLACE_XML_INVALID_ROOT_NODE(root.getNodeName()));
        }
        if (!VERSION.equals(root.getAttribute("version"))) {
            throw new LocalizedDeserializationFail(I.CMD_REPLACE_XML_INVALID_VERSION(root.getAttribute("version")));
        }
        NodeList nodeLst = root.getChildNodes();
        for (int i = 0; i < nodeLst.getLength(); ++i) {
            Node node = nodeLst.item(i);
            if (node.getNodeType() != 1) continue;
            ReplaceFrameFull replace = null;
            Element element = (Element)node;
            if ("replace".equals(element.getNodeName())) {
                replace = new ReplaceFrameFull(element);
            } else if ("partial-replace".equals(element.getNodeName())) {
                replace = new ReplaceFramePartial(element);
            }
            if (replace == null) continue;
            this._replacers.add(replace);
        }
    }

    public void save(@Nonnull String sFile) throws IOException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("str-replace");
            root.setAttribute("version", VERSION);
            document.appendChild(root);
            for (ReplaceFrameFull replacer : this._replacers) {
                root.appendChild(replacer.serialize(document));
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(sFile));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex);
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
    }

    @CheckForNull
    protected ReplaceFrameFull getFrameToReplace(@Nonnull FrameNumber frame) {
        for (ReplaceFrameFull replacer : this._replacers) {
            if (replacer.getFrameLookup().compareTo(frame) != FrameCompareIs.EQUAL) continue;
            return replacer;
        }
        return null;
    }

    public void addFrameToReplace(@Nonnull ReplaceFrameFull replace) {
        this._replacers.add(replace);
    }

    public void replaceFrames(@Nonnull DiscItemSectorBasedVideoStream vidItem, @Nonnull CdFileSectorReader cd, @Nonnull ProgressLogger pl) throws LoggedFailure, TaskCanceledException {
        ISectorClaimToDemuxedFrame demuxer = vidItem.makeDemuxer();
        ReplaceFrameListener replaceListener = new ReplaceFrameListener(pl, cd);
        demuxer.setFrameListener(replaceListener);
        pl.progressStart(vidItem.getSectorLength());
        SectorClaimSystem it = vidItem.createClaimSystem();
        demuxer.attachToSectorClaimer(it);
        int iSector = 0;
        while (it.hasNext()) {
            try {
                IIdentifiedSector sector = it.next(pl);
            }
            catch (CdFileSectorReader.CdReadException ex) {
                throw new LoggedFailure(pl, Level.SEVERE, I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), ex);
            }
            pl.progressUpdate(iSector);
            if (pl.isSeekingEvent() && replaceListener.currentFrameNum != null) {
                pl.event(replaceListener.currentFrameNum.getIndexDescription());
            }
            if (replaceListener.exception != null) {
                throw replaceListener.exception;
            }
            ++iSector;
        }
        it.close(pl);
        pl.progressEnd();
    }

    private class ReplaceFrameListener
    implements IDemuxedFrame.Listener {
        @Nonnull
        private final ProgressLogger _pl;
        @Nonnull
        private final CdFileSectorReader _cd;
        @CheckForNull
        public FrameNumber currentFrameNum;
        @CheckForNull
        public LoggedFailure exception;

        public ReplaceFrameListener(ProgressLogger pl, CdFileSectorReader cd) {
            this._pl = pl;
            this._cd = cd;
        }

        @Override
        public void frameComplete(@Nonnull IDemuxedFrame frame) {
            this.currentFrameNum = frame.getFrame();
            ReplaceFrameFull replacer = ReplaceFrames.this.getFrameToReplace(frame.getFrame());
            if (replacer != null) {
                try {
                    this._pl.log(Level.INFO, I.CMD_REPLACING_FRAME_WITH_FILE(replacer.getFrameLookup().toString(), replacer.getImageFile()));
                    replacer.replace(frame, this._cd, this._pl);
                }
                catch (LoggedFailure ex) {
                    this.exception = ex;
                }
            }
        }
    }

    public static class XmlReadException
    extends IOException {
        public XmlReadException(IOException cause) {
            super(cause);
        }
    }

    public static class XmlFileNotFoundException
    extends FileNotFoundException {
        public XmlFileNotFoundException(FileNotFoundException cause) {
            this.initCause(cause);
        }
    }
}

