/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.replace;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.formats.RgbIntImage;
import jpsxdec.i18n.I;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameLookup;
import jpsxdec.modules.video.replace.ReplaceFrameFull;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.psxvideo.bitstreams.BitStreamCompressor;
import jpsxdec.psxvideo.encode.MdecEncoder;
import jpsxdec.psxvideo.encode.PsxYCbCrImage;
import jpsxdec.psxvideo.mdec.Ac0Checker;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecDecoder_double;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.ParsedMdecImage;
import jpsxdec.psxvideo.mdec.idct.StephensIDCT;
import jpsxdec.util.BinaryDataNotRecognized;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReplaceFramePartial
extends ReplaceFrameFull {
    public static final String XML_TAG_NAME = "partial-replace";
    private int _iTolerance;
    @CheckForNull
    private File _imageMaskFile;
    @CheckForNull
    private Rectangle _rectMask;

    public ReplaceFramePartial(@Nonnull Element element) throws LocalizedDeserializationFail {
        super(element);
        if (element.hasAttribute("tolerance")) {
            this.setTolerance(element.getAttribute("tolerance").trim());
        }
        if (element.hasAttribute("mask")) {
            this.setImageMaskFile(element.getAttribute("mask").trim());
        }
        if (element.hasAttribute("rect")) {
            this.setRectMask(element.getAttribute("rect").trim());
        }
    }

    @Override
    @Nonnull
    public Element serialize(@Nonnull Document document) {
        Element node = document.createElement(XML_TAG_NAME);
        node.setAttribute("frame", this.getFrameLookup().toString());
        node.setTextContent(this.getImageFile().toString());
        ReplaceFrameFull.ImageFormat fmt = this.getFormat();
        if (fmt != null) {
            node.setAttribute("format", fmt.serialize());
        }
        if (this._iTolerance > 0) {
            node.setAttribute("tolerance", String.valueOf(this._iTolerance));
        }
        if (this._imageMaskFile != null) {
            node.setAttribute("mask", this._imageMaskFile.toString());
        }
        if (this._rectMask != null) {
            node.setAttribute("rect", String.format("%d,%d,%d,%d", this._rectMask.x, this._rectMask.y, this._rectMask.width, this._rectMask.height));
        }
        return node;
    }

    public ReplaceFramePartial(@Nonnull String sFrameNumber, @Nonnull String sImageFile) throws LocalizedDeserializationFail {
        super(sFrameNumber, sImageFile);
    }

    public ReplaceFramePartial(@Nonnull String sFrameNumber, @Nonnull File imageFile) throws LocalizedDeserializationFail {
        super(sFrameNumber, imageFile);
    }

    public ReplaceFramePartial(@Nonnull FrameLookup frameNumber, @Nonnull String sImageFile) {
        super(frameNumber, sImageFile);
    }

    public ReplaceFramePartial(@Nonnull FrameLookup frameNumber, @Nonnull File imageFile) {
        super(frameNumber, imageFile);
    }

    @CheckForNull
    public File getImageMaskFile() {
        return this._imageMaskFile;
    }

    public final void setImageMaskFile(@Nonnull String sImageMaskFile) {
        this.setImageMaskFile(new File(sImageMaskFile));
    }

    public void setImageMaskFile(@CheckForNull File imageMaskFile) {
        this._imageMaskFile = imageMaskFile;
    }

    public int getTolerance() {
        return this._iTolerance;
    }

    public final void setTolerance(@Nonnull String sToleranceValue) {
        this.setTolerance(Integer.parseInt(sToleranceValue));
    }

    public void setTolerance(int iTolerance) {
        this._iTolerance = iTolerance;
    }

    @CheckForNull
    public Rectangle getRectMask() {
        return this._rectMask;
    }

    public final void setRectMask(@Nonnull String sRectMask) {
        String[] asCoords = sRectMask.trim().split("\\D+");
        if (asCoords.length != 4) {
            throw new IllegalArgumentException("Invalid rectangle string " + sRectMask);
        }
        this.setRectMask(new Rectangle(Integer.parseInt(asCoords[0]), Integer.parseInt(asCoords[1]), Integer.parseInt(asCoords[2]), Integer.parseInt(asCoords[3])));
    }

    public void setRectMask(@CheckForNull Rectangle rectMask) {
        this._rectMask = rectMask;
    }

    @Override
    public void replace(@Nonnull IDemuxedFrame frame, @Nonnull CdFileSectorReader cd, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        BitStreamAnalysis newFrame;
        byte[] abNewFrame;
        ParsedMdecImage optimizedOrig;
        SectorBasedFrameAnalysis existingFrame;
        File newImgFile = this.getImageFile();
        BufferedImage newImg = ReplaceFramePartial.readImage(newImgFile, log);
        int WIDTH = frame.getWidth();
        int HEIGHT = frame.getHeight();
        if (newImg.getWidth() < WIDTH || newImg.getHeight() < HEIGHT) {
            throw new LoggedFailure(log, Level.SEVERE, I.REPLACE_FRAME_DIMENSIONS_TOO_SMALL(newImg.getWidth(), newImg.getHeight(), frame.getWidth(), frame.getHeight()));
        }
        try {
            existingFrame = SectorBasedFrameAnalysis.create(frame);
        }
        catch (BinaryDataNotRecognized ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.UNABLE_TO_DETERMINE_FRAME_TYPE_FRM(this.getFrameLookup().toString()), ex);
        }
        catch (MdecException.ReadCorruption ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.FRAME_NUM_CORRUPTED(this.getFrameLookup().toString()), ex);
        }
        catch (MdecException.EndOfStream ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.FRAME_NUM_INCOMPLETE(this.getFrameLookup().toString()), ex);
        }
        MdecDecoder_double decoder = new MdecDecoder_double(new StephensIDCT(), WIDTH, HEIGHT);
        try {
            optimizedOrig = new ParsedMdecImage(Ac0Checker.wrapWithChecker(existingFrame.makeNewStream(), true), WIDTH, HEIGHT);
            decoder.decode(optimizedOrig.getStream());
        }
        catch (MdecException.EndOfStream ex) {
            throw new RuntimeException("Should have been detected already", ex);
        }
        catch (MdecException.ReadCorruption ex) {
            throw new RuntimeException("Should have been detected already", ex);
        }
        RgbIntImage rgb = new RgbIntImage(WIDTH, HEIGHT);
        decoder.readDecodedRgb(rgb.getWidth(), rgb.getHeight(), rgb.getData());
        BufferedImage origImg = rgb.toBufferedImage();
        ArrayList<Point> diffMacblks = this.findDiffMacroblocks(origImg, newImg, log);
        if (diffMacblks.isEmpty()) {
            log.log(Level.INFO, I.CMD_NO_DIFFERENCE_SKIPPING(this.getFrameLookup().toString()));
            return;
        }
        if (diffMacblks.size() == Calc.macroblocks(WIDTH, HEIGHT)) {
            log.log(Level.WARNING, I.CMD_ENTIRE_FRAME_DIFFERENT());
        }
        this.printDiffMacroBlocks(diffMacblks, Calc.macroblockDim(WIDTH), Calc.macroblockDim(HEIGHT), log);
        PsxYCbCrImage newYuvImg = new PsxYCbCrImage(newImg);
        MdecEncoder encoder = new MdecEncoder(optimizedOrig, newYuvImg, diffMacblks);
        BitStreamCompressor comp = existingFrame.makeBitStreamCompressor();
        try {
            abNewFrame = comp.compressPartial(frame.copyDemuxData(), this.getFrameLookup().toString(), encoder, log);
        }
        catch (LocalizedIncompatibleException ex) {
            throw new LoggedFailure(log, Level.SEVERE, ex.getSourceMessage(), ex);
        }
        catch (MdecException.EndOfStream ex) {
            throw new RuntimeException("Shouldn't happen", ex);
        }
        catch (MdecException.ReadCorruption ex) {
            throw new RuntimeException("Shouldn't happen", ex);
        }
        if (abNewFrame == null) {
            throw new LoggedFailure(log, Level.SEVERE, I.CMD_UNABLE_TO_COMPRESS_FRAME_SMALL_ENOUGH(this.getFrameLookup().toString(), frame.getDemuxSize()));
        }
        try {
            newFrame = new BitStreamAnalysis(abNewFrame, WIDTH, HEIGHT);
        }
        catch (BinaryDataNotRecognized ex) {
            throw new RuntimeException("Shouldn't happen", ex);
        }
        catch (MdecException.EndOfStream ex) {
            throw new RuntimeException("Shouldn't happen", ex);
        }
        catch (MdecException.ReadCorruption ex) {
            throw new RuntimeException("Shouldn't happen", ex);
        }
        frame.writeToSectors(existingFrame, newFrame, cd, log);
    }

    private void printDiffMacroBlocks(@Nonnull ArrayList<Point> diffMacblks, int iMbWidth, int iMbHeight, @Nonnull ILocalizedLogger log) {
        log.log(Level.INFO, I.CMD_REPLACE_FOUND_DIFFERENT_MACRO_BLOCKS(diffMacblks.size()));
        Point p = new Point();
        for (int iMbY = 0; iMbY < iMbHeight; ++iMbY) {
            StringBuilder sb = new StringBuilder();
            for (int iMbX = 0; iMbX < iMbWidth; ++iMbX) {
                p.setLocation(iMbX, iMbY);
                if (diffMacblks.contains(p)) {
                    sb.append('X');
                    continue;
                }
                sb.append('.');
            }
            log.log(Level.INFO, new UnlocalizedMessage(sb.toString()));
        }
    }

    @Nonnull
    private ArrayList<Point> findDiffMacroblocks(@Nonnull BufferedImage origImg, @Nonnull BufferedImage newImg, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        int iMacblkWidth = Calc.macroblockDim(origImg.getWidth());
        int iMacblkHeight = Calc.macroblockDim(origImg.getHeight());
        ArrayList<Point> diffMacblks = new ArrayList<Point>();
        BufferedImage maskImg = null;
        if (this._imageMaskFile != null) {
            maskImg = ReplaceFramePartial.readImage(this._imageMaskFile, log);
        }
        Point macblk = new Point();
        for (int y = 0; y < iMacblkHeight; ++y) {
            for (int x = 0; x < iMacblkWidth; ++x) {
                macblk.setLocation(x, y);
                if (!this.blockIsDifferent(macblk, origImg, newImg, maskImg)) continue;
                diffMacblks.add(new Point(macblk));
            }
        }
        return diffMacblks;
    }

    @Nonnull
    private static BufferedImage readImage(@Nonnull File imageFile, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        BufferedImage bi;
        try {
            bi = ImageIO.read(imageFile);
        }
        catch (IOException ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.IO_READING_FILE_ERROR_NAME(imageFile.toString()), ex);
        }
        if (bi == null) {
            throw new LoggedFailure(log, Level.SEVERE, I.REPLACE_UNABLE_READ_IMAGE(imageFile.toString()));
        }
        return bi;
    }

    private boolean blockIsDifferent(@Nonnull Point macblk, @Nonnull BufferedImage bi1, @Nonnull BufferedImage bi2, @CheckForNull BufferedImage maskImg) {
        int iStartY;
        Rectangle rectMb;
        if (this._rectMask != null && !this._rectMask.intersects(rectMb = new Rectangle(macblk.x * 16, macblk.y * 16, 15, 15))) {
            return false;
        }
        int iStartX = macblk.x * 16;
        for (int y = iStartY = macblk.y * 16; y < iStartY + 16; ++y) {
            for (int x = iStartX; x < iStartX + 16; ++x) {
                if (this._rectMask != null && !this._rectMask.contains(x, y) || maskImg != null && (maskImg.getRGB(x, y) & 0xFFFFFF) == 0) continue;
                int iRgb1 = bi1.getRGB(x, y);
                int iRgb2 = bi2.getRGB(x, y);
                int iDiffR = (iRgb1 >> 16 & 0xFF) - (iRgb2 >> 16 & 0xFF);
                int iDiffG = (iRgb1 >> 8 & 0xFF) - (iRgb2 >> 8 & 0xFF);
                int iDiffB = (iRgb1 & 0xFF) - (iRgb2 & 0xFF);
                if (Math.abs(iDiffR) <= this._iTolerance && Math.abs(iDiffG) <= this._iTolerance && Math.abs(iDiffB) <= this._iTolerance) continue;
                return true;
            }
        }
        return false;
    }
}

