/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.replace;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameLookup;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.psxvideo.encode.MdecEncoder;
import jpsxdec.psxvideo.encode.PsxYCbCrImage;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStreamReader;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;
import jpsxdec.util.IncompatibleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReplaceFrameFull {
    @Nonnull
    private final FrameLookup _frameNum;
    @Nonnull
    private final File _imageFile;
    @CheckForNull
    private ImageFormat _format;
    @CheckForNull
    private SizeLimit _sizeLimit;
    public static final String XML_TAG_NAME = "replace";

    public ReplaceFrameFull(@Nonnull Element element) throws LocalizedDeserializationFail {
        this(element.getAttribute("frame").trim(), element.getFirstChild().getNodeValue().trim());
        this.setFormat(ImageFormat.deserialize(element.getAttribute("format")));
        this.setSizeLimit(SizeLimit.deserialize(element.getAttribute("size-limit")));
    }

    @Nonnull
    public Element serialize(@Nonnull Document document) {
        Element node = document.createElement(XML_TAG_NAME);
        node.setAttribute("frame", this.getFrameLookup().toString());
        node.setTextContent(this.getImageFile().toString());
        ImageFormat fmt = this.getFormat();
        if (fmt != null) {
            node.setAttribute("format", fmt.serialize());
        }
        return node;
    }

    public ReplaceFrameFull(@Nonnull String sFrameNumber, @Nonnull String sImageFile) throws LocalizedDeserializationFail {
        this(sFrameNumber, new File(sImageFile));
    }

    public ReplaceFrameFull(@Nonnull String sFrameNumber, @Nonnull File imageFile) throws LocalizedDeserializationFail {
        this(new FrameLookup(sFrameNumber), imageFile);
    }

    public ReplaceFrameFull(@Nonnull FrameLookup frameNumber, @Nonnull String sImageFile) {
        this(frameNumber, new File(sImageFile));
    }

    public ReplaceFrameFull(@Nonnull FrameLookup frameNumber, @Nonnull File imageFile) {
        this._frameNum = frameNumber;
        this._imageFile = imageFile;
    }

    @Nonnull
    public final FrameLookup getFrameLookup() {
        return this._frameNum;
    }

    @Nonnull
    public final File getImageFile() {
        return this._imageFile;
    }

    @CheckForNull
    public final ImageFormat getFormat() {
        return this._format;
    }

    public final void setFormat(@CheckForNull ImageFormat format) {
        this._format = format;
    }

    @CheckForNull
    public final SizeLimit getSizeLimit() {
        return this._sizeLimit;
    }

    public final void setSizeLimit(@CheckForNull SizeLimit sizeLimit) {
        this._sizeLimit = sizeLimit;
    }

    public void replace(@Nonnull IDemuxedFrame frame, @Nonnull CdFileSectorReader cd, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        BitStreamAnalysis newFrame;
        SectorBasedFrameAnalysis existingFrame;
        try {
            existingFrame = SectorBasedFrameAnalysis.create(frame);
        }
        catch (BinaryDataNotRecognized ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.UNABLE_TO_DETERMINE_FRAME_TYPE_FRM(this.getFrameLookup().toString()), ex);
        }
        catch (MdecException.EndOfStream ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.FRAME_NUM_INCOMPLETE(this.getFrameLookup().toString()), ex);
        }
        catch (MdecException.ReadCorruption ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.FRAME_NUM_CORRUPTED(this.getFrameLookup().toString()), ex);
        }
        int iMaxSize = this._sizeLimit == SizeLimit.ORIGINAL_NON_ZERO_SIZE ? existingFrame.calculateNonZeroBytes() : existingFrame.getBitStreamArrayLength();
        byte[] abNewFrame = this._format == ImageFormat.BS ? ReplaceFrameFull.readBitstreamFile(this._imageFile, log) : (this._format == ImageFormat.MDEC ? ReplaceFrameFull.readMdecAndCompress(this._imageFile, this.getFrameLookup(), existingFrame, log) : ReplaceFrameFull.encodeJavaImage(this._imageFile, this.getFrameLookup(), existingFrame, iMaxSize, log));
        if (abNewFrame == null) {
            throw new LoggedFailure(log, Level.SEVERE, I.CMD_UNABLE_TO_COMPRESS_FRAME_SMALL_ENOUGH(this.getFrameLookup().toString(), iMaxSize));
        }
        if (abNewFrame.length > frame.getDemuxSize()) {
            throw new LoggedFailure(log, Level.SEVERE, I.NEW_FRAME_DOES_NOT_FIT(this.getFrameLookup().toString(), abNewFrame.length, frame.getDemuxSize()));
        }
        try {
            newFrame = new BitStreamAnalysis(abNewFrame, frame.getWidth(), frame.getHeight());
            if (!newFrame.isBitStreamClass(existingFrame.getBitStreamClass())) {
                throw new BinaryDataNotRecognized();
            }
        }
        catch (BinaryDataNotRecognized ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.REPLACE_BITSTREAM_MISMATCH(this._imageFile), ex);
        }
        catch (MdecException.EndOfStream ex) {
            throw new RuntimeException("Can't decode a frame we just encoded?", ex);
        }
        catch (MdecException.ReadCorruption ex) {
            throw new RuntimeException("Can't decode a frame we just encoded?", ex);
        }
        frame.writeToSectors(existingFrame, newFrame, cd, log);
    }

    private static byte[] readBitstreamFile(@Nonnull File imageFile, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        try {
            return IO.readFile(imageFile);
        }
        catch (FileNotFoundException ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.IO_OPENING_FILE_NOT_FOUND_NAME(imageFile.toString()), ex);
        }
        catch (IOException ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.IO_READING_FILE_ERROR_NAME(imageFile.toString()), ex);
        }
    }

    private static byte[] readMdecAndCompress(@Nonnull File mdecImageFile, @Nonnull FrameLookup frameNum, @Nonnull SectorBasedFrameAnalysis frameAnalysis, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        try {
            MdecInputStreamReader mdecIn = new MdecInputStreamReader(IO.readFile(mdecImageFile));
            return frameAnalysis.makeBitStreamCompressor().compress(mdecIn);
        }
        catch (FileNotFoundException ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.IO_OPENING_FILE_NOT_FOUND_NAME(mdecImageFile.toString()), ex);
        }
        catch (IOException ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.IO_READING_FILE_ERROR_NAME(mdecImageFile.toString()), ex);
        }
        catch (IncompatibleException ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.REPLACE_INCOMPATIBLE_MDEC(mdecImageFile.toString(), frameNum.toString()), ex);
        }
        catch (MdecException.TooMuchEnergy ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.REPLACE_INCOMPATIBLE_MDEC(mdecImageFile.toString(), frameNum.toString()), ex);
        }
        catch (MdecException.EndOfStream ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.REPLACE_INCOMPLETE_MDEC(mdecImageFile.toString(), frameNum.toString()), ex);
        }
        catch (MdecException.ReadCorruption ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.REPLACE_CORRUPTED_MDEC(mdecImageFile.toString(), frameNum.toString()), ex);
        }
    }

    @CheckForNull
    private static byte[] encodeJavaImage(@Nonnull File imageFile, @Nonnull FrameLookup frameNum, @Nonnull SectorBasedFrameAnalysis frameAnalysis, int iMaxSize, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        BufferedImage bi;
        try {
            bi = ImageIO.read(imageFile);
        }
        catch (IOException ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.IO_READING_FILE_ERROR_NAME(imageFile.toString()), ex);
        }
        if (bi == null) {
            throw new LoggedFailure(log, Level.SEVERE, I.REPLACE_FILE_NOT_JAVA_IMAGE(imageFile));
        }
        if (bi.getWidth() != Calc.fullDimension(frameAnalysis.getWidth()) || bi.getHeight() != Calc.fullDimension(frameAnalysis.getHeight())) {
            throw new LoggedFailure(log, Level.SEVERE, I.REPLACE_FRAME_DIMENSIONS_MISMATCH(imageFile.toString(), bi.getWidth(), bi.getHeight(), frameAnalysis.getWidth(), frameAnalysis.getHeight()));
        }
        PsxYCbCrImage psxImage = new PsxYCbCrImage(bi);
        MdecEncoder encoder = new MdecEncoder(psxImage, frameAnalysis.getWidth(), frameAnalysis.getHeight());
        try {
            return frameAnalysis.makeBitStreamCompressor().compressFull(iMaxSize, frameNum.toString(), encoder, log);
        }
        catch (MdecException.EndOfStream ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.FRAME_NUM_INCOMPLETE(frameNum.toString()), ex);
        }
        catch (MdecException.ReadCorruption ex) {
            throw new LoggedFailure(log, Level.SEVERE, I.FRAME_NUM_CORRUPTED(frameNum.toString()), ex);
        }
    }

    public static enum SizeLimit {
        ORIGINAL_NON_ZERO_SIZE("original non-zero");

        @Nonnull
        private final String _sXmlValue;

        private SizeLimit(String sXmlValue) {
            this._sXmlValue = sXmlValue;
        }

        @CheckForNull
        public static SizeLimit deserialize(@CheckForNull String sSize) throws LocalizedDeserializationFail {
            if (sSize == null || sSize.length() == 0) {
                return null;
            }
            for (SizeLimit value : SizeLimit.values()) {
                if (!value._sXmlValue.equals(sSize)) continue;
                return value;
            }
            throw new LocalizedDeserializationFail(I.REPLACE_XML_INVALID_SIZE_LIMIT(sSize, SizeLimit.ORIGINAL_NON_ZERO_SIZE._sXmlValue));
        }

        @Nonnull
        public String serialize() {
            return this._sXmlValue;
        }
    }

    public static enum ImageFormat {
        BS,
        MDEC;


        @CheckForNull
        public static ImageFormat deserialize(@CheckForNull String sFormat) throws LocalizedDeserializationFail {
            if (sFormat == null || sFormat.length() == 0) {
                return null;
            }
            if ("bs".equalsIgnoreCase(sFormat)) {
                return BS;
            }
            if ("mdec".equalsIgnoreCase(sFormat)) {
                return MDEC;
            }
            throw new LocalizedDeserializationFail(I.REPLACE_INVALID_IMAGE_FORMAT(sFormat));
        }

        @Nonnull
        public String serialize() {
            return this.name().toLowerCase();
        }
    }
}

