/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.packetbased;

import argparser.BooleanHolder;
import java.io.File;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.discitems.DiscItemSaverBuilderGui;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.I;
import jpsxdec.i18n.TabularFeedback;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.modules.video.packetbased.DiscItemPacketBasedVideoStream;
import jpsxdec.modules.video.packetbased.PacketBasedVideoSaverBuilderGui;
import jpsxdec.modules.video.packetbased.SectorClaimToAudioAndFrame;
import jpsxdec.modules.video.save.VideoSaver;
import jpsxdec.modules.video.save.VideoSaverBuilder;
import jpsxdec.util.ArgParser;
import jpsxdec.util.TaskCanceledException;

public class PacketBasedVideoSaverBuilder
extends VideoSaverBuilder {
    @Nonnull
    private final DiscItemPacketBasedVideoStream _sourceVidItem;
    private boolean _blnSavingAudio = true;

    public PacketBasedVideoSaverBuilder(@Nonnull DiscItemPacketBasedVideoStream vidItem) {
        super(vidItem);
        this._sourceVidItem = vidItem;
    }

    @Override
    public boolean copySettingsTo(@Nonnull DiscItemSaverBuilder otherBuilder) {
        if (super.copySettingsTo(otherBuilder)) {
            if (otherBuilder instanceof PacketBasedVideoSaverBuilder) {
                PacketBasedVideoSaverBuilder other = (PacketBasedVideoSaverBuilder)otherBuilder;
                other.setSavingAudio(this.getSavingAudio());
            }
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public DiscItemSaverBuilderGui getOptionPane() {
        return new PacketBasedVideoSaverBuilderGui(this);
    }

    @Override
    public boolean getAudioVolume_enabled() {
        return this.getSavingAudio();
    }

    public boolean getSavingAudio_enabled() {
        return this.hasAudio() && this.getVideoFormat().isAvi() && this.getSaveStartFrame() == null;
    }

    @Override
    public boolean hasAudio() {
        return this._sourceVidItem.hasAudio();
    }

    @Override
    public boolean getSavingAudio() {
        if (!this.getSavingAudio_enabled()) {
            return false;
        }
        return this._blnSavingAudio;
    }

    public void setSavingAudio(boolean val) {
        this._blnSavingAudio = val;
        this.firePossibleChange();
    }

    @Override
    public boolean getEmulatePsxAvSync() {
        return false;
    }

    @Override
    public void commandLineOptions(@Nonnull ArgParser ap, @Nonnull FeedbackStream fbs) {
        super.commandLineOptions(ap, fbs);
        if (!ap.hasRemaining()) {
            return;
        }
        BooleanHolder noaud = ap.addBoolOption(false, "-noaud");
        ap.match();
        this.setSavingAudio(!noaud.value);
    }

    @Override
    protected void makeHelpTable(@Nonnull TabularFeedback tfb) {
        super.makeHelpTable(tfb);
        tfb.newRow();
        tfb.addCell(I.CMD_VIDEO_NOAUD()).addCell(I.CMD_VIDEO_NOAUD_HELP());
    }

    @Override
    protected void printSelectedAudioOptions(@Nonnull ILocalizedLogger log) {
        log.log(Level.INFO, I.CMD_EMBEDDED_PACKET_BASED_AUDIO_HZ(this._sourceVidItem.getAudioSampleFramesPerSecond()));
    }

    @Override
    public void startSave(@Nonnull ProgressLogger pl, @CheckForNull File directory) throws LoggedFailure, TaskCanceledException {
        this.clearGeneratedFiles();
        this.printSelectedOptions(pl);
        SectorClaimToAudioAndFrame vid = this._sourceVidItem.makeAudioVideoDemuxer(this.getAudioVolume());
        SectorClaimToAudioAndFrame aud = this.getSavingAudio() ? vid : null;
        VideoSaver vs = new VideoSaver(this._sourceVidItem, this, this.thisGeneratedFileListener, directory, pl, vid, aud);
        vs.save(pl);
    }
}

