/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.packetbased;

import java.util.Date;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.modules.player.MediaPlayer;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.DiscItemVideoStream;
import jpsxdec.modules.video.ISectorClaimToDemuxedFrame;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.modules.video.packetbased.PacketBasedVideoSaverBuilder;
import jpsxdec.modules.video.packetbased.SectorClaimToAudioAndFrame;
import jpsxdec.util.Misc;
import jpsxdec.util.player.PlayController;

public abstract class DiscItemPacketBasedVideoStream
extends DiscItemVideoStream {
    private static final String SOUND_UNIT_COUNT_KEY = "Sound unit count";
    private final int _iSoundUnitCount;

    public DiscItemPacketBasedVideoStream(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, @Nonnull Dimensions dim, @Nonnull IndexSectorFrameNumber.Format sectorIndexFrameNumberFormat, int iSoundUnitCount) {
        super(cd, iStartSector, iEndSector, dim, sectorIndexFrameNumberFormat);
        this._iSoundUnitCount = iSoundUnitCount;
    }

    public DiscItemPacketBasedVideoStream(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._iSoundUnitCount = fields.getInt(SOUND_UNIT_COUNT_KEY);
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem serial = super.serialize();
        serial.addNumber(SOUND_UNIT_COUNT_KEY, this._iSoundUnitCount);
        return serial;
    }

    public final boolean hasAudio() {
        return this._iSoundUnitCount > 0;
    }

    @Override
    public final int getDiscSpeed() {
        return 2;
    }

    @Override
    @Nonnull
    public final ILocalizedMessage getInterestingDescription() {
        int iFrames = this.getFrameCount();
        double dblFps = this.getPacketBasedFpsInterestingDescription();
        Date secs = Misc.dateFromSeconds(Math.max(iFrames / (int)Math.round(dblFps), 1));
        if (this.hasAudio()) {
            return I.GUI_PACKET_BASED_VID_DETAILS_WITH_AUDIO(this.getWidth(), this.getHeight(), iFrames, dblFps, secs, this.getAudioSampleFramesPerSecond());
        }
        return I.GUI_PACKET_BASED_VID_DETAILS(this.getWidth(), this.getHeight(), iFrames, dblFps, secs);
    }

    protected abstract double getPacketBasedFpsInterestingDescription();

    @Override
    public final int getAbsolutePresentationStartSector() {
        return this.getStartSector();
    }

    @Nonnull
    public abstract SectorClaimToAudioAndFrame makeAudioVideoDemuxer(double var1);

    public abstract int getAudioSampleFramesPerSecond();

    @Override
    public final ISectorClaimToDemuxedFrame makeDemuxer() {
        return this.makeAudioVideoDemuxer(1.0);
    }

    @Override
    public final DiscItemSaverBuilder makeSaverBuilder() {
        return new PacketBasedVideoSaverBuilder(this);
    }

    @Override
    @Nonnull
    public final PlayController makePlayController() {
        SectorClaimToAudioAndFrame demuxer = this.makeAudioVideoDemuxer(1.0);
        MediaPlayer mp = this.hasAudio() ? new MediaPlayer(this, demuxer, demuxer, this.getStartSector(), this.getEndSector()) : new MediaPlayer(this, demuxer, this.getStartSector(), this.getEndSector());
        return mp.getPlayController();
    }
}

