/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.framenumber;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.framenumber.FrameNumberNumber;
import jpsxdec.modules.video.framenumber.IFrameNumberFormatter;

public class IndexSectorFrameNumber
extends FrameNumber {
    private static final Logger LOG = Logger.getLogger(IndexSectorFrameNumber.class.getName());

    private IndexSectorFrameNumber(int iFrameIndex, int iFrameCount, @Nonnull FrameNumberNumber sectorNumber) {
        super(iFrameIndex, iFrameCount, sectorNumber);
    }

    @Nonnull
    public static IFrameNumberFormatter makeSimpleFormatter(int iFrameCount, int iSectorMinValue, int iSectorMaxValue, int iSectorDuplicateMax) {
        FrameNumberNumber.Format snf = new FrameNumberNumber.Format(iSectorMinValue, iSectorMaxValue, iSectorDuplicateMax, iSectorDuplicateMax);
        FrameNumberNumber.Formatter sf = new FrameNumberNumber.Formatter(snf);
        Formatter sect = new Formatter(iFrameCount, sf);
        return sect;
    }

    static class Formatter
    implements IFrameNumberFormatter {
        private final int _iExpectedMaxFrameCount;
        private int _iCurrentFrameIndex = 0;
        @Nonnull
        private final FrameNumberNumber.Formatter _sectorFormatter;

        Formatter(int iExpectedMaxFrameCount, @Nonnull FrameNumberNumber.Formatter sectorFormatter) {
            this._iExpectedMaxFrameCount = iExpectedMaxFrameCount;
            this._sectorFormatter = sectorFormatter;
        }

        private void warnIndexDigitsOutOfBounds(@Nonnull ILocalizedLogger log) {
            if (this._iCurrentFrameIndex >= this._iExpectedMaxFrameCount) {
                log.log(Level.WARNING, I.FRAMES_UNEXPECTED_NUMBER());
                LOG.log(Level.WARNING, "Expected no more than {0} frames but got {1}", new Object[]{this._iExpectedMaxFrameCount - 1, this._iCurrentFrameIndex});
            }
        }

        private static void warnSectorFrameNumberIssues(@Nonnull FrameNumberNumber sectorNumber, @Nonnull ILocalizedLogger log) {
            if (sectorNumber.frameNumberOutOfMaxBounds() || sectorNumber.frameNumberOutOfMinBounds()) {
                log.log(Level.WARNING, I.FRAMES_UNEXPECTED_NUMBER());
                LOG.log(Level.WARNING, "Frame start sector {0} out of expected bounds: {1} to {2}", new Object[]{sectorNumber.getFrameValue(), sectorNumber.getExpectedFrameMinValue(), sectorNumber.getExpectedFrameMaxValue()});
            }
            if (sectorNumber.tooManyDuplicates()) {
                log.log(Level.WARNING, I.FRAMES_UNEXPECTED_NUMBER());
                LOG.log(Level.WARNING, "Found {0} frames starting in sector {1}, but expected no more than {2}", new Object[]{sectorNumber.getDuplicateIndex(), sectorNumber.getFrameValue(), sectorNumber.getExpectedDuplicateMax()});
            }
        }

        @Override
        @Nonnull
        public IndexSectorFrameNumber next(int iSector, @Nonnull ILocalizedLogger log) {
            this.warnIndexDigitsOutOfBounds(log);
            FrameNumberNumber sectorNumber = this._sectorFormatter.next(iSector);
            Formatter.warnSectorFrameNumberIssues(sectorNumber, log);
            IndexSectorFrameNumber fn = new IndexSectorFrameNumber(this._iCurrentFrameIndex, this._iExpectedMaxFrameCount, sectorNumber);
            ++this._iCurrentFrameIndex;
            return fn;
        }
    }

    public static class Format {
        private static final String FRAME_COUNT_KEY = "Frame Count";
        private final int _iFrameCount;
        private static final String SECTOR_FORMAT_KEY = "Sector Frames";
        @Nonnull
        private final FrameNumberNumber.Format _sectorNumberFormat;

        private Format(int iFrameCount, @Nonnull FrameNumberNumber.Format sectorNumberFormat) {
            this._iFrameCount = iFrameCount;
            this._sectorNumberFormat = sectorNumberFormat;
        }

        public Format(@Nonnull SerializedDiscItem serial) throws LocalizedDeserializationFail {
            this._iFrameCount = serial.getInt(FRAME_COUNT_KEY);
            this._sectorNumberFormat = new FrameNumberNumber.Format(serial.getString(SECTOR_FORMAT_KEY));
        }

        public void serialize(@Nonnull SerializedDiscItem serial) {
            serial.addNumber(FRAME_COUNT_KEY, this._iFrameCount);
            serial.addString(SECTOR_FORMAT_KEY, this._sectorNumberFormat.serialize());
        }

        public int getFrameCount() {
            return this._iFrameCount;
        }

        @Nonnull
        public IndexSectorFrameNumber getStartFrame() {
            return new IndexSectorFrameNumber(0, this._iFrameCount, this._sectorNumberFormat.getStart());
        }

        @Nonnull
        public IndexSectorFrameNumber getEndFrame() {
            return new IndexSectorFrameNumber(this._iFrameCount - 1, this._iFrameCount, this._sectorNumberFormat.getEnd());
        }

        @Nonnull
        public IFrameNumberFormatter makeFormatter() {
            return this.makePrivateTypeFormatter();
        }

        @Nonnull
        Formatter makePrivateTypeFormatter() {
            return new Formatter(this._iFrameCount, this._sectorNumberFormat.makeFormatter());
        }

        public String toString() {
            return this._iFrameCount + " frames " + this._sectorNumberFormat;
        }

        public static class Builder {
            private int _iFrameCount;
            @Nonnull
            private final FrameNumberNumber.Format.Builder _sectorNumberBuilder;

            public Builder(int iFirstFrameStartSector) {
                this._sectorNumberBuilder = new FrameNumberNumber.Format.Builder(iFirstFrameStartSector);
                this._iFrameCount = 1;
            }

            public void addFrameStartSector(int iSector) {
                this._sectorNumberBuilder.addNumber(iSector);
                ++this._iFrameCount;
            }

            @Nonnull
            public Format makeFormat() {
                return new Format(this._iFrameCount, this._sectorNumberBuilder.makeFormat());
            }
        }
    }
}

