/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.framenumber;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.framenumber.FrameNumberNumber;
import jpsxdec.modules.video.framenumber.IFrameNumberFormatterWithHeader;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;

public class HeaderFrameNumber
extends FrameNumber {
    private static final Logger LOG = Logger.getLogger(HeaderFrameNumber.class.getName());

    private HeaderFrameNumber(@Nonnull IndexSectorFrameNumber indexSectorFrameNumber, @Nonnull FrameNumberNumber headerNumber) {
        super(indexSectorFrameNumber._iFrameIndex, indexSectorFrameNumber._iFrameCount, indexSectorFrameNumber._sectorNumber, headerNumber);
    }

    @Nonnull
    public static IFrameNumberFormatterWithHeader makeSimpleFormatter(int iFrameCount, int iSectorMinValue, int iSectorMaxValue, int iSectorDuplicateMax, int iHeaderMinValue, int iHeaderMaxValue, int iHeaderDuplicateMax) {
        FrameNumberNumber.Format snf = new FrameNumberNumber.Format(iSectorMinValue, iSectorMaxValue, iSectorDuplicateMax, iSectorDuplicateMax);
        FrameNumberNumber.Format hnf = new FrameNumberNumber.Format(iHeaderMinValue, iHeaderMaxValue, iHeaderDuplicateMax, iHeaderDuplicateMax);
        FrameNumberNumber.Formatter sf = new FrameNumberNumber.Formatter(snf);
        FrameNumberNumber.Formatter hf = new FrameNumberNumber.Formatter(hnf);
        IndexSectorFrameNumber.Formatter sect = new IndexSectorFrameNumber.Formatter(iFrameCount, sf);
        Formatter head = new Formatter(sect, hf);
        return head;
    }

    private static class Formatter
    implements IFrameNumberFormatterWithHeader {
        @Nonnull
        private final IndexSectorFrameNumber.Formatter _indexSectorFrameNumberFormatter;
        @Nonnull
        private final FrameNumberNumber.Formatter _headerFormatter;

        private Formatter(@Nonnull IndexSectorFrameNumber.Formatter indexSectorFrameNumberFormatter, @Nonnull FrameNumberNumber.Formatter headerFormatter) {
            this._indexSectorFrameNumberFormatter = indexSectorFrameNumberFormatter;
            this._headerFormatter = headerFormatter;
        }

        private static void warnHeaderFrameNumberIssues(@Nonnull FrameNumberNumber headerNumber, @Nonnull ILocalizedLogger log) {
            if (headerNumber.frameNumberOutOfMaxBounds() || headerNumber.frameNumberOutOfMinBounds()) {
                log.log(Level.WARNING, I.FRAMES_UNEXPECTED_NUMBER());
                LOG.log(Level.WARNING, "Expected frame numbers between {0} and {1} but found one with frame number {2}", new Object[]{headerNumber.getExpectedFrameMinValue(), headerNumber.getExpectedFrameMaxValue(), headerNumber.getFrameValue()});
            }
            if (headerNumber.tooManyDuplicates()) {
                log.log(Level.WARNING, I.FRAMES_UNEXPECTED_NUMBER());
                LOG.log(Level.WARNING, "Expected only {0} frames with the header frame number {1}, but found {2}", new Object[]{headerNumber.getExpectedDuplicateMax(), headerNumber.getFrameValue(), headerNumber.getDuplicateIndex()});
            }
        }

        @Override
        @Nonnull
        public HeaderFrameNumber next(int iSector, int iHeaderFrame, @Nonnull ILocalizedLogger log) {
            IndexSectorFrameNumber f1 = this._indexSectorFrameNumberFormatter.next(iSector, log);
            FrameNumberNumber hnn = this._headerFormatter.next(iHeaderFrame);
            Formatter.warnHeaderFrameNumberIssues(hnn, log);
            return new HeaderFrameNumber(f1, hnn);
        }
    }

    public static class Format {
        public static final String HEADER_FORMAT_KEY = "Header Frames";
        @Nonnull
        private final FrameNumberNumber.Format _headerNumberFormat;

        private Format(@Nonnull FrameNumberNumber.Format headerNumberFormat) {
            this._headerNumberFormat = headerNumberFormat;
        }

        public Format(@Nonnull SerializedDiscItem serial) throws LocalizedDeserializationFail {
            this._headerNumberFormat = new FrameNumberNumber.Format(serial.getString(HEADER_FORMAT_KEY));
        }

        public void serialize(@Nonnull SerializedDiscItem serial) {
            serial.addString(HEADER_FORMAT_KEY, this._headerNumberFormat.serialize());
        }

        @Nonnull
        public HeaderFrameNumber getStartFrame(@Nonnull IndexSectorFrameNumber.Format indexSectorFormat) {
            return new HeaderFrameNumber(indexSectorFormat.getStartFrame(), this._headerNumberFormat.getStart());
        }

        @Nonnull
        public HeaderFrameNumber getEndFrame(@Nonnull IndexSectorFrameNumber.Format indexSectorFormat) {
            return new HeaderFrameNumber(indexSectorFormat.getEndFrame(), this._headerNumberFormat.getEnd());
        }

        @Nonnull
        public IFrameNumberFormatterWithHeader makeFormatter(@Nonnull IndexSectorFrameNumber.Format indexSectorFormat) {
            return new Formatter(indexSectorFormat.makePrivateTypeFormatter(), this._headerNumberFormat.makeFormatter());
        }

        public String toString() {
            return this._headerNumberFormat.toString();
        }

        public static class Builder {
            @Nonnull
            private final FrameNumberNumber.Format.Builder _headerNumberBuilder;

            public Builder(int iFirstFrameHeaderNumber) {
                this._headerNumberBuilder = new FrameNumberNumber.Format.Builder(iFirstFrameHeaderNumber);
            }

            public void addHeaderFrameNumber(int iHeaderFrameNumber) {
                this._headerNumberBuilder.addNumber(iHeaderFrameNumber);
            }

            public int getStartFrameNumber() {
                return this._headerNumberBuilder.getStartFrameValue();
            }

            public int getLastFrameNumber() {
                return this._headerNumberBuilder.getLastFrameValue();
            }

            @Nonnull
            public Format makeFormat() {
                return new Format(this._headerNumberBuilder.makeFormat());
            }
        }
    }
}

