/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.framenumber;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.util.Misc;

class FrameNumberNumber {
    private static final Logger LOG = Logger.getLogger(FrameNumberNumber.class.getName());
    private final int _iFrameMinValue;
    private final int _iFrameValue;
    private final int _iFrameMaxValue;
    private final int _iDuplicateIndex;
    private final int _iDuplicateMax;

    public FrameNumberNumber(int iFrameMinValue, int iFrameValue, int iFrameMaxValue, int iDuplicateIndex, int iDuplicateMax) {
        if (iFrameMinValue < 0 || iFrameValue < 0 || iFrameMaxValue < 0 || iDuplicateIndex < 0 || iDuplicateMax < 0) {
            throw new IllegalArgumentException();
        }
        this._iFrameMinValue = iFrameMinValue;
        this._iFrameValue = iFrameValue;
        this._iFrameMaxValue = iFrameMaxValue;
        this._iDuplicateIndex = iDuplicateIndex;
        this._iDuplicateMax = iDuplicateMax;
    }

    public int getFrameValue() {
        return this._iFrameValue;
    }

    public int getExpectedFrameMinValue() {
        return this._iFrameMinValue;
    }

    public int getExpectedFrameMaxValue() {
        return this._iFrameMaxValue;
    }

    public int getExpectedDuplicateMax() {
        return this._iDuplicateMax;
    }

    public int getFrameDigitLength() {
        return FrameNumberNumber.base10digitCount(this._iFrameMaxValue);
    }

    public int getDuplicateIndex() {
        return this._iDuplicateIndex;
    }

    public int getDuplicateDigitLength() {
        return FrameNumberNumber.base10digitCount(this._iDuplicateMax);
    }

    public boolean frameNumberOutOfMaxBounds() {
        return this._iFrameValue > this._iFrameMaxValue;
    }

    public boolean frameNumberOutOfMinBounds() {
        return this._iFrameValue < this._iFrameMinValue;
    }

    public boolean tooManyDuplicates() {
        return this._iDuplicateIndex > this._iDuplicateMax;
    }

    public boolean equalValue(@Nonnull FrameNumberNumber other) {
        return this._iFrameValue == other._iFrameValue && this._iDuplicateIndex == other._iDuplicateIndex;
    }

    public String toString() {
        return FrameNumberNumber.format(this._iFrameValue, this.getFrameDigitLength(), this._iDuplicateIndex, this.getDuplicateDigitLength());
    }

    static int base10digitCount(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("" + i);
        }
        int iDigits = 0;
        while (i != 0) {
            ++iDigits;
            i /= 10;
        }
        return iDigits;
    }

    @Nonnull
    static String format(int iMajorValue, int iMajorDigits, int iMinorValue, int iMinorDigits) {
        String sMajor = Misc.intToPadded0String(iMajorValue, iMajorDigits);
        if (iMinorDigits == 0 && iMinorValue == 0) {
            return sMajor;
        }
        return sMajor + "." + Misc.intToPadded0String(iMinorValue, iMinorDigits);
    }

    public static class Formatter {
        private final Format _format;
        private int _iPrevFrameValue = -1;
        private int _iDuplicateValue = 0;

        public Formatter(@Nonnull Format format) {
            this._format = format;
        }

        @Nonnull
        public FrameNumberNumber next(int iFrameValue) {
            if (iFrameValue < 0) {
                throw new IllegalArgumentException();
            }
            if (iFrameValue == this._iPrevFrameValue) {
                ++this._iDuplicateValue;
            } else {
                this._iPrevFrameValue = iFrameValue;
                this._iDuplicateValue = 0;
            }
            return new FrameNumberNumber(this._format._iStartFrameValue, iFrameValue, this._format._iEndFrameValue, this._iDuplicateValue, this._format._iDuplicateMax);
        }
    }

    public static class Format {
        private final int _iStartFrameValue;
        private final int _iEndFrameValue;
        private final int _iEndDuplicate;
        private final int _iDuplicateMax;
        private static final Pattern SERIALIZED_FORMAT = Pattern.compile("^(\\d+)-(\\d+)(\\.(\\d+)/(\\d+))?$");

        public Format(int iStartFrameValue, int iEndFrameValue, int iEndDuplicate, int iDuplicateMax) {
            if (iStartFrameValue < 0 || iEndFrameValue < 0 || iEndDuplicate < 0 || iDuplicateMax < 0) {
                throw new IllegalArgumentException();
            }
            this._iStartFrameValue = iStartFrameValue;
            this._iEndFrameValue = iEndFrameValue;
            this._iEndDuplicate = iEndDuplicate;
            this._iDuplicateMax = iDuplicateMax;
        }

        public Format(@Nonnull String sSerialized) throws LocalizedDeserializationFail {
            String[] as = Misc.regex(SERIALIZED_FORMAT, sSerialized);
            if (as == null) {
                throw new LocalizedDeserializationFail(I.FRAME_NUM_INVALID(sSerialized));
            }
            try {
                this._iStartFrameValue = Integer.parseInt(as[1]);
                this._iEndFrameValue = Integer.parseInt(as[2]);
                this._iEndDuplicate = as[4] == null ? 0 : Integer.parseInt(as[4]);
                this._iDuplicateMax = as[5] == null ? 0 : Integer.parseInt(as[5]);
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("Regex should prevent this", ex);
            }
        }

        @Nonnull
        public String serialize() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._iStartFrameValue).append('-').append(this._iEndFrameValue);
            if (this._iEndDuplicate > 0 || this._iDuplicateMax > 0) {
                sb.append('.').append(this._iEndDuplicate).append('/').append(this._iDuplicateMax);
            }
            return sb.toString();
        }

        @Nonnull
        public FrameNumberNumber getStart() {
            return new FrameNumberNumber(this._iStartFrameValue, this._iStartFrameValue, this._iEndFrameValue, 0, this._iDuplicateMax);
        }

        @Nonnull
        public FrameNumberNumber getEnd() {
            return new FrameNumberNumber(this._iStartFrameValue, this._iEndFrameValue, this._iEndFrameValue, this._iEndDuplicate, this._iDuplicateMax);
        }

        @Nonnull
        public Formatter makeFormatter() {
            return new Formatter(this);
        }

        public String toString() {
            return this.serialize();
        }

        public static class Builder {
            private final int _iStartFrameValue;
            private int _iEndFrameValue;
            private int _iDuplicateMax = 0;
            private int _iDuplicate = 0;

            public Builder(int iStartFrameValue) {
                if (iStartFrameValue < 0) {
                    throw new IllegalArgumentException();
                }
                this._iStartFrameValue = iStartFrameValue;
                this._iEndFrameValue = iStartFrameValue;
            }

            public void addNumber(int iFrameValue) {
                if (iFrameValue < 0 || iFrameValue < this._iEndFrameValue) {
                    throw new IllegalArgumentException("Negitive frame value, or in reverse? " + iFrameValue + " < " + this._iEndFrameValue);
                }
                if (iFrameValue == this._iEndFrameValue) {
                    ++this._iDuplicate;
                    LOG.log(Level.INFO, "Duplicate header or sector frame number {0,number,#}", iFrameValue);
                    if (this._iDuplicate > this._iDuplicateMax) {
                        this._iDuplicateMax = this._iDuplicate;
                    }
                } else {
                    this._iEndFrameValue = iFrameValue;
                    this._iDuplicate = 0;
                }
            }

            public int getStartFrameValue() {
                return this._iStartFrameValue;
            }

            public int getLastFrameValue() {
                return this._iEndFrameValue;
            }

            @Nonnull
            public Format makeFormat() {
                return new Format(this._iStartFrameValue, this._iEndFrameValue, this._iDuplicate, this._iDuplicateMax);
            }

            public String toString() {
                return this._iStartFrameValue + "-" + this._iEndFrameValue + "." + this._iDuplicate + "'" + this._iDuplicateMax;
            }
        }
    }
}

