/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.framenumber;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.modules.video.framenumber.FormattedFrameNumber;
import jpsxdec.modules.video.framenumber.FrameNumberNumber;

public abstract class FrameNumber {
    static final char SECTOR_PREFIX = '@';
    static final char HEADER_PREFIX = '#';
    protected final int _iFrameIndex;
    protected final int _iFrameCount;
    @Nonnull
    final FrameNumberNumber _sectorNumber;
    @CheckForNull
    private final FrameNumberNumber _headerFrameNumber;

    FrameNumber(int iFrameIndex, int iFrameCount, @Nonnull FrameNumberNumber sectorNumber) {
        this._iFrameIndex = iFrameIndex;
        this._iFrameCount = iFrameCount;
        this._sectorNumber = sectorNumber;
        this._headerFrameNumber = null;
    }

    FrameNumber(int iFrameIndex, int iFrameCount, @Nonnull FrameNumberNumber sectorFrameNumber, @Nonnull FrameNumberNumber headerFrameNumber) {
        this._iFrameIndex = iFrameIndex;
        this._iFrameCount = iFrameCount;
        this._sectorNumber = sectorFrameNumber;
        this._headerFrameNumber = headerFrameNumber;
    }

    @CheckForNull
    public FormattedFrameNumber getNumber(@Nonnull Type numberType) {
        switch (numberType) {
            case Index: {
                return this.getIndexNumber();
            }
            case Sector: {
                return this.getSectorNumber();
            }
            case Header: {
                return this.getHeaderNumber();
            }
        }
        throw new RuntimeException();
    }

    @CheckForNull
    public ILocalizedMessage getDescription(@Nonnull Type numberType) {
        switch (numberType) {
            case Index: {
                return this.getIndexDescription();
            }
            case Sector: {
                return this.getSectorDescription();
            }
            case Header: {
                return this.getHeaderDescription();
            }
        }
        throw new RuntimeException();
    }

    @CheckForNull
    public String getUnformattedNumber(@Nonnull Type numberType) {
        switch (numberType) {
            case Index: {
                return this.getUnformattedIndexNumber();
            }
            case Sector: {
                return this.getUnformattedSectorNumber();
            }
            case Header: {
                return this.getUnformattedHeaderNumber();
            }
        }
        throw new RuntimeException();
    }

    @Nonnull
    public ILocalizedMessage getIndexDescription() {
        return I.FRAME_NUM_FORMATTER_FRAME(this.getUnformattedIndexNumber());
    }

    @Nonnull
    public ILocalizedMessage getSectorDescription() {
        return I.FRAME_NUM_FORMATTER_SECTOR(this.getUnformattedSectorNumber());
    }

    @CheckForNull
    public ILocalizedMessage getHeaderDescription() {
        if (this._headerFrameNumber == null) {
            return null;
        }
        return I.FRAME_NUM_FORMATTER_FRAME('#' + this.getUnformattedHeaderNumber());
    }

    @Nonnull
    public FormattedFrameNumber getIndexNumber() {
        return new FormattedFrameNumber(this._iFrameIndex, FrameNumberNumber.base10digitCount(this._iFrameCount));
    }

    @Nonnull
    public FormattedFrameNumber getSectorNumber() {
        return new FormattedFrameNumber('@', this._sectorNumber.getFrameValue(), this._sectorNumber.getFrameDigitLength(), this._sectorNumber.getDuplicateIndex(), this._sectorNumber.getDuplicateDigitLength());
    }

    @CheckForNull
    public FormattedFrameNumber getHeaderNumber() {
        if (this._headerFrameNumber == null) {
            return null;
        }
        return new FormattedFrameNumber('#', this._headerFrameNumber.getFrameValue(), this._headerFrameNumber.getFrameDigitLength(), this._headerFrameNumber.getDuplicateIndex(), this._headerFrameNumber.getDuplicateDigitLength());
    }

    @Nonnull
    public String getUnformattedIndexNumber() {
        return String.valueOf(this._iFrameIndex);
    }

    @Nonnull
    public String getUnformattedSectorNumber() {
        if (this._sectorNumber.getDuplicateIndex() == 0) {
            return String.valueOf(this._sectorNumber.getFrameValue());
        }
        return this._sectorNumber.getFrameValue() + "." + this._sectorNumber.getDuplicateIndex();
    }

    @CheckForNull
    public String getUnformattedHeaderNumber() {
        if (this._headerFrameNumber == null) {
            return null;
        }
        if (this._sectorNumber.getDuplicateIndex() == 0) {
            return String.valueOf(this._headerFrameNumber.getFrameValue());
        }
        return this._headerFrameNumber.getFrameValue() + "." + this._headerFrameNumber.getDuplicateIndex();
    }

    public boolean equalValue(@Nonnull FrameNumber other) {
        boolean blnEqual;
        boolean bl = blnEqual = this._iFrameIndex == other._iFrameIndex && this._sectorNumber.equalValue(other._sectorNumber);
        if (!blnEqual) {
            return false;
        }
        if (this._headerFrameNumber == null) {
            return other._headerFrameNumber == null;
        }
        if (other._headerFrameNumber == null) {
            return false;
        }
        return this._headerFrameNumber.equalValue(other._headerFrameNumber);
    }

    public String toString() {
        FormattedFrameNumber headerNumber = this.getHeaderNumber();
        if (headerNumber == null) {
            return this.getIndexNumber() + "/" + this.getSectorNumber();
        }
        return this.getIndexNumber() + "/" + this.getSectorNumber() + "/" + headerNumber;
    }

    public static enum Type {
        Index(I.FRAME_NUM_FORMAT_INDEX(), null),
        Sector(I.FRAME_NUM_FORMAT_SECTOR(), Character.valueOf('@')),
        Header(I.FRAME_NUM_FORMAT_HEADER(), Character.valueOf('#'));

        @Nonnull
        private final ILocalizedMessage _str;
        @CheckForNull
        private final Character _oChar;

        private Type(ILocalizedMessage str, Character oChar) {
            this._str = str;
            this._oChar = oChar;
        }

        @CheckForNull
        public static Type fromCmdLine(@Nonnull String sCmdLine) {
            for (Type t : Type.values()) {
                if (!t._str.equalsIgnoreCase(sCmdLine) && (sCmdLine.length() != 1 || t._oChar == null || t._oChar.charValue() != sCmdLine.charAt(0))) continue;
                return t;
            }
            return null;
        }

        @Nonnull
        public ILocalizedMessage getLocalizedName() {
            return this._str;
        }

        public String toString() {
            return this._str.getLocalizedMessage();
        }
    }
}

