/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.framenumber;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.modules.video.framenumber.FormattedFrameNumber;
import jpsxdec.modules.video.framenumber.FrameCompareIs;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.util.Misc;

public class FrameLookup {
    @Nonnull
    private final FrameNumber.Type _type;
    private final int _iFrameValue;
    private final int _iDuplicateIndex;
    private static final String REGEX = "^([@#])?(\\d+)(.(\\d+))?$";
    private static final Pattern PARSER = Pattern.compile("^([@#])?(\\d+)(.(\\d+))?$");

    public FrameLookup(@Nonnull FrameNumber.Type type, int iFrameValue) {
        this(type, iFrameValue, 0);
    }

    public FrameLookup(@Nonnull FrameNumber.Type type, int iFrameValue, int iDuplicateIndex) {
        this._type = type;
        this._iFrameValue = iFrameValue;
        this._iDuplicateIndex = iDuplicateIndex;
    }

    public FrameLookup(@Nonnull String s) throws LocalizedDeserializationFail {
        String[] as = Misc.regex(PARSER, s);
        if (as == null) {
            throw new LocalizedDeserializationFail(I.FRAME_NUM_INVALID(s));
        }
        try {
            this._iFrameValue = Integer.parseInt(as[2]);
            this._iDuplicateIndex = as[4] == null ? 0 : Integer.parseInt(as[4]);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("Regex should prevent this");
        }
        if (as[1] == null) {
            this._type = FrameNumber.Type.Index;
        } else if (as[1].charAt(0) == '@') {
            this._type = FrameNumber.Type.Sector;
        } else if (as[1].charAt(0) == '#') {
            this._type = FrameNumber.Type.Header;
        } else {
            throw new RuntimeException("Should not happen");
        }
    }

    @Nonnull
    public String serialize() {
        String sNumber = this._iDuplicateIndex == 0 ? String.valueOf(this._iFrameValue) : this._iFrameValue + "." + this._iDuplicateIndex;
        switch (this._type) {
            case Index: {
                return sNumber;
            }
            case Sector: {
                return '@' + sNumber;
            }
            case Header: {
                return '#' + sNumber;
            }
        }
        throw new RuntimeException();
    }

    @Nonnull
    public FrameNumber.Type getType() {
        return this._type;
    }

    @Nonnull
    public FrameCompareIs compareTo(FrameNumber frameNumber) {
        FormattedFrameNumber ffn;
        switch (this._type) {
            case Index: {
                ffn = frameNumber.getIndexNumber();
                break;
            }
            case Sector: {
                ffn = frameNumber.getSectorNumber();
                break;
            }
            case Header: {
                ffn = frameNumber.getHeaderNumber();
                if (ffn != null) break;
                return FrameCompareIs.INVALID;
            }
            default: {
                throw new RuntimeException();
            }
        }
        int i = Misc.intCompare(this._iFrameValue, ffn.getFrameValue());
        if (i == 0) {
            i = Misc.intCompare(this._iDuplicateIndex, ffn.getDuplicateIndex());
        }
        if (i < 0) {
            return FrameCompareIs.LESSTHAN;
        }
        if (i > 0) {
            return FrameCompareIs.GREATERTHAN;
        }
        return FrameCompareIs.EQUAL;
    }

    public String toString() {
        return this.serialize();
    }
}

