/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video.framenumber;

import javax.annotation.Nonnull;
import jpsxdec.modules.video.framenumber.FrameNumberNumber;

public class FormattedFrameNumber {
    private final char _cPrefix;
    private final int _iFrameValue;
    private final int _iFrameDigitLength;
    private final int _iDuplicateIndex;
    private final int _iDuplicateDigitLength;

    public FormattedFrameNumber(int iFrameValue) {
        this(iFrameValue, 0);
    }

    public FormattedFrameNumber(int iFrameValue, int iFrameDigitLength) {
        this(iFrameValue, iFrameDigitLength, 0, 0);
    }

    public FormattedFrameNumber(int iFrameValue, int iFrameDigitLength, int iDuplicateIndex, int iDuplicateDigitLength) {
        this('\u0000', iFrameValue, iFrameDigitLength, iDuplicateIndex, iDuplicateDigitLength);
    }

    public FormattedFrameNumber(char cPrefix, int iFrameValue, int iFrameDigitLength, int iDuplicateIndex, int iDuplicateDigitLength) {
        this._cPrefix = cPrefix;
        this._iFrameValue = iFrameValue;
        this._iFrameDigitLength = iFrameDigitLength;
        this._iDuplicateIndex = iDuplicateIndex;
        this._iDuplicateDigitLength = iDuplicateDigitLength;
    }

    public int getFrameValue() {
        return this._iFrameValue;
    }

    public int getDuplicateIndex() {
        return this._iDuplicateIndex;
    }

    @Nonnull
    public String getMaxFormat() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this._cPrefix != '\u0000') {
            sb.append(this._cPrefix);
        }
        if (this._iFrameDigitLength == 0) {
            sb.append('0');
        } else {
            for (i = 0; i < this._iFrameDigitLength; ++i) {
                sb.append('9');
            }
        }
        if (this._iDuplicateDigitLength == 0) {
            if (this._iDuplicateIndex > 0) {
                sb.append('.');
                sb.append('0');
            }
        } else {
            sb.append('.');
            for (i = 0; i < this._iFrameDigitLength; ++i) {
                sb.append('9');
            }
        }
        return sb.toString();
    }

    @Nonnull
    public String getUnpaddedValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._iFrameValue);
        if (this._iDuplicateIndex > 0 || this._iDuplicateDigitLength > 0) {
            sb.append('.').append(this._iDuplicateIndex);
        }
        return sb.toString();
    }

    @Nonnull
    public String toString() {
        String sPrefix = this._cPrefix == '\u0000' ? "" : String.valueOf(this._cPrefix);
        return sPrefix + FrameNumberNumber.format(this._iFrameValue, this._iFrameDigitLength, this._iDuplicateIndex, this._iDuplicateDigitLength);
    }

    public boolean digitsAreOutOfBounds() {
        return FrameNumberNumber.base10digitCount(this._iFrameValue) > this._iFrameDigitLength || FrameNumberNumber.base10digitCount(this._iDuplicateIndex) > this._iDuplicateDigitLength;
    }
}

