/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.IndexId;
import jpsxdec.modules.sharedaudio.DiscItemAudioStream;
import jpsxdec.util.Misc;

public class ParallelAudio {
    private static final Logger LOG = Logger.getLogger(ParallelAudio.class.getName());
    private final TreeSet<DiscItemAudioStream> _audioStreams = new TreeSet();
    private int _iAudioDiscSpeed = 0;
    @CheckForNull
    private transient ArrayList<DiscItemAudioStream> _longestNonIntersectingAudioStreams;

    public int getAudioDiscSpeed() {
        return this._iAudioDiscSpeed;
    }

    public boolean addChild(@Nonnull DiscItem other, int iParentRating) {
        if (iParentRating == 0) {
            return false;
        }
        DiscItemAudioStream audItem = (DiscItemAudioStream)other;
        this._audioStreams.add(audItem);
        int iAudioItemDiscSpeed = audItem.getDiscSpeed();
        if (iAudioItemDiscSpeed > 0) {
            if (this._iAudioDiscSpeed == 0) {
                this._iAudioDiscSpeed = iAudioItemDiscSpeed;
            } else if (this._iAudioDiscSpeed != iAudioItemDiscSpeed) {
                this._iAudioDiscSpeed = -1;
            }
        }
        audItem.setPartOfVideo(true);
        return true;
    }

    public boolean setIndexId(@Nonnull IndexId childId) {
        for (DiscItemAudioStream audio : this._audioStreams) {
            if (!audio.setIndexId(childId)) continue;
            childId = childId.createNext();
        }
        return true;
    }

    public int getChildCount() {
        return this._audioStreams.size();
    }

    @Nonnull
    public Iterable<DiscItemAudioStream> getChildren() {
        return this._audioStreams;
    }

    public boolean hasAudio() {
        return !this._audioStreams.isEmpty();
    }

    @CheckForNull
    public List<DiscItemAudioStream> getParallelAudioStreams() {
        if (this._audioStreams.isEmpty()) {
            return null;
        }
        return new ArrayList<DiscItemAudioStream>(this._audioStreams);
    }

    public int getCount() {
        return this._audioStreams.size();
    }

    @CheckForNull
    public List<DiscItemAudioStream> getLongestNonIntersectingAudioStreams() {
        if (!this.hasAudio()) {
            return null;
        }
        if (this._longestNonIntersectingAudioStreams != null) {
            return this._longestNonIntersectingAudioStreams;
        }
        if (this._audioStreams.size() == 1) {
            this._longestNonIntersectingAudioStreams = new ArrayList(1);
            this._longestNonIntersectingAudioStreams.add(this._audioStreams.first());
            return this._longestNonIntersectingAudioStreams;
        }
        ArrayList<AudioStreamFormatBucket> streamBuckets = new ArrayList<AudioStreamFormatBucket>();
        Iterator<DiscItemAudioStream> streamIt = this._audioStreams.iterator();
        streamBuckets.add(new AudioStreamFormatBucket(streamIt.next()));
        block0: while (streamIt.hasNext()) {
            DiscItemAudioStream as = streamIt.next();
            for (AudioStreamFormatBucket bucket : streamBuckets) {
                if (!bucket.addIfMatches(as)) continue;
                continue block0;
            }
            streamBuckets.add(new AudioStreamFormatBucket(as));
        }
        Iterator bucketIt = streamBuckets.iterator();
        AudioStreamFormatBucket longestBucket = (AudioStreamFormatBucket)bucketIt.next();
        int iLongestBucket = longestBucket.calculateLongest();
        while (bucketIt.hasNext()) {
            AudioStreamFormatBucket contender = (AudioStreamFormatBucket)bucketIt.next();
            int iContenderLength = contender.calculateLongest();
            if (iContenderLength <= iLongestBucket) continue;
            longestBucket = contender;
            iLongestBucket = iContenderLength;
        }
        this._longestNonIntersectingAudioStreams = longestBucket.getStreams();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Selected {0,number,#} of the {1,number,#} audio streams:", new Object[]{this._longestNonIntersectingAudioStreams.size(), this._audioStreams.size()});
            for (int i = 0; i < this._longestNonIntersectingAudioStreams.size(); ++i) {
                LOG.log(Level.INFO, "{0,number,#}. {1}", new Object[]{i, this._longestNonIntersectingAudioStreams.get(i)});
            }
        }
        return this._longestNonIntersectingAudioStreams;
    }

    private static class AudioStreamFormatBucket
    implements Comparator<DiscItemAudioStream> {
        private final TreeSet<DiscItemAudioStream> _streams = new TreeSet<DiscItemAudioStream>(this);
        private final DiscItemAudioStream _formatChecker;

        public AudioStreamFormatBucket(DiscItemAudioStream first) {
            this._streams.add(first);
            this._formatChecker = first;
        }

        public boolean addIfMatches(DiscItemAudioStream as) {
            if (!this._formatChecker.hasSameFormat(as)) {
                return false;
            }
            this._streams.add(as);
            return true;
        }

        public int calculateLongest() {
            Iterator<DiscItemAudioStream> it = this._streams.iterator();
            DiscItemAudioStream earliestFinishingTime = it.next();
            int iLength = earliestFinishingTime.getSectorLength();
            while (it.hasNext()) {
                DiscItemAudioStream contender = it.next();
                if (contender.overlaps(earliestFinishingTime)) {
                    it.remove();
                    continue;
                }
                earliestFinishingTime = contender;
                iLength += earliestFinishingTime.getSectorLength();
            }
            return iLength;
        }

        @Override
        public int compare(DiscItemAudioStream o1, DiscItemAudioStream o2) {
            return Misc.intCompare(o1.getEndSector(), o2.getEndSector());
        }

        private ArrayList<DiscItemAudioStream> getStreams() {
            ArrayList<DiscItemAudioStream> streams = new ArrayList<DiscItemAudioStream>(this._streams);
            Collections.sort(streams);
            return streams;
        }
    }
}

