/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video;

import java.io.PrintStream;
import java.util.List;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.DebugLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.ISectorClaimToDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.psxvideo.mdec.ParsedMdecImage;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.Fraction;
import jpsxdec.util.player.PlayController;

public abstract class DiscItemVideoStream
extends DiscItem {
    @Nonnull
    private final Dimensions _dims;
    @Nonnull
    protected final IndexSectorFrameNumber.Format _indexSectorFrameNumberFormat;

    public DiscItemVideoStream(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, @Nonnull Dimensions dim, @Nonnull IndexSectorFrameNumber.Format frameNumberFormat) {
        super(cd, iStartSector, iEndSector);
        this._dims = dim;
        this._indexSectorFrameNumberFormat = frameNumberFormat;
    }

    public DiscItemVideoStream(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._dims = new Dimensions(fields);
        this._indexSectorFrameNumberFormat = new IndexSectorFrameNumber.Format(fields);
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem serial = super.serialize();
        this._dims.serialize(serial);
        this._indexSectorFrameNumberFormat.serialize(serial);
        return serial;
    }

    @Override
    @Nonnull
    public final DiscItem.GeneralType getType() {
        return DiscItem.GeneralType.Video;
    }

    public final int getWidth() {
        return this._dims.getWidth();
    }

    public final int getHeight() {
        return this._dims.getHeight();
    }

    public final boolean shouldBeCropped() {
        return this._dims.shouldBeCropped();
    }

    @Nonnull
    public abstract FrameNumber getStartFrame();

    @Nonnull
    public abstract FrameNumber getEndFrame();

    @Nonnull
    public abstract List<FrameNumber.Type> getFrameNumberTypes();

    public final int getFrameCount() {
        return this._indexSectorFrameNumberFormat.getFrameCount();
    }

    public abstract int getDiscSpeed();

    @Nonnull
    public abstract Fraction getSectorsPerFrame();

    public abstract int getAbsolutePresentationStartSector();

    public abstract boolean hasIndependentBitstream();

    public abstract double getApproxDuration();

    @Nonnull
    public abstract PlayController makePlayController();

    @Nonnull
    public abstract ISectorClaimToDemuxedFrame makeDemuxer();

    public final void frameInfoDump(final @Nonnull PrintStream ps, final boolean blnMore) {
        ISectorClaimToDemuxedFrame demuxer = this.makeDemuxer();
        demuxer.setFrameListener(new IDemuxedFrame.Listener(){

            @Override
            public void frameComplete(IDemuxedFrame frame) {
                block8: {
                    MdecInputStream mis = frame.getCustomFrameMdecStream();
                    try {
                        if (mis != null) {
                            ps.println(frame);
                            ps.println("Frame data info: " + mis);
                            if (blnMore) {
                                ParsedMdecImage parsed = new ParsedMdecImage(mis, DiscItemVideoStream.this.getWidth(), DiscItemVideoStream.this.getHeight());
                                parsed.drawMacroBlocks(ps);
                            }
                            break block8;
                        }
                        try {
                            SectorBasedFrameAnalysis frameAnalysis = SectorBasedFrameAnalysis.create(frame);
                            frameAnalysis.printInfo(ps);
                            if (blnMore) {
                                frameAnalysis.drawMacroBlocks(ps);
                            }
                        }
                        catch (BinaryDataNotRecognized ex) {
                            ps.println("Frame not recognized");
                            ex.printStackTrace(ps);
                        }
                    }
                    catch (MdecException.EndOfStream ex) {
                        ex.printStackTrace(ps);
                    }
                    catch (MdecException.ReadCorruption ex) {
                        ex.printStackTrace(ps);
                    }
                }
                System.out.println("_____________________________________________________________________");
            }
        });
        System.out.println(this);
        SectorClaimSystem it = this.createClaimSystem();
        demuxer.attachToSectorClaimer(it);
        while (it.hasNext()) {
            try {
                IIdentifiedSector sector = it.next(DebugLogger.Log);
            }
            catch (CdFileSectorReader.CdReadException ex) {
                throw new RuntimeException("IO error with dev tool", ex);
            }
        }
        it.close(DebugLogger.Log);
    }
}

