/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video;

import javax.annotation.Nonnull;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;

public class Dimensions {
    private static final String DIMENSIONS_KEY = "Dimensions";
    private final int _iWidth;
    private final int _iHeight;

    public Dimensions(int iWidth, int iHeight) {
        this._iWidth = iWidth;
        this._iHeight = iHeight;
    }

    public Dimensions(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        int[] ai = fields.getDimensions(DIMENSIONS_KEY);
        this._iWidth = ai[0];
        this._iHeight = ai[1];
    }

    public void serialize(@Nonnull SerializedDiscItem serial) {
        serial.addDimensions(DIMENSIONS_KEY, this._iWidth, this._iHeight);
    }

    public int getWidth() {
        return this._iWidth;
    }

    public int getHeight() {
        return this._iHeight;
    }

    public boolean shouldBeCropped() {
        return this._iHeight % 16 != 0 || this._iWidth % 16 != 0;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + this._iWidth;
        hash = 67 * hash + this._iHeight;
        return hash;
    }

    public boolean equals(int iWidth, int iHeight) {
        return this._iWidth == iWidth && this._iHeight == iHeight;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dimensions other = (Dimensions)obj;
        return this._iWidth == other._iWidth && this._iHeight == other._iHeight;
    }

    public String toString() {
        return this._iWidth + "x" + this._iHeight;
    }
}

