/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.video;

import java.util.List;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.modules.sharedaudio.DiscItemAudioStream;
import jpsxdec.modules.sharedaudio.ISectorAudioDecoder;

public class AudioStreamsCombiner
implements ISectorAudioDecoder {
    @Nonnull
    private final AudioFormat _outFormat;
    private final int _iSampleRate;
    private int _iStartSector;
    private int _iEndSector;
    private int _iPresStartSector;
    private final int _iDiscSpeed;
    @Nonnull
    private final ISectorAudioDecoder[] _aoDecoders;
    @Nonnull
    private final DiscItemAudioStream[] _aoSrcItems;

    public AudioStreamsCombiner(@Nonnull List<DiscItemAudioStream> audStreams, double dblVolume) {
        if (AudioStreamsCombiner.thereIsOverlap(audStreams)) {
            throw new IllegalArgumentException("Streams are not mutually exclusive.");
        }
        this._aoSrcItems = audStreams.toArray(new DiscItemAudioStream[audStreams.size()]);
        this._aoDecoders = new ISectorAudioDecoder[this._aoSrcItems.length];
        boolean blnIsStereo = audStreams.get(0).isStereo();
        this._iSampleRate = audStreams.get(0).getSampleFramesPerSecond();
        this._iStartSector = audStreams.get(0).getStartSector();
        this._iEndSector = audStreams.get(0).getEndSector();
        this._iPresStartSector = audStreams.get(0).getPresentationStartSector();
        int iDiscSpeed = audStreams.get(0).getDiscSpeed();
        this._aoDecoders[0] = audStreams.get(0).makeDecoder(dblVolume);
        for (int i = 1; i < this._aoDecoders.length; ++i) {
            DiscItemAudioStream aud = audStreams.get(i);
            if (!aud.hasSameFormat(audStreams.get(0))) {
                throw new IllegalArgumentException("Different format audio.");
            }
            if (iDiscSpeed > 0) {
                if (aud.getDiscSpeed() > 0 && iDiscSpeed != aud.getDiscSpeed()) {
                    throw new IllegalArgumentException("Different disc speeds.");
                }
            } else {
                iDiscSpeed = aud.getDiscSpeed();
            }
            this._iStartSector = Math.min(this._iStartSector, aud.getStartSector());
            this._iEndSector = Math.max(this._iEndSector, aud.getEndSector());
            this._iPresStartSector = Math.min(this._iPresStartSector, aud.getPresentationStartSector());
            this._aoDecoders[i] = aud.makeDecoder(dblVolume);
        }
        this._iDiscSpeed = iDiscSpeed;
        this._outFormat = new AudioFormat(this._iSampleRate, 16, blnIsStereo ? 2 : 1, true, false);
    }

    private static boolean thereIsOverlap(@Nonnull List<DiscItemAudioStream> audStreams) {
        for (int i = 0; i < audStreams.size(); ++i) {
            for (int j = i + 1; j < audStreams.size(); ++j) {
                if (!audStreams.get(i).overlaps(audStreams.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        for (ISectorAudioDecoder decoder : this._aoDecoders) {
            decoder.attachToSectorClaimer(scs);
        }
    }

    @Override
    public void setAudioListener(@Nonnull DecodedAudioPacket.Listener listener) {
        for (ISectorAudioDecoder decoder : this._aoDecoders) {
            decoder.setAudioListener(listener);
        }
    }

    @Override
    public double getVolume() {
        return this._aoDecoders[0].getVolume();
    }

    @Override
    @Nonnull
    public AudioFormat getOutputFormat() {
        return this._outFormat;
    }

    @Override
    public int getSampleFramesPerSecond() {
        return this._iSampleRate;
    }

    @Override
    public int getDiscSpeed() {
        return this._iDiscSpeed;
    }

    @Override
    public int getStartSector() {
        return this._iStartSector;
    }

    @Override
    public int getEndSector() {
        return this._iEndSector;
    }

    @Override
    public int getAbsolutePresentationStartSector() {
        return this._iPresStartSector;
    }
}

