/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.tim;

import com.jhlabs.awt.ParagraphLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jpsxdec.discitems.CombinedBuilderListener;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.discitems.DiscItemSaverBuilderGui;
import jpsxdec.discitems.ParagraphPanel;
import jpsxdec.i18n.I;
import jpsxdec.modules.tim.TimPaletteSelector;
import jpsxdec.modules.tim.TimSaverBuilder;
import jpsxdec.tim.Tim;

class TimSaverBuilderGui
extends DiscItemSaverBuilderGui
implements ChangeListener {
    private static final Logger LOG = Logger.getLogger(TimSaverBuilderGui.class.getName());
    @Nonnull
    private final CombinedBuilderListener<TimSaverBuilder> _bl;
    private final JPanel _panelImages = new JPanel(new GridLayout());

    public TimSaverBuilderGui(@Nonnull TimSaverBuilder builder) {
        super(new BorderLayout());
        this._bl = new CombinedBuilderListener<TimSaverBuilder>(builder);
        this.updatePreviews();
        this.add((Component)new PPanel(this._bl), "North");
        this.add((Component)this._panelImages, "Center");
        this._bl.addListeners(this);
    }

    @Override
    public boolean useSaverBuilder(@Nonnull DiscItemSaverBuilder saverBuilder) {
        boolean blnOk = this._bl.changeSourceBuilder(saverBuilder);
        if (blnOk) {
            this.updatePreviews();
        }
        return blnOk;
    }

    @Override
    public void stateChanged(@CheckForNull ChangeEvent e) {
        for (Component c : this._panelImages.getComponents()) {
            if (!(c instanceof TimPaletteSelector)) continue;
            ((TimPaletteSelector)c).stateChanged();
        }
    }

    private void updatePreviews() {
        this._panelImages.removeAll();
        GridLayout gl = (GridLayout)this._panelImages.getLayout();
        try {
            Tim tim = this._bl.getBuilder().readTim();
            int iPals = tim.getPaletteCount();
            double dblPalSqrt = Math.sqrt(iPals);
            gl.setRows((int)Math.floor(dblPalSqrt));
            gl.setColumns((int)Math.ceil(dblPalSqrt));
            for (int i = 0; i < iPals; ++i) {
                this._panelImages.add(new TimPaletteSelector(tim, i, this._bl.getBuilder()));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error reading TIM preview", ex);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            gl.setRows(1);
            gl.setColumns(1);
            JTextArea t = new JTextArea(I.GUI_TIM_ERR_READING_PREVIEW(sw.toString()).getLocalizedMessage());
            t.setLineWrap(true);
            this._panelImages.add(new JScrollPane(t));
        }
    }

    private static class PPanel
    extends ParagraphPanel {
        @Nonnull
        private final CombinedBuilderListener<TimSaverBuilder> _bl;

        private PPanel(@Nonnull CombinedBuilderListener<TimSaverBuilder> bl) {
            this._bl = bl;
            this._bl.addListeners(new FileNames(), new Format());
        }

        static /* synthetic */ JTextArea access$100(int x0) {
            return PPanel.makeMultiLineJLabel(x0);
        }

        private class Format
        extends ParagraphPanel.AbstractCombo {
            public Format() {
                super(I.GUI_TIM_SAVE_FORMAT_LABEL(), true);
            }

            @Override
            public int getSize() {
                return ((TimSaverBuilder)PPanel.this._bl.getBuilder()).getImageFormat_listSize();
            }

            @Override
            public Object getElementAt(int index) {
                return ((TimSaverBuilder)PPanel.this._bl.getBuilder()).getImageFormat_listItem(index);
            }

            @Override
            public void setSelectedItem(Object anItem) {
                ((TimSaverBuilder)PPanel.this._bl.getBuilder()).setImageFormat((TimSaverBuilder.TimSaveFormat)anItem);
            }

            @Override
            public Object getSelectedItem() {
                return ((TimSaverBuilder)PPanel.this._bl.getBuilder()).getImageFormat();
            }

            @Override
            protected boolean getEnabled() {
                return true;
            }
        }

        private class FileNames
        implements ChangeListener {
            final JTextArea __files = PPanel.access$100(3);

            public FileNames() {
                this.updateText();
                JScrollPane p = new JScrollPane(this.__files);
                p.setBorder(null);
                PPanel.this.add((Component)new JLabel(I.GUI_SAVE_AS_LABEL().getLocalizedMessage()), ParagraphLayout.NEW_PARAGRAPH);
                PPanel.this.add((Component)p, ParagraphLayout.STRETCH_H);
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.updateText();
            }

            private void updateText() {
                this.__files.setText(((TimSaverBuilder)PPanel.this._bl.getBuilder()).getOutputFilesSummary().getLocalizedMessage());
            }
        }
    }
}

