/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.tim;

import argparser.StringHolder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.discitems.DiscItemSaverBuilderGui;
import jpsxdec.formats.JavaImageFormat;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.TabularFeedback;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.exception.LocalizedFileNotFoundException;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.modules.tim.DiscItemTim;
import jpsxdec.modules.tim.TimSaverBuilderGui;
import jpsxdec.tim.Tim;
import jpsxdec.util.ArgParser;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;
import jpsxdec.util.TaskCanceledException;

public class TimSaverBuilder
extends DiscItemSaverBuilder {
    private static final Logger LOG = Logger.getLogger(TimSaverBuilder.class.getName());
    public static final TimSaveFormat TIM = new TimSaveFormat();
    private static final ArrayList<TimSaveFormat> TRUE_COLOR_FORMAT_LIST;
    private static final ArrayList<TimSaveFormat> TRUE_COLOR_ALPHA_FORMAT_LIST;
    private static final ArrayList<TimSaveFormat> PALETTE_FORMAT_LIST;
    @Nonnull
    private final DiscItemTim _timItem;
    @Nonnull
    private final List<TimSaveFormat> _validFormats;
    @Nonnull
    private final boolean[] _ablnSavePalette;
    @Nonnull
    private TimSaveFormat _saveFormat;

    @Nonnull
    public static List<TimSaveFormat> getValidFormats(int iBpp) {
        switch (iBpp) {
            case 4: 
            case 8: {
                return PALETTE_FORMAT_LIST;
            }
            case 16: {
                return TRUE_COLOR_ALPHA_FORMAT_LIST;
            }
            case 24: {
                return TRUE_COLOR_FORMAT_LIST;
            }
        }
        throw new IllegalArgumentException("Impossible Tim bpp " + iBpp);
    }

    public TimSaverBuilder(@Nonnull DiscItemTim timItem) {
        this._timItem = timItem;
        this._ablnSavePalette = new boolean[this._timItem.getPaletteCount()];
        this._validFormats = TimSaverBuilder.getValidFormats(this._timItem.getBitsPerPixel());
        Arrays.fill(this._ablnSavePalette, true);
        this._saveFormat = this._validFormats.get(0);
    }

    @Override
    @Nonnull
    public DiscItemTim getDiscItem() {
        return this._timItem;
    }

    @Override
    public boolean copySettingsTo(@Nonnull DiscItemSaverBuilder other) {
        if (!(other instanceof TimSaverBuilder)) {
            return false;
        }
        TimSaverBuilder otherTim = (TimSaverBuilder)other;
        otherTim.setImageFormat(this.getImageFormat());
        return true;
    }

    public int getPaletteCount() {
        return this._timItem.getPaletteCount();
    }

    public void setSavePalette(int iPalette, boolean blnSave) {
        this._ablnSavePalette[iPalette] = blnSave;
        this.firePossibleChange();
    }

    public void toggleSavePalette(int iPalette) {
        this._ablnSavePalette[iPalette] = !this._ablnSavePalette[iPalette];
        this.firePossibleChange();
    }

    public boolean getSavePalette(int iPalette) {
        if (this.getImageFormat() == TIM) {
            return true;
        }
        return this._ablnSavePalette[iPalette];
    }

    public boolean getPaletteSelection_enabled() {
        return this._saveFormat != TIM;
    }

    public void setImageFormat(@Nonnull TimSaveFormat fmt) {
        this._saveFormat = fmt;
        this.firePossibleChange();
    }

    @Nonnull
    public TimSaveFormat getImageFormat() {
        return this._saveFormat;
    }

    public int getImageFormat_listSize() {
        return this._validFormats.size();
    }

    public TimSaveFormat getImageFormat_listItem(int i) {
        return this._validFormats.get(i);
    }

    @Nonnull
    public ILocalizedMessage getOutputFilesSummary() {
        if (this._saveFormat == TIM) {
            return new UnlocalizedMessage(this.makeTimFileName());
        }
        JavaImageFormat format = this._saveFormat.getJavaFormat();
        int iCount = 0;
        String sStartFile = null;
        String sEndFile = null;
        for (int iCurrentImage = 0; iCurrentImage < this._ablnSavePalette.length; ++iCurrentImage) {
            if (!this._ablnSavePalette[iCurrentImage]) continue;
            ++iCount;
            String sFile = this.makePaletteFileName(iCurrentImage, format);
            if (sStartFile == null) {
                sStartFile = sFile;
            }
            sEndFile = sFile;
        }
        if (iCount == 0) {
            return I.TIM_OUTPUT_FILES_NONE();
        }
        if (sStartFile == sEndFile) {
            return new UnlocalizedMessage(sStartFile);
        }
        return I.TIM_OUTPUT_FILES(iCount, sStartFile, sEndFile);
    }

    @Nonnull
    private String makePaletteFileName(int iFile, @Nonnull JavaImageFormat format) {
        return String.format("%s_p%02d.%s", this._timItem.getSuggestedBaseName(), iFile, format.getExtension());
    }

    @Nonnull
    Tim readTim() throws CdFileSectorReader.CdReadException, BinaryDataNotRecognized {
        return this._timItem.readTim();
    }

    @CheckForNull
    private TimSaveFormat fromCmdLine(@Nonnull String sCmdLine) {
        for (TimSaveFormat fmt : this._validFormats) {
            if (!fmt.getUiId().equalsIgnoreCase(sCmdLine)) continue;
            return fmt;
        }
        return null;
    }

    @Override
    public void commandLineOptions(@Nonnull ArgParser ap, @Nonnull FeedbackStream fbs) {
        if (!ap.hasRemaining()) {
            return;
        }
        StringHolder timpalettes = ap.addStringOption("-pal");
        StringHolder format = ap.addStringOption("-imgfmt", "-if");
        ap.match();
        if (timpalettes.value != null) {
            boolean[] ablnNewValues = TimSaverBuilder.parseNumberListRange(timpalettes.value, this.getPaletteCount());
            if (ablnNewValues == null) {
                fbs.printlnWarn(I.CMD_IGNORING_INVALID_VALUE_FOR_CMD(timpalettes.value, "-pal"));
            } else {
                System.arraycopy(ablnNewValues, 0, this._ablnSavePalette, 0, this.getPaletteCount());
            }
        }
        if (format.value != null) {
            TimSaveFormat fmt = this.fromCmdLine(format.value);
            if (fmt == null) {
                fbs.printlnWarn(I.CMD_IGNORING_INVALID_VALUE_FOR_CMD(format.value, "-if,-imgfmt"));
            } else {
                this.setImageFormat(fmt);
            }
        }
    }

    @CheckForNull
    private static boolean[] parseNumberListRange(@Nonnull String s, int iMax) {
        try {
            boolean[] abln = new boolean[iMax];
            Arrays.fill(abln, false);
            for (String num : s.split(",")) {
                if (num.indexOf(45) > 0) {
                    String[] asParts = num.split("-");
                    for (int i = Integer.parseInt(asParts[0]); i <= Integer.parseInt(asParts[1]); ++i) {
                        abln[i] = true;
                    }
                    continue;
                }
                abln[Integer.parseInt((String)num)] = true;
            }
            return abln;
        }
        catch (NumberFormatException ex) {
            return null;
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    @Override
    public void printHelp(@Nonnull FeedbackStream fbs) {
        TabularFeedback tfb = new TabularFeedback();
        tfb.setRowSpacing(1);
        tfb.addCell(I.CMD_TIM_PAL()).addCell(I.CMD_TIM_PAL_HELP());
        tfb.newRow();
        tfb.addCell(I.CMD_TIM_IF());
        TabularFeedback.Cell c = new TabularFeedback.Cell(I.CMD_TIM_IF_HELP(this._validFormats.get(0).getExtension()));
        for (TimSaveFormat fmt : this._validFormats) {
            c.addLine(new UnlocalizedMessage(fmt.getExtension()), 2);
        }
        tfb.addCell(c);
        tfb.write(fbs.getUnderlyingStream());
    }

    @Override
    public void printSelectedOptions(@Nonnull ILocalizedLogger log) {
        log.log(Level.INFO, I.CMD_TIM_SAVE_FORMAT(this.getImageFormat().getExtension()));
        log.log(Level.INFO, this.getOutputFilesSummary());
    }

    @Nonnull
    private String makeTimFileName() {
        return this._timItem.getSuggestedBaseName() + ".tim";
    }

    @Override
    @Nonnull
    public ILocalizedMessage getOutputSummary() {
        return this.getOutputFilesSummary();
    }

    @Override
    @Nonnull
    public DiscItemSaverBuilderGui getOptionPane() {
        return new TimSaverBuilderGui(this);
    }

    @Override
    public void startSave(@Nonnull ProgressLogger pl, @CheckForNull File directory) throws LoggedFailure, TaskCanceledException {
        this.clearGeneratedFiles();
        this.printSelectedOptions(pl);
        if (this.getImageFormat() == TIM) {
            this.startSaveTim(pl, directory, this.makeTimFileName());
        } else {
            String[] asOutputFiles = new String[this._ablnSavePalette.length];
            for (int i = 0; i < asOutputFiles.length; ++i) {
                if (!this._ablnSavePalette[i]) continue;
                asOutputFiles[i] = this.makePaletteFileName(i, this.getImageFormat().getJavaFormat());
            }
            this.startSaveImage(pl, directory, asOutputFiles, this.getImageFormat().getJavaFormat());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startSaveTim(@Nonnull ProgressLogger pl, @CheckForNull File outputDir, @Nonnull String sOutputFile) throws LoggedFailure, TaskCanceledException {
        Tim tim;
        File outputFile = new File(outputDir, sOutputFile);
        pl.progressStart(1.0);
        try {
            tim = this._timItem.readTim();
        }
        catch (CdFileSectorReader.CdReadException ex) {
            throw new LoggedFailure(pl, Level.SEVERE, I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), ex);
        }
        catch (BinaryDataNotRecognized ex) {
            throw new LoggedFailure(pl, Level.SEVERE, I.TIM_DATA_NOT_FOUND(), ex);
        }
        if (tim.timHasIssues()) {
            pl.log(Level.WARNING, I.TIM_HAS_ISSUES_CAN_BE_EXTRACTED(tim.toString()));
        }
        pl.event(I.IO_WRITING_FILE(outputFile.getName()));
        try {
            IO.makeDirsForFile(outputFile);
            BufferedOutputStream os = null;
            try {
                this.addGeneratedFile(outputFile);
                os = new BufferedOutputStream(new FileOutputStream(outputFile));
                tim.write(os);
            }
            catch (FileNotFoundException ex) {
                try {
                    throw new LoggedFailure(pl, Level.SEVERE, I.IO_OPENING_FILE_ERROR_NAME(outputFile.toString()), ex);
                    catch (IOException ex2) {
                        throw new LoggedFailure(pl, Level.SEVERE, I.IO_WRITING_FILE_ERROR_NAME(outputFile.toString()), ex2);
                    }
                }
                catch (Throwable throwable) {
                    IO.closeSilently(os, LOG);
                    throw throwable;
                }
            }
            IO.closeSilently(os, LOG);
        }
        catch (LocalizedFileNotFoundException ex) {
            throw new LoggedFailure(pl, Level.SEVERE, ex.getSourceMessage(), ex);
        }
        pl.progressEnd();
    }

    public void startSaveImage(@Nonnull ProgressLogger pl, @CheckForNull File outputDir, @Nonnull String[] _asOutputFiles, @Nonnull JavaImageFormat _imageFormat) throws LoggedFailure, TaskCanceledException {
        Tim tim;
        pl.progressStart(_asOutputFiles.length);
        try {
            tim = this._timItem.readTim();
        }
        catch (CdFileSectorReader.CdReadException ex) {
            throw new LoggedFailure(pl, Level.SEVERE, I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), ex);
        }
        catch (BinaryDataNotRecognized ex) {
            throw new LoggedFailure(pl, Level.SEVERE, I.TIM_DATA_NOT_FOUND(), ex);
        }
        for (int i = 0; i < _asOutputFiles.length; ++i) {
            block10: {
                if (_asOutputFiles[i] != null) {
                    String sFile = _asOutputFiles[i];
                    BufferedImage bi = tim.toBufferedImage(i);
                    File f = new File(outputDir, sFile);
                    try {
                        pl.event(I.IO_WRITING_FILE(f.toString()));
                        IO.makeDirsForFile(f);
                        try {
                            boolean blnOk = ImageIO.write((RenderedImage)bi, _imageFormat.getImageIOid(), f);
                            if (blnOk) {
                                this.addGeneratedFile(f);
                                break block10;
                            }
                            pl.log(Level.SEVERE, I.CMD_PALETTE_IMAGE_SAVE_FAIL(f, i));
                        }
                        catch (IOException ex) {
                            pl.log(Level.SEVERE, I.IO_WRITING_FILE_ERROR_NAME(f.toString()), ex);
                        }
                    }
                    catch (LocalizedFileNotFoundException ex) {
                        pl.log(Level.SEVERE, ex.getSourceMessage(), ex);
                    }
                }
            }
            pl.progressUpdate(i);
        }
        pl.progressEnd();
    }

    static {
        List<JavaImageFormat> availableFormats = JavaImageFormat.getAvailable();
        int iMaxListSize = availableFormats.size() + 1;
        TRUE_COLOR_FORMAT_LIST = new ArrayList(iMaxListSize);
        TRUE_COLOR_ALPHA_FORMAT_LIST = new ArrayList(iMaxListSize);
        PALETTE_FORMAT_LIST = new ArrayList(iMaxListSize);
        for (JavaImageFormat jif : availableFormats) {
            if (!jif.isAvailable()) continue;
            if (jif.hasTrueColor()) {
                TRUE_COLOR_FORMAT_LIST.add(new TimSaveFormat(jif));
                if (jif.hasAlpha()) {
                    TRUE_COLOR_ALPHA_FORMAT_LIST.add(new TimSaveFormat(jif));
                }
            }
            PALETTE_FORMAT_LIST.add(new TimSaveFormat(jif));
        }
        TRUE_COLOR_FORMAT_LIST.add(TIM);
        TRUE_COLOR_ALPHA_FORMAT_LIST.add(TIM);
        PALETTE_FORMAT_LIST.add(TIM);
    }

    public static class TimSaveFormat {
        @CheckForNull
        private final JavaImageFormat _javaFmt;

        private TimSaveFormat() {
            this._javaFmt = null;
        }

        private TimSaveFormat(@Nonnull JavaImageFormat eJavaFmt) {
            this._javaFmt = eJavaFmt;
        }

        @Nonnull
        private String getUiId() {
            if (this._javaFmt == null) {
                return "tim";
            }
            return this._javaFmt.getUiId();
        }

        @Nonnull
        public JavaImageFormat getJavaFormat() {
            if (this._javaFmt == null) {
                throw new UnsupportedOperationException("TIM does not have a Java image format");
            }
            return this._javaFmt;
        }

        public String toString() {
            if (this._javaFmt == null) {
                return "tim";
            }
            return this._javaFmt.toString();
        }

        public String getExtension() {
            if (this._javaFmt == null) {
                return "tim";
            }
            return this._javaFmt.getExtension();
        }
    }
}

