/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.tim;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import jpsxdec.i18n.I;
import jpsxdec.modules.tim.TimSaverBuilder;
import jpsxdec.tim.Tim;

public class TimPaletteSelector
extends JPanel {
    @Nonnull
    private final Tim _tim;
    private final int _iPalette;
    @Nonnull
    private final TimSaverBuilder _writerBuilder;
    @Nonnull
    private final Mod _btnModel;
    private JButton _guiCopyBtn;
    private JCheckBox _guiPalChk;

    public TimPaletteSelector(@Nonnull Tim tim, int iPalette, @Nonnull TimSaverBuilder builder) {
        this.initComponents();
        this._tim = tim;
        this._iPalette = iPalette;
        this._guiPalChk.setText(Integer.toString(iPalette));
        this._writerBuilder = builder;
        this._btnModel = new Mod();
        this._guiPalChk.setModel(this._btnModel);
    }

    @Override
    protected void paintChildren(Graphics g) {
        double dblVScale;
        int iWidth = this.getWidth() - 4;
        int iHeight = this.getHeight() - 4;
        double dblHScale = (double)iWidth / (double)this._tim.getPixelWidth();
        double dblScale = dblHScale < (dblVScale = (double)iHeight / (double)this._tim.getPixelHeight()) ? dblHScale : dblVScale;
        if (dblScale > 2.0) {
            dblScale = 2.0;
        }
        iWidth = (int)((double)this._tim.getPixelWidth() * dblScale);
        iHeight = (int)((double)this._tim.getPixelHeight() * dblScale);
        BufferedImage bi = this._tim.toBufferedImage(this._iPalette);
        g.drawImage(bi, 1, 1, iWidth, iHeight, null);
        super.paintChildren(g);
    }

    void setChecked(boolean b) {
        this._guiPalChk.getModel().setSelected(b);
    }

    public boolean getChecked() {
        return this._guiPalChk.getModel().isSelected();
    }

    public void stateChanged() {
        this._btnModel.stateChanged();
    }

    private void initComponents() {
        this._guiPalChk = new JCheckBox();
        this._guiCopyBtn = new JButton();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        this._guiPalChk.setSelected(true);
        this._guiPalChk.setText("##");
        this._guiPalChk.setHorizontalAlignment(4);
        this._guiPalChk.setHorizontalTextPosition(2);
        this._guiPalChk.setMargin(new Insets(0, 0, 0, 0));
        this._guiPalChk.setVerticalAlignment(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 24;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this._guiPalChk, gridBagConstraints);
        this._guiCopyBtn.setIcon(new ImageIcon(this.getClass().getResource("/jpsxdec/modules/tim/edit-paste-4.png")));
        this._guiCopyBtn.setToolTipText(I.GUI_COPY_TO_CLIPBOARD_TOOLTIP().getLocalizedMessage());
        this._guiCopyBtn.setAlignmentY(0.0f);
        this._guiCopyBtn.setMargin(new Insets(0, 0, 0, 0));
        this._guiCopyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimPaletteSelector.this._guiCopyBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this._guiCopyBtn, gridBagConstraints);
    }

    private void _guiCopyBtnActionPerformed(ActionEvent evt) {
        TimPaletteSelector.copyToClipboard(this._tim.toBufferedImage(this._iPalette));
    }

    private static void copyToClipboard(@Nonnull Image image) {
        ImageTransferable transferable = new ImageTransferable(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
    }

    private static class ImageTransferable
    implements Transferable {
        @Nonnull
        private final Image _image;

        public ImageTransferable(@Nonnull Image image) {
            this._image = image;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (this.isDataFlavorSupported(flavor)) {
                return this._image;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == DataFlavor.imageFlavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }
    }

    private class Mod
    extends JToggleButton.ToggleButtonModel {
        private Mod() {
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
            TimPaletteSelector.this._writerBuilder.setSavePalette(TimPaletteSelector.this._iPalette, b);
        }

        @Override
        public boolean isSelected() {
            return TimPaletteSelector.this._writerBuilder.getSavePalette(TimPaletteSelector.this._iPalette);
        }

        @Override
        public boolean isEnabled() {
            return TimPaletteSelector.this._writerBuilder.getPaletteSelection_enabled();
        }

        public void stateChanged() {
            super.setSelected(TimPaletteSelector.this._writerBuilder.getSavePalette(TimPaletteSelector.this._iPalette));
        }
    }
}

