/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.tim;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.DiscPatcher;
import jpsxdec.discitems.DemuxedSectorInputStream;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.FeedbackStream;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.modules.tim.TimSaverBuilder;
import jpsxdec.tim.Tim;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;

public class DiscItemTim
extends DiscItem
implements DiscItem.IHasStartOffset {
    private static final Logger LOG = Logger.getLogger(DiscItemTim.class.getName());
    public static final String TYPE_ID = "Tim";
    private static final String START_OFFSET_KEY = "Start Offset";
    private final int _iStartOffset;
    private static final String PALETTE_COUNT_KEY = "Palettes";
    private final int _iPaletteCount;
    private static final String BITSPERPIXEL_KEY = "Bpp";
    private final int _iBitsPerPixel;
    private static final String DIMENSIONS_KEY = "Dimensions";
    private final int _iWidth;
    private final int _iHeight;

    public DiscItemTim(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, int iStartOffset, int iPaletteCount, int iBitsPerPixel, int iWidth, int iHeight) {
        super(cd, iStartSector, iEndSector);
        this._iStartOffset = iStartOffset;
        this._iPaletteCount = iPaletteCount;
        this._iBitsPerPixel = iBitsPerPixel;
        this._iWidth = iWidth;
        this._iHeight = iHeight;
    }

    public DiscItemTim(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._iStartOffset = fields.getInt(START_OFFSET_KEY);
        this._iPaletteCount = fields.getInt(PALETTE_COUNT_KEY);
        this._iBitsPerPixel = fields.getInt(BITSPERPIXEL_KEY);
        int[] aiDims = fields.getDimensions(DIMENSIONS_KEY);
        this._iWidth = aiDims[0];
        this._iHeight = aiDims[1];
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem fields = super.serialize();
        fields.addNumber(START_OFFSET_KEY, this._iStartOffset);
        fields.addDimensions(DIMENSIONS_KEY, this._iWidth, this._iHeight);
        fields.addNumber(PALETTE_COUNT_KEY, this._iPaletteCount);
        fields.addNumber(BITSPERPIXEL_KEY, this._iBitsPerPixel);
        return fields;
    }

    @Override
    @Nonnull
    public String getSerializationTypeId() {
        return TYPE_ID;
    }

    @Override
    @Nonnull
    public ILocalizedMessage getInterestingDescription() {
        return I.GUI_TIM_IMAGE_DETAILS(this._iWidth, this._iHeight, this._iPaletteCount);
    }

    @Override
    @Nonnull
    public TimSaverBuilder makeSaverBuilder() {
        return new TimSaverBuilder(this);
    }

    @Override
    @Nonnull
    public DiscItem.GeneralType getType() {
        return DiscItem.GeneralType.Image;
    }

    @Override
    public int getStartOffset() {
        return this._iStartOffset;
    }

    public int getPaletteCount() {
        return this._iPaletteCount;
    }

    public int getBitsPerPixel() {
        return this._iBitsPerPixel;
    }

    @Nonnull
    public Tim readTim() throws CdFileSectorReader.CdReadException, BinaryDataNotRecognized {
        DemuxedSectorInputStream stream = new DemuxedSectorInputStream(this.getSourceCd(), this.getStartSector(), this.getStartOffset());
        try {
            return Tim.read(stream);
        }
        catch (IOException ex) {
            if (ex instanceof CdFileSectorReader.CdReadException) {
                throw (CdFileSectorReader.CdReadException)ex;
            }
            throw new CdFileSectorReader.CdReadException(this.getSourceCd().getSourceFile(), ex);
        }
    }

    public int getWidth() {
        return this._iWidth;
    }

    public int getHeight() {
        return this._iHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(@Nonnull FeedbackStream fbs, @Nonnull File timFile) throws FileNotFoundException, EOFException, IOException, BinaryDataNotRecognized, LocalizedIncompatibleException, CdFileSectorReader.CdReadException, DiscPatcher.WritePatchException {
        Tim newTim;
        FileInputStream fis = new FileInputStream(timFile);
        try {
            newTim = Tim.read(fis);
        }
        finally {
            IO.closeSilently(fis, LOG);
        }
        this.replace(fbs, newTim);
    }

    public void replace(@Nonnull FeedbackStream fbs, @Nonnull Tim newTim) throws LocalizedIncompatibleException, CdFileSectorReader.CdReadException, DiscPatcher.WritePatchException {
        byte[] abNewTim;
        Tim currentTim = null;
        try {
            currentTim = this.readTim();
        }
        catch (CdFileSectorReader.CdReadException ex) {
            throw new RuntimeException("Existing tim unreadable", ex);
        }
        catch (BinaryDataNotRecognized ex) {
            throw new RuntimeException("Existing tim unreadable", ex);
        }
        Tim.Mismatch result = currentTim.matches(newTim);
        if (result != null) {
            throw new LocalizedIncompatibleException(I.TIM_INCOMPATIBLE(newTim.toString(), currentTim.toString()));
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            currentTim.write(baos);
            byte[] abCurrentTim = baos.toByteArray();
            baos.reset();
            newTim.write(baos);
            abNewTim = baos.toByteArray();
            if (abCurrentTim.length != abNewTim.length) {
                throw new RuntimeException(String.format("Matching tim binary length differ?? cur %s=%d new %s=%d", currentTim, abCurrentTim.length, newTim, abNewTim.length));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("BAOS", ex);
        }
        this.writeNewTimData(abNewTim, fbs);
    }

    private void writeNewTimData(@Nonnull byte[] abNewTim, @Nonnull FeedbackStream fbs) throws CdFileSectorReader.CdReadException, DiscPatcher.WritePatchException {
        int iSector;
        int iBytesToWrite = abNewTim.length;
        CdFileSectorReader cd = this.getSourceCd();
        CdSector cdSector = cd.getSector(iSector = this.getStartSector());
        if (this._iStartOffset + iBytesToWrite > cdSector.getCdUserDataSize()) {
            iBytesToWrite = cdSector.getCdUserDataSize() - this._iStartOffset;
        }
        fbs.println(I.CMD_TIM_REPLACE_SECTOR_BYTES(iBytesToWrite, iSector));
        cd.addPatch(iSector, this._iStartOffset, abNewTim, 0, iBytesToWrite);
        for (int iBytesWritten = iBytesToWrite; iBytesWritten < abNewTim.length; iBytesWritten += iBytesToWrite) {
            if (++iSector > this.getEndSector()) {
                throw new RuntimeException("Replacing TIM is somehow writing to too many sectors.");
            }
            iBytesToWrite = abNewTim.length - iBytesWritten;
            cdSector = cd.getSector(iSector);
            if (iBytesToWrite > cdSector.getCdUserDataSize()) {
                iBytesToWrite = cdSector.getCdUserDataSize();
            }
            fbs.println(I.CMD_TIM_REPLACE_SECTOR_BYTES(iBytesToWrite, iSector));
            cd.addPatch(iSector, 0, abNewTim, iBytesWritten, iBytesToWrite);
        }
    }
}

