/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.tim;

import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.indexing.DiscIndexer;
import jpsxdec.modules.CdSectorDemuxPiece;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.UnidentifiedSectorStreamListener;
import jpsxdec.modules.tim.DiscItemTim;
import jpsxdec.tim.Tim;
import jpsxdec.tim.TimInfo;
import jpsxdec.util.DemuxPushInputStream;
import jpsxdec.util.DemuxedData;
import jpsxdec.util.IO;

public class DiscIndexerTim
extends DiscIndexer
implements UnidentifiedSectorStreamListener.Listener {
    private static final Logger LOG = Logger.getLogger(DiscIndexerTim.class.getName());
    @CheckForNull
    private DemuxPushInputStream<CdSectorDemuxPiece> _stream;

    @Override
    @CheckForNull
    public DiscItem deserializeLineRead(@Nonnull SerializedDiscItem serial) throws LocalizedDeserializationFail {
        if ("Tim".equals(serial.getType())) {
            return new DiscItemTim(this.getCd(), serial);
        }
        return null;
    }

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        UnidentifiedSectorStreamListener.attachToSectorClaimer(scs, this);
    }

    @Override
    public void feedSector(@Nonnull CdSector sector) {
        CdSectorDemuxPiece piece = new CdSectorDemuxPiece(sector);
        if (this._stream == null) {
            this._stream = new DemuxPushInputStream<CdSectorDemuxPiece>(piece);
        } else {
            this._stream.addPiece(piece);
        }
        this.findTims();
    }

    @Override
    public void endOfUnidentified() {
        this.exhaustStream();
    }

    private void findTims() {
        if (this._stream == null) {
            return;
        }
        while (this._stream.available() > 22) {
            this._stream.mark(Integer.MAX_VALUE);
            try {
                TimInfo ti = Tim.isTim(this._stream);
                if (ti != null) {
                    this.addTim(ti);
                }
            }
            catch (DemuxPushInputStream.NeedsMoreData ex) {
                this._stream.reset();
                break;
            }
            catch (EOFException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this._stream.reset();
            this._stream.mark(4);
            try {
                IO.skip(this._stream, 4L);
            }
            catch (DemuxPushInputStream.NeedsMoreData ex) {
                this._stream.reset();
                break;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void exhaustStream() {
        if (this._stream == null) {
            return;
        }
        this._stream.close();
        while (this._stream.available() > 2) {
            this._stream.mark(Integer.MAX_VALUE);
            try {
                TimInfo ti = Tim.isTim(this._stream);
                if (ti != null) {
                    this.addTim(ti);
                }
            }
            catch (EOFException ex) {
                LOG.log(Level.INFO, "Stream ended in the middle of possible Tim", ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this._stream.reset();
            try {
                IO.skip(this._stream, 4L);
            }
            catch (EOFException ex) {
                break;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        this._stream = null;
    }

    private void addTim(@Nonnull TimInfo tim) {
        DemuxedData<CdSectorDemuxPiece> demux = this._stream.getMarkToReadDemux();
        this.addDiscItem(new DiscItemTim(this.getCd(), demux.getStartSector(), demux.getEndSector(), demux.getStartDataOffset(), tim.iPaletteCount, tim.iBitsPerPixel, tim.iPixelWidth, tim.iPixelHeight));
    }

    @Override
    public void listPostProcessing(@Nonnull Collection<DiscItem> allItems) {
    }

    @Override
    public boolean filterChild(DiscItem parent, DiscItem child) {
        return false;
    }

    @Override
    public void indexGenerated(@Nonnull DiscIndex index) {
    }
}

