/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.strvideo;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.video.sectorbased.DemuxedFrameWithNumberAndDims;
import jpsxdec.modules.video.sectorbased.ISelfDemuxingVideoSector;

public class StrVideoSectorToDemuxedStrFrame
implements IdentifiedSectorListener<ISelfDemuxingVideoSector> {
    @Nonnull
    private final SectorRange _sectorRange;
    @Nonnull
    private final DemuxedFrameWithNumberAndDims.Listener _listener;
    @CheckForNull
    private ISelfDemuxingVideoSector.IDemuxer _currentFrame;

    public StrVideoSectorToDemuxedStrFrame(@Nonnull SectorRange sectorRange, @Nonnull DemuxedFrameWithNumberAndDims.Listener listener) {
        this._sectorRange = sectorRange;
        this._listener = listener;
    }

    @Override
    @Nonnull
    public Class<ISelfDemuxingVideoSector> getListeningFor() {
        return ISelfDemuxingVideoSector.class;
    }

    @Override
    public void feedSector(@Nonnull ISelfDemuxingVideoSector vidSector, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        if (!this._sectorRange.sectorIsInRange(vidSector.getSectorNumber())) {
            return;
        }
        if (this._currentFrame != null && !this._currentFrame.addSectorIfPartOfFrame(vidSector)) {
            this.endFrame(log);
        }
        if (this._currentFrame == null) {
            this._currentFrame = vidSector.createDemuxer(log);
        }
        if (this._currentFrame.isFrameComplete()) {
            this.endFrame(log);
        }
    }

    private void endFrame(@Nonnull ILocalizedLogger log) throws LoggedFailure {
        DemuxedFrameWithNumberAndDims frame;
        if (this._currentFrame == null) {
            return;
        }
        if (this._listener != null && (frame = this._currentFrame.finishFrame(log)) != null) {
            this._listener.frameComplete(frame, log);
        }
        this._currentFrame = null;
    }

    @Override
    public void endOfFeedSectors(@Nonnull ILocalizedLogger log) throws LoggedFailure {
        this.endFrame(log);
        if (this._listener != null) {
            this._listener.endOfSectors(log);
        }
    }
}

