/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.strvideo;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorXaSubHeader;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.modules.video.sectorbased.SectorAbstractVideo;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.VideoSectorCommon16byteHeader;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;

public class SectorStarbladeAlphaGalaxian3
extends SectorAbstractVideo {
    @Nonnull
    private final VideoSectorCommon16byteHeader _header;
    private int _iWidth;
    private int _iHeight;
    private int _iExactUsedDemux;
    private int _iUsedDemuxDifference;
    private int _iSharedFrameUnknown;
    private int _i1stChunkUnknown;

    @Override
    public int getVideoSectorHeaderSize() {
        if (this._header.iChunkNumber == 0) {
            return 36;
        }
        return 32;
    }

    public SectorStarbladeAlphaGalaxian3(@Nonnull CdSector cdSector) {
        super(cdSector);
        this._header = new VideoSectorCommon16byteHeader(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        CdSectorXaSubHeader sh = cdSector.getSubHeader();
        if (sh != null) {
            if (sh.getSubMode().mask(2) == 0) {
                return;
            }
            if (sh.getSubMode().mask(32) != 0) {
                return;
            }
        }
        if (this._header.lngMagic != 2147549536L) {
            return;
        }
        if (!this._header.hasStandardChunkNumber()) {
            return;
        }
        if (!this._header.hasStandardChunksInFrame()) {
            return;
        }
        if (this._header.iFrameNumber < 1) {
            return;
        }
        if (!this._header.hasStandardUsedDemuxSize()) {
            return;
        }
        this._iWidth = cdSector.readSInt16LE(16);
        if (this._iWidth < 1) {
            return;
        }
        this._iHeight = cdSector.readSInt16LE(18);
        if (this._iHeight < 1) {
            return;
        }
        this._iExactUsedDemux = cdSector.readUInt16LE(20);
        this._iUsedDemuxDifference = cdSector.readSInt16LE(22);
        int iCalculatedDifference = this._header.iUsedDemuxedSize - this._iExactUsedDemux - 4;
        if (iCalculatedDifference != this._iUsedDemuxDifference) {
            return;
        }
        this._iSharedFrameUnknown = cdSector.readSInt16LE(24);
        int iMagic3800 = cdSector.readUInt16LE(26);
        if (iMagic3800 != 14336) {
            return;
        }
        int iZeroes = cdSector.readSInt32LE(28);
        if (iZeroes != 0) {
            return;
        }
        this._i1stChunkUnknown = cdSector.readSInt32LE(32);
        this.setProbability(100);
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "Starblade Alpha/Galaxian 3";
    }

    @Override
    public String toString() {
        String s = String.format("%s %s frame:%d chunk:%d/%d %dx%d demux{used:%d exact:%d diff:%d} ??:%d", this.getTypeName(), super.cdToString(), this._header.iFrameNumber, this._header.iChunkNumber, this._header.iChunksInThisFrame, this._iWidth, this._iHeight, this._header.iUsedDemuxedSize, this._iExactUsedDemux, this._iUsedDemuxDifference, this._iSharedFrameUnknown);
        if (this._header.iChunkNumber == 0) {
            return s + String.format(" 1st??:%08x", this._i1stChunkUnknown);
        }
        return s;
    }

    @Override
    public int getChunkNumber() {
        return this._header.iChunkNumber;
    }

    @Override
    public int getChunksInFrame() {
        return this._header.iChunksInThisFrame;
    }

    @Override
    public int getHeaderFrameNumber() {
        return this._header.iFrameNumber;
    }

    @Override
    public int getHeight() {
        return this._iHeight;
    }

    @Override
    public int getWidth() {
        return this._iWidth;
    }

    @Override
    public void replaceVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull byte[] abCurrentVidSectorHeader) throws LocalizedIncompatibleException {
        throw new UnsupportedOperationException("Replacing Starblade Alpha video is not implemented");
    }
}

