/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.strvideo;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.strvideo.SectorAliceNullVideo;
import jpsxdec.modules.video.sectorbased.IVideoSectorWithFrameNumber;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.VideoSectorWithFrameNumberDemuxer;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.util.IO;

public class SectorAliceVideo
extends SectorAliceNullVideo
implements IVideoSectorWithFrameNumber {
    public SectorAliceVideo(@Nonnull CdSector cdSector) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        if (this._header.iFrameNumber == 65535) {
            return;
        }
        this.setProbability(100);
    }

    @Override
    public int getVideoSectorHeaderSize() {
        return 32;
    }

    @Override
    public int getWidth() {
        return 320;
    }

    @Override
    public int getHeight() {
        return 224;
    }

    @Override
    @Nonnull
    public VideoSectorWithFrameNumberDemuxer createDemuxer(@Nonnull ILocalizedLogger log) {
        return new VideoSectorWithFrameNumberDemuxer(this, log);
    }

    @Override
    public int getDemuxPieceSize() {
        return this.getCdSector().getCdUserDataSize() - this.getVideoSectorHeaderSize();
    }

    @Override
    public byte getDemuxPieceByte(int i) {
        return this.getCdSector().readUserDataByte(this.getVideoSectorHeaderSize() + i);
    }

    @Override
    public void copyDemuxPieceData(@Nonnull byte[] abOut, int iOutPos) {
        this.getCdSector().getCdUserDataCopy(this.getVideoSectorHeaderSize(), abOut, iOutPos, this.getDemuxPieceSize());
    }

    @Override
    public String getTypeName() {
        return "Alice";
    }

    @Override
    public void replaceVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull byte[] abCurrentVidSectorHeader) {
        IO.writeInt32LE(abCurrentVidSectorHeader, 12, newFrame.calculateUsedBytesRoundUp4());
    }
}

