/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.strvideo;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.video.sectorbased.VideoSectorCommon16byteHeader;

public class SectorAliceNullVideo
extends IdentifiedSector {
    public static final long ALICE_VIDEO_SECTOR_MAGIC = 352L;
    public static final int ALICE_VIDEO_SECTOR_HEADER_SIZE = 32;
    @Nonnull
    protected final VideoSectorCommon16byteHeader _header;

    public SectorAliceNullVideo(@Nonnull CdSector cdSector) {
        super(cdSector);
        this._header = new VideoSectorCommon16byteHeader(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        if (cdSector.isCdAudioSector()) {
            return;
        }
        if (this.subModeExistsAndMaskEquals(10, 0)) {
            return;
        }
        if (this._header.lngMagic != 352L) {
            return;
        }
        if (!this._header.hasStandardChunkNumber()) {
            return;
        }
        if (this._header.iChunksInThisFrame < 3) {
            return;
        }
        if (!this._header.hasStandardFrameNumber()) {
            return;
        }
        for (int i = 16; i < 32; ++i) {
            if (cdSector.readUserDataByte(i) == 0) continue;
            return;
        }
        this.setProbability(100);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getTypeName()).append(' ').append(super.toString());
        sb.append(" frame:");
        if (this._header.iFrameNumber == 65535) {
            sb.append("NUL");
        } else {
            sb.append(this.getHeaderFrameNumber());
            if (this.isEndFrame()) {
                sb.append("[End]");
            }
        }
        sb.append(" chunk:").append(this._header.iChunkNumber).append('/').append(this._header.iChunksInThisFrame);
        sb.append(" {demux=").append(this._header.iUsedDemuxedSize).append('}');
        return sb.toString();
    }

    public int getChunkNumber() {
        return this._header.iChunkNumber;
    }

    public int getChunksInFrame() {
        return this._header.iChunksInThisFrame;
    }

    public int getHeaderFrameNumber() {
        return this._header.iFrameNumber & 0x3FFF;
    }

    public boolean isEndFrame() {
        return (this._header.iFrameNumber & 0x8000) != 0;
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "AliceNull";
    }
}

