/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.strvideo;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorXaSubHeader;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.modules.video.sectorbased.SectorAbstractVideo;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_Lain;
import jpsxdec.psxvideo.bitstreams.IBitStreamWith1QuantizationScale;
import jpsxdec.util.IO;

public class GenericStrVideoSector
extends SectorAbstractVideo {
    private static final Logger LOG = Logger.getLogger(GenericStrVideoSector.class.getName());
    public static final long STANDARD_STR_VIDEO_SECTOR_MAGIC = 2147549536L;
    private long _lngMagic;
    private int _iChunkNumber;
    private int _iChunksInThisFrame;
    private int _iFrameNumber;
    private int _iUsedDemuxedSizeRoundUp4;
    private int _iWidth;
    private int _iHeight;
    private int _iUsuallyHalfMdecCodeCountCeil32;
    private int _iUsually3800;
    private int _iUsuallyQuantizationScale;
    private int _iUsuallyBitstreamVersionNumber;
    private long _lngUsually0;
    @CheckForNull
    private VideoSecorHeader[] _aoPossibleSectorTypes;
    @CheckForNull
    private String _sMatchingHeadersToString;
    @CheckForNull
    private String _sSectorType;

    @Override
    public int getVideoSectorHeaderSize() {
        return 32;
    }

    public GenericStrVideoSector(@Nonnull CdSector cdSector) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        CdSectorXaSubHeader sh = cdSector.getSubHeader();
        if (sh != null) {
            if (sh.getSubMode().mask(10) == 0) {
                return;
            }
            if (sh.getSubMode().mask(32) != 0) {
                return;
            }
        }
        this._lngMagic = cdSector.readUInt32LE(0);
        if (this._lngMagic != 2147549536L && this._lngMagic != 2164326752L && this._lngMagic != 16974176L && this._lngMagic != 65888L) {
            return;
        }
        this._iChunkNumber = cdSector.readSInt16LE(4);
        if (this._iChunkNumber < 0 || this._iChunkNumber > 50) {
            return;
        }
        this._iChunksInThisFrame = cdSector.readSInt16LE(6);
        if (this._iChunksInThisFrame < 1 || this._iChunksInThisFrame <= this._iChunkNumber || this._iChunksInThisFrame > 50) {
            return;
        }
        this._iFrameNumber = cdSector.readSInt32LE(8);
        if (this._iFrameNumber < 0 || this._iFrameNumber > 700000) {
            return;
        }
        this._iUsedDemuxedSizeRoundUp4 = cdSector.readSInt32LE(12);
        if (this._iUsedDemuxedSizeRoundUp4 < 0 || this._iUsedDemuxedSizeRoundUp4 > 102400) {
            return;
        }
        this._iWidth = cdSector.readSInt16LE(16);
        if (this._iWidth < 8 || this._iWidth >= 8192) {
            return;
        }
        this._iHeight = cdSector.readSInt16LE(18);
        if (this._iHeight < 8 || this._iHeight >= 8192) {
            return;
        }
        this._iUsuallyHalfMdecCodeCountCeil32 = cdSector.readUInt16LE(20);
        this._iUsually3800 = cdSector.readUInt16LE(22);
        this._iUsuallyQuantizationScale = cdSector.readSInt16LE(24);
        this._iUsuallyBitstreamVersionNumber = cdSector.readUInt16LE(26);
        this._lngUsually0 = cdSector.readUInt32LE(28);
        this.setProbability(100);
    }

    @Override
    public int getChunkNumber() {
        return this._iChunkNumber;
    }

    @Override
    public int getChunksInFrame() {
        return this._iChunksInThisFrame;
    }

    @Override
    public int getHeaderFrameNumber() {
        return this._iFrameNumber;
    }

    @Override
    public int getHeight() {
        return this._iHeight;
    }

    @Override
    public int getWidth() {
        return this._iWidth;
    }

    @Override
    @Nonnull
    public String getTypeName() {
        if (this._sSectorType == null) {
            VideoSecorHeader[] aoPossibleHeaders = this.checkTypes();
            StringBuilder sb = new StringBuilder();
            for (VideoSecorHeader possibleHeader : aoPossibleHeaders) {
                if (possibleHeader == null) break;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(possibleHeader.getType());
            }
            this._sSectorType = sb.length() == 0 ? "?" : sb.toString();
        }
        return "STR " + this._sSectorType;
    }

    @Nonnull
    private VideoSecorHeader[] checkTypes() {
        if (this._aoPossibleSectorTypes == null) {
            this._aoPossibleSectorTypes = new VideoSecorHeader[10];
            int i = 0;
            this._aoPossibleSectorTypes[i] = new ChronoXHeader();
            if (this._aoPossibleSectorTypes[i].isMatch()) {
                ++i;
            }
            if ((this._aoPossibleSectorTypes[i] = new IkiHeader()).isMatch()) {
                ++i;
            }
            if ((this._aoPossibleSectorTypes[i] = new LainHeader()).isMatch()) {
                ++i;
            }
            if ((this._aoPossibleSectorTypes[i] = new CapcomHeader()).isMatch()) {
                ++i;
            }
            if ((this._aoPossibleSectorTypes[i] = new JackieChanHeader()).isMatch()) {
                ++i;
            }
            if ((this._aoPossibleSectorTypes[i] = new RebootHeader()).isMatch()) {
                ++i;
            }
            if ((this._aoPossibleSectorTypes[i] = new RidgeRacer4PalHeader()).isMatch()) {
                ++i;
            }
            if ((this._aoPossibleSectorTypes[i] = new StarWars()).isMatch()) {
                ++i;
            }
            if ((this._aoPossibleSectorTypes[i] = new StrHeader()).isMatch()) {
                ++i;
            }
            if (!(this._aoPossibleSectorTypes[i] = new StrV1Header()).isMatch()) {
                if (i == 0) {
                    this._aoPossibleSectorTypes[0] = new UnknownHeader();
                } else {
                    this._aoPossibleSectorTypes[i] = null;
                }
            }
        }
        return this._aoPossibleSectorTypes;
    }

    @Override
    public String toString() {
        if (this._sMatchingHeadersToString == null) {
            VideoSecorHeader[] aoPossibleHeaders = this.checkTypes();
            StringBuilder sb = new StringBuilder();
            for (VideoSecorHeader possibleHeader : aoPossibleHeaders) {
                if (possibleHeader == null) break;
                sb.append(' ').append(possibleHeader.toString());
            }
            this._sMatchingHeadersToString = sb.toString();
        }
        return String.format("%s %s frame:%d chunk:%d/%d %dx%d demux size:%d%s", this.getTypeName(), super.cdToString(), this._iFrameNumber, this._iChunkNumber, this._iChunksInThisFrame, this._iWidth, this._iHeight, this._iUsedDemuxedSizeRoundUp4, this._sMatchingHeadersToString);
    }

    @Override
    public void replaceVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull byte[] abCurrentVidSectorHeader) throws LocalizedIncompatibleException {
        if (existingFrame.isBitStreamClass(BitStreamUncompressor_Lain.class)) {
            this.replaceLainVideoSectorHeader(existingFrame, newFrame, abCurrentVidSectorHeader);
        } else {
            this.replaceStrVideoSectorHeader(existingFrame, newFrame, abCurrentVidSectorHeader);
        }
    }

    private void replaceStrVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull byte[] abCurrentVidSectorHeader) {
        BitStreamUncompressor existingBs;
        int iExistingDemuxedSizeRoundUp4 = IO.readSInt32LE(abCurrentVidSectorHeader, 12);
        if (iExistingDemuxedSizeRoundUp4 != existingFrame.calculateUsedBytesRoundUp4()) {
            LOG.log(Level.WARNING, "Existing sector demux size 4 {0,number,#} != frame demux size 4 {1,number,#}", new Object[]{iExistingDemuxedSizeRoundUp4, existingFrame.calculateUsedBytesRoundUp4()});
        }
        IO.writeInt32LE(abCurrentVidSectorHeader, 12, newFrame.calculateUsedBytesRoundUp4());
        short iExistingSectorHeaderMdec = IO.readSInt16LE(abCurrentVidSectorHeader, 20);
        if (iExistingSectorHeaderMdec == existingFrame.calculateMdecHalfCeiling32()) {
            IO.writeInt16LE(abCurrentVidSectorHeader, 20, newFrame.calculateMdecHalfCeiling32());
        }
        if ((existingBs = existingFrame.getCompletedBitStream()) instanceof IBitStreamWith1QuantizationScale) {
            int iExistingBsQscale = ((IBitStreamWith1QuantizationScale)((Object)existingBs)).getQuantizationScale();
            short iExistingSectorHeaderQscale = IO.readSInt16LE(abCurrentVidSectorHeader, 24);
            if (iExistingSectorHeaderQscale == iExistingBsQscale) {
                BitStreamUncompressor newBs = newFrame.getCompletedBitStream();
                int iNewBsQscale = ((IBitStreamWith1QuantizationScale)((Object)newBs)).getQuantizationScale();
                IO.writeInt16LE(abCurrentVidSectorHeader, 24, (short)iNewBsQscale);
            }
        }
    }

    private void replaceLainVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull byte[] abCurrentVidSectorHeader) throws LocalizedIncompatibleException {
        int iExistingSectorHeaderMdecCodeCount;
        BitStreamUncompressor_Lain existingLainBs = (BitStreamUncompressor_Lain)existingFrame.getCompletedBitStream();
        BitStreamUncompressor_Lain newLainBs = (BitStreamUncompressor_Lain)newFrame.getCompletedBitStream();
        byte iExistingSectorHeaderLumaQscale = abCurrentVidSectorHeader[20];
        byte iExistingSectorHeaderChromaQscale = abCurrentVidSectorHeader[21];
        if (iExistingSectorHeaderLumaQscale != 0 || iExistingSectorHeaderChromaQscale != 0) {
            int iExistingBsLumaQscale = existingLainBs.getLumaQscale();
            int iExistingBsChromaQscale = existingLainBs.getChromaQscale();
            if (iExistingSectorHeaderLumaQscale != iExistingBsLumaQscale || iExistingSectorHeaderChromaQscale != iExistingBsChromaQscale) {
                throw new RuntimeException("Existing sector somehow does not appear to be Lain");
            }
            abCurrentVidSectorHeader[20] = (byte)newLainBs.getLumaQscale();
            abCurrentVidSectorHeader[21] = (byte)newLainBs.getChromaQscale();
        }
        if ((iExistingSectorHeaderMdecCodeCount = this.getCdSector().readUInt16LE(24)) != 0) {
            IO.writeInt16LE(abCurrentVidSectorHeader, 24, (short)newFrame.getMdecCodeCount());
        }
    }

    private class UnknownHeader
    extends VideoSecorHeader {
        public UnknownHeader() {
            super("?");
            this.__blnIsMatch = true;
        }

        @Override
        public String getFieldsDescription() {
            return String.format("magic:%08x MDEC/2?:%d 3800?:%04x qscale?:%d ver?:%d 0?:%d", GenericStrVideoSector.this._lngMagic, GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32, GenericStrVideoSector.this._iUsually3800, GenericStrVideoSector.this._iUsuallyQuantizationScale, GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber, GenericStrVideoSector.this._lngUsually0);
        }
    }

    private class RidgeRacer4PalHeader
    extends VideoSecorHeader {
        public static final long RIDGE_RACER_TYPE_4_PAL_MAGIC = 65888L;

        public RidgeRacer4PalHeader() {
            super("RR4 PAL");
            this.__blnIsMatch = GenericStrVideoSector.this._lngMagic == 65888L && GenericStrVideoSector.this._iFrameNumber >= 1 && GenericStrVideoSector.this._iWidth == 320 && GenericStrVideoSector.this._iHeight == 176 && GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32 == 0 && GenericStrVideoSector.this._iUsually3800 == 0 && GenericStrVideoSector.this._iUsuallyQuantizationScale == 0 && GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber == 0 && GenericStrVideoSector.this._lngUsually0 == 0L;
        }

        @Override
        public String getFieldsDescription() {
            return String.format("0:%d 0:%d 0:%d 0:%d 0:%d", GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32, GenericStrVideoSector.this._iUsually3800, GenericStrVideoSector.this._iUsuallyQuantizationScale, GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber, GenericStrVideoSector.this._lngUsually0);
        }
    }

    private class RebootHeader
    extends VideoSecorHeader {
        public RebootHeader() {
            super("Reboot");
            this.__blnIsMatch = GenericStrVideoSector.this._lngMagic == 2147549536L && GenericStrVideoSector.this._iFrameNumber >= 0 && GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32 == 0 && GenericStrVideoSector.this._iUsually3800 >= 56 && GenericStrVideoSector.this._iUsually3800 <= 2000 && GenericStrVideoSector.this._iUsuallyQuantizationScale == 0 && GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber == 0 && GenericStrVideoSector.this._lngUsually0 == 0L;
        }

        @Override
        public String getFieldsDescription() {
            return String.format("0:%d >frame count:%d 0:%d 0:%d 0:%d", GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32, GenericStrVideoSector.this._iUsually3800, GenericStrVideoSector.this._iUsuallyQuantizationScale, GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber, GenericStrVideoSector.this._lngUsually0);
        }
    }

    private class StarWars
    extends VideoSecorHeader {
        public StarWars() {
            super("Star Wars");
            this.__blnIsMatch = GenericStrVideoSector.this._lngMagic == 2147549536L && GenericStrVideoSector.this._iFrameNumber >= 1 && (GenericStrVideoSector.this._iWidth == 496 && GenericStrVideoSector.this._iHeight == 256 || GenericStrVideoSector.this._iWidth == 432 && GenericStrVideoSector.this._iHeight == 260 || GenericStrVideoSector.this._iWidth == 416 && GenericStrVideoSector.this._iHeight == 256 || GenericStrVideoSector.this._iWidth == 320 && GenericStrVideoSector.this._iHeight == 240) && GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32 > 0 && GenericStrVideoSector.this._iUsually3800 == 14336 && GenericStrVideoSector.this._iUsuallyQuantizationScale > 0 && GenericStrVideoSector.this._iUsuallyQuantizationScale < 64 && GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber > 3 && GenericStrVideoSector.this._lngUsually0 == 0L;
        }

        @Override
        public String getFieldsDescription() {
            return String.format("MDEC/2:%d 3800:%04x qscale:%d ?:%04x 0:%d", GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32, GenericStrVideoSector.this._iUsually3800, GenericStrVideoSector.this._iUsuallyQuantizationScale, GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber, GenericStrVideoSector.this._lngUsually0);
        }
    }

    private class CapcomHeader
    extends VideoSecorHeader {
        public CapcomHeader() {
            super("Capcom");
            boolean bl = this.__blnIsMatch = GenericStrVideoSector.this._lngMagic == 2147549536L && GenericStrVideoSector.this._iFrameNumber >= 1 && GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32 > 0 && GenericStrVideoSector.this._iUsually3800 == 14336 && GenericStrVideoSector.this._iUsuallyQuantizationScale > 0 && GenericStrVideoSector.this._iUsuallyQuantizationScale < 64 && (GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber == 2 || GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber == 3);
            if (this.__blnIsMatch) {
                int iMinFrameChunkSize = GenericStrVideoSector.this._iChunksInThisFrame < 4 ? 1 : GenericStrVideoSector.this._iChunksInThisFrame - 4;
                int iMinimumFrameStartSector = (GenericStrVideoSector.this._iFrameNumber - 1) * iMinFrameChunkSize;
                this.__blnIsMatch = GenericStrVideoSector.this._lngUsually0 > (long)iMinimumFrameStartSector;
            }
        }

        @Override
        public String getFieldsDescription() {
            return String.format("MDEC/2:%d 3800:%04x qscale:%d ver:%d frame start sector:%d", GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32, GenericStrVideoSector.this._iUsually3800, GenericStrVideoSector.this._iUsuallyQuantizationScale, GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber, GenericStrVideoSector.this._lngUsually0);
        }
    }

    private class JackieChanHeader
    extends VideoSecorHeader {
        public JackieChanHeader() {
            super("Jackie Chan");
            this.__blnIsMatch = GenericStrVideoSector.this._lngMagic == 2147549536L && GenericStrVideoSector.this._iWidth == 320 && GenericStrVideoSector.this._iHeight == 240 && GenericStrVideoSector.this._iFrameNumber >= 1 && GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32 > 0 && GenericStrVideoSector.this._iUsually3800 == 0 && GenericStrVideoSector.this._iUsuallyQuantizationScale > 0 && GenericStrVideoSector.this._iUsuallyQuantizationScale < 64 && GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber == 2 && GenericStrVideoSector.this._lngUsually0 == 0L;
        }

        @Override
        public String getFieldsDescription() {
            return String.format("MDEC/2:%d 0:%d qscale:%d ver:%d 0:%d", GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32, GenericStrVideoSector.this._iUsually3800, GenericStrVideoSector.this._iUsuallyQuantizationScale, GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber, GenericStrVideoSector.this._lngUsually0);
        }
    }

    private class StrV1Header
    extends VideoSecorHeader {
        public StrV1Header() {
            super("StrV1");
            this.__blnIsMatch = GenericStrVideoSector.this._lngMagic == 2147549536L && GenericStrVideoSector.this._iFrameNumber >= 1 && GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32 > 0 && GenericStrVideoSector.this._iUsually3800 == 14336 && GenericStrVideoSector.this._iUsuallyQuantizationScale > 0 && GenericStrVideoSector.this._iUsuallyQuantizationScale < 64 && GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber == 1 && GenericStrVideoSector.this._lngUsually0 == 0L;
        }

        @Override
        public String getFieldsDescription() {
            return String.format("MDEC/2:%d 3800:%04x qscale:%d ver:%d 0:%d", GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32, GenericStrVideoSector.this._iUsually3800, GenericStrVideoSector.this._iUsuallyQuantizationScale, GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber, GenericStrVideoSector.this._lngUsually0);
        }
    }

    private class StrHeader
    extends VideoSecorHeader {
        public StrHeader() {
            super("Str");
            this.__blnIsMatch = GenericStrVideoSector.this._lngMagic == 2147549536L && GenericStrVideoSector.this._iFrameNumber >= 1 && GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32 > 0 && GenericStrVideoSector.this._iUsually3800 == 14336 && GenericStrVideoSector.this._iUsuallyQuantizationScale > 0 && GenericStrVideoSector.this._iUsuallyQuantizationScale < 64 && (GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber == 2 || GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber == 3) && GenericStrVideoSector.this._lngUsually0 == 0L;
        }

        @Override
        public String getFieldsDescription() {
            return String.format("MDEC/2:%d 3800:%04x qscale:%d ver:%d 0:%d", GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32, GenericStrVideoSector.this._iUsually3800, GenericStrVideoSector.this._iUsuallyQuantizationScale, GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber, GenericStrVideoSector.this._lngUsually0);
        }
    }

    private class LainHeader
    extends VideoSecorHeader {
        public LainHeader() {
            super("Lain");
            this.__blnIsMatch = GenericStrVideoSector.this._lngMagic == 2147549536L && GenericStrVideoSector.this._iWidth == 320 && GenericStrVideoSector.this._iHeight == 240 && GenericStrVideoSector.this._iFrameNumber >= 1 && this.getLumaQscale() >= 0 && this.getLumaQscale() < 64 && this.getChromaQscale() >= 0 && this.getChromaQscale() < 64 && (GenericStrVideoSector.this._iUsually3800 == 14336 || GenericStrVideoSector.this._iUsually3800 == 0 || GenericStrVideoSector.this._iUsually3800 == GenericStrVideoSector.this._iFrameNumber) && GenericStrVideoSector.this._iUsuallyQuantizationScale >= 0 && GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber == 0 && GenericStrVideoSector.this._lngUsually0 == 0L;
        }

        private int getLumaQscale() {
            return GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32 & 0xFF;
        }

        private int getChromaQscale() {
            return GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32 >> 8 & 0xFF;
        }

        @Override
        public String getFieldsDescription() {
            String s3800 = GenericStrVideoSector.this._iUsually3800 == GenericStrVideoSector.this._iFrameNumber ? String.valueOf(GenericStrVideoSector.this._iUsually3800) : (GenericStrVideoSector.this._iUsually3800 == 0 ? "0" : String.format("%04x", GenericStrVideoSector.this._iUsually3800));
            return String.format("qscaleL:%d qscaleC:%d 3800|0|frame:%s mdec count:%d 0:%d 0:%d", this.getLumaQscale(), this.getChromaQscale(), s3800, GenericStrVideoSector.this._iUsuallyQuantizationScale, GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber, GenericStrVideoSector.this._lngUsually0);
        }
    }

    public class ChronoXHeader
    extends VideoSecorHeader {
        public static final long CHRONO_CROSS_VIDEO_CHUNK_MAGIC1 = 2164326752L;
        public static final long CHRONO_CROSS_VIDEO_CHUNK_MAGIC2 = 16974176L;

        public ChronoXHeader() {
            super("Crono Cross");
            this.__blnIsMatch = !(GenericStrVideoSector.this._lngMagic != 2164326752L && GenericStrVideoSector.this._lngMagic != 16974176L || GenericStrVideoSector.this._iFrameNumber < 1 || GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32 <= 0 || GenericStrVideoSector.this._iUsually3800 != 14336 && GenericStrVideoSector.this._iUsually3800 != 0 || GenericStrVideoSector.this._iUsuallyQuantizationScale <= 0 || GenericStrVideoSector.this._iUsuallyQuantizationScale >= 64 || GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber != 2 || GenericStrVideoSector.this._lngUsually0 != 0L);
        }

        @Override
        public String getFieldsDescription() {
            return String.format("MDEC/2:%d 3800:%04x qscale:%d ver:%d 0:%d", GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32, GenericStrVideoSector.this._iUsually3800, GenericStrVideoSector.this._iUsuallyQuantizationScale, GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber, GenericStrVideoSector.this._lngUsually0);
        }
    }

    private class IkiHeader
    extends VideoSecorHeader {
        public IkiHeader() {
            super("Iki");
            this.__blnIsMatch = GenericStrVideoSector.this._lngMagic == 2147549536L && GenericStrVideoSector.this._iUsually3800 == 14336 && GenericStrVideoSector.this._iUsuallyQuantizationScale == GenericStrVideoSector.this._iWidth && GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber == GenericStrVideoSector.this._iHeight && GenericStrVideoSector.this._lngUsually0 == 0L;
        }

        @Override
        public String getFieldsDescription() {
            return String.format("MDEC/2:%d 3800:%04x dims again:%dx%d 0:%d", GenericStrVideoSector.this._iUsuallyHalfMdecCodeCountCeil32, GenericStrVideoSector.this._iUsually3800, GenericStrVideoSector.this._iUsuallyQuantizationScale, GenericStrVideoSector.this._iUsuallyBitstreamVersionNumber, GenericStrVideoSector.this._lngUsually0);
        }
    }

    private abstract class VideoSecorHeader {
        protected boolean __blnIsMatch = false;
        @Nonnull
        private final String __sType;

        public VideoSecorHeader(String type) {
            this.__sType = type;
        }

        public final boolean isMatch() {
            return this.__blnIsMatch;
        }

        @Nonnull
        public final String getType() {
            return this.__sType;
        }

        @Nonnull
        public abstract String getFieldsDescription();

        @Nonnull
        public final String toString() {
            return this.__sType + "{" + this.getFieldsDescription() + "}";
        }
    }
}

