/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.strvideo;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.DebugLogger;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.sharedaudio.DiscItemAudioStream;
import jpsxdec.modules.strvideo.StrVideoSectorToDemuxedStrFrame;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.ISectorClaimToDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.framenumber.HeaderFrameNumber;
import jpsxdec.modules.video.framenumber.IFrameNumberFormatterWithHeader;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.modules.video.sectorbased.DemuxedFrameWithNumberAndDims;
import jpsxdec.modules.video.sectorbased.DiscItemSectorBasedVideoStream;
import jpsxdec.modules.video.sectorbased.IVideoSectorWithFrameNumber;
import jpsxdec.modules.video.sectorbased.SectorBasedVideoInfo;
import jpsxdec.modules.xa.DiscItemXaAudioStream;

public class DiscItemStrVideoStream
extends DiscItemSectorBasedVideoStream {
    public static final String TYPE_ID = "Video";
    @Nonnull
    private final HeaderFrameNumber.Format _headerFrameNumberFormat;
    private static final String INDEPENDENT_BITSTREAM = "Independent bitstream";
    private final boolean _blnHasIndependentBitstream;
    private static final int AUDIO_SPLIT_THRESHOLD = 32;

    public DiscItemStrVideoStream(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, @Nonnull Dimensions dim, @Nonnull IndexSectorFrameNumber.Format indexSectorFrameNumberFormat, @Nonnull SectorBasedVideoInfo strVidInfo, @Nonnull HeaderFrameNumber.Format headerFrameNumberFormat, boolean blnHasIndependentBitstream) {
        super(cd, iStartSector, iEndSector, dim, indexSectorFrameNumberFormat, strVidInfo);
        this._headerFrameNumberFormat = headerFrameNumberFormat;
        this._blnHasIndependentBitstream = blnHasIndependentBitstream;
    }

    public DiscItemStrVideoStream(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._headerFrameNumberFormat = new HeaderFrameNumber.Format(fields);
        this._blnHasIndependentBitstream = fields.hasField(INDEPENDENT_BITSTREAM) ? fields.getYesNo(INDEPENDENT_BITSTREAM) : true;
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem serial = super.serialize();
        this._headerFrameNumberFormat.serialize(serial);
        if (!this._blnHasIndependentBitstream) {
            serial.addYesNo(INDEPENDENT_BITSTREAM, this._blnHasIndependentBitstream);
        }
        return serial;
    }

    @Override
    @Nonnull
    public String getSerializationTypeId() {
        return TYPE_ID;
    }

    @Override
    public boolean hasIndependentBitstream() {
        return this._blnHasIndependentBitstream;
    }

    @Override
    public int getParentRating(@Nonnull DiscItem child) {
        if (!(child instanceof DiscItemAudioStream)) {
            return 0;
        }
        int iOverlapPercent = child.getOverlap(this) * 100 / child.getSectorLength();
        if (iOverlapPercent > 0) {
            iOverlapPercent += 100;
        }
        return iOverlapPercent;
    }

    @Override
    public int findAudioSplitPoint(@Nonnull DiscItemXaAudioStream audio) {
        int iStartSector = this.getStartSector();
        if (audio.getStartSector() < iStartSector - 32 && audio.getEndSector() >= iStartSector + 32) {
            return iStartSector;
        }
        return -1;
    }

    @Override
    @Nonnull
    public FrameNumber getStartFrame() {
        return this._headerFrameNumberFormat.getStartFrame(this._indexSectorFrameNumberFormat);
    }

    @Override
    public FrameNumber getEndFrame() {
        return this._headerFrameNumberFormat.getEndFrame(this._indexSectorFrameNumberFormat);
    }

    @Override
    @Nonnull
    public List<FrameNumber.Type> getFrameNumberTypes() {
        return Arrays.asList(FrameNumber.Type.Index, FrameNumber.Type.Header, FrameNumber.Type.Sector);
    }

    @Override
    public void fpsDump(@Nonnull PrintStream ps) throws CdFileSectorReader.CdReadException {
        SectorClaimSystem it = this.createClaimSystem();
        int iSector = 0;
        while (it.hasNext()) {
            IIdentifiedSector isect = it.next(DebugLogger.Log);
            if (isect instanceof IVideoSectorWithFrameNumber) {
                IVideoSectorWithFrameNumber vidSect = (IVideoSectorWithFrameNumber)isect;
                ps.println(String.format("%-5d %-4d %d/%d", iSector, vidSect.getHeaderFrameNumber(), vidSect.getChunkNumber(), vidSect.getChunksInFrame()));
            } else {
                ps.println(String.format("%-5d X", iSector));
            }
            ++iSector;
        }
    }

    @Override
    @Nonnull
    public ISectorClaimToDemuxedFrame makeDemuxer() {
        return new Demuxer(this.makeSectorRange(), this._headerFrameNumberFormat.makeFormatter(this._indexSectorFrameNumberFormat));
    }

    public static class Demuxer
    implements ISectorClaimToDemuxedFrame,
    DemuxedFrameWithNumberAndDims.Listener {
        @Nonnull
        private final SectorRange _sectorRange;
        @Nonnull
        private final IFrameNumberFormatterWithHeader _frameNumberFormatter;
        @CheckForNull
        private IDemuxedFrame.Listener _listener;

        public Demuxer(@Nonnull SectorRange sectorRange, @Nonnull IFrameNumberFormatterWithHeader frameNumberFormatter) {
            this._sectorRange = sectorRange;
            this._frameNumberFormatter = frameNumberFormatter;
        }

        @Override
        public void setFrameListener(@Nonnull IDemuxedFrame.Listener listener) {
            this._listener = listener;
        }

        @Override
        public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
            StrVideoSectorToDemuxedStrFrame s2f = new StrVideoSectorToDemuxedStrFrame(this._sectorRange, this);
            scs.addIdListener(s2f);
        }

        @Override
        public void frameComplete(@Nonnull DemuxedFrameWithNumberAndDims frame, @Nonnull ILocalizedLogger log) throws LoggedFailure {
            FrameNumber fn = this._frameNumberFormatter.next(frame.getStartSector(), frame.getHeaderFrameNumber(), log);
            frame.setFrame(fn);
            if (this._listener != null) {
                this._listener.frameComplete(frame);
            }
        }

        @Override
        public void endOfSectors(@Nonnull ILocalizedLogger log) {
        }
    }
}

