/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.strvideo;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.strvideo.DiscItemStrVideoStream;
import jpsxdec.modules.strvideo.StrVideoSectorToDemuxedStrFrame;
import jpsxdec.modules.video.framenumber.HeaderFrameNumber;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.modules.video.sectorbased.DemuxedFrameWithNumberAndDims;
import jpsxdec.modules.video.sectorbased.DiscIndexerSectorBasedVideo;
import jpsxdec.modules.video.sectorbased.DiscItemSectorBasedVideoStream;
import jpsxdec.modules.video.sectorbased.SectorBasedVideoInfoBuilder;

public class DiscIndexerStrVideo
extends DiscIndexerSectorBasedVideo.SubIndexer
implements DemuxedFrameWithNumberAndDims.Listener {
    private final StrVideoSectorToDemuxedStrFrame _videoDemuxer = new StrVideoSectorToDemuxedStrFrame(SectorRange.ALL, this);
    @CheckForNull
    private VidBuilder _videoBuilder;

    @Override
    @CheckForNull
    public DiscItem deserializeLineRead(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        if ("Video".equals(fields.getType())) {
            return new DiscItemStrVideoStream(this.getCd(), fields);
        }
        return null;
    }

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        scs.addIdListener(this._videoDemuxer);
    }

    @Override
    public void frameComplete(@Nonnull DemuxedFrameWithNumberAndDims frame, @Nonnull ILocalizedLogger log) {
        if (this._videoBuilder != null && !this._videoBuilder.addFrame(frame)) {
            this.endOfVideo(log);
        }
        if (this._videoBuilder == null) {
            this._videoBuilder = new VidBuilder(frame);
        }
    }

    private void endOfVideo(@Nonnull ILocalizedLogger log) {
        if (this._videoBuilder == null) {
            return;
        }
        DiscItemSectorBasedVideoStream video = this._videoBuilder.endOfMovie(this.getCd());
        this.addVideo(video);
        this._videoBuilder = null;
    }

    @Override
    public void endOfSectors(@Nonnull ILocalizedLogger log) {
        this.endOfVideo(log);
    }

    private static class VidBuilder {
        @Nonnull
        private final IndexSectorFrameNumber.Format.Builder _indexSectorFrameNumberBuilder;
        @Nonnull
        private final HeaderFrameNumber.Format.Builder _headerFrameNumberBuilder;
        @Nonnull
        private final SectorBasedVideoInfoBuilder _vidInfoBuilder;
        private int _iLastFrameNumber;
        private final boolean _blnHasSpecialBs;

        public VidBuilder(@Nonnull DemuxedFrameWithNumberAndDims firstFrame) {
            this._iLastFrameNumber = firstFrame.getHeaderFrameNumber();
            this._vidInfoBuilder = new SectorBasedVideoInfoBuilder(firstFrame.getWidth(), firstFrame.getHeight(), firstFrame.getStartSector(), firstFrame.getEndSector());
            this._indexSectorFrameNumberBuilder = new IndexSectorFrameNumber.Format.Builder(firstFrame.getStartSector());
            this._headerFrameNumberBuilder = new HeaderFrameNumber.Format.Builder(firstFrame.getHeaderFrameNumber());
            this._blnHasSpecialBs = firstFrame.getCustomFrameMdecStream() != null;
        }

        public boolean addFrame(@Nonnull DemuxedFrameWithNumberAndDims frame) {
            if (frame.getWidth() != this._vidInfoBuilder.getWidth() || frame.getHeight() != this._vidInfoBuilder.getHeight() || frame.getStartSector() > this._vidInfoBuilder.getEndSector() + 100 || frame.getHeaderFrameNumber() < this._iLastFrameNumber || frame.getHeaderFrameNumber() > this._iLastFrameNumber + 1000) {
                return false;
            }
            if (this._blnHasSpecialBs && frame.getCustomFrameMdecStream() == null) {
                return false;
            }
            this._iLastFrameNumber = frame.getHeaderFrameNumber();
            this._vidInfoBuilder.next(frame.getStartSector(), frame.getEndSector());
            this._indexSectorFrameNumberBuilder.addFrameStartSector(frame.getStartSector());
            this._headerFrameNumberBuilder.addHeaderFrameNumber(frame.getHeaderFrameNumber());
            return true;
        }

        @Nonnull
        public DiscItemSectorBasedVideoStream endOfMovie(@Nonnull CdFileSectorReader cd) {
            return new DiscItemStrVideoStream(cd, this._vidInfoBuilder.getStartSector(), this._vidInfoBuilder.getEndSector(), this._vidInfoBuilder.makeDims(), this._indexSectorFrameNumberBuilder.makeFormat(), this._vidInfoBuilder.makeStrVidInfo(), this._headerFrameNumberBuilder.makeFormat(), !this._blnHasSpecialBs);
        }
    }
}

