/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.starwars;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.util.IO;

public class StarWarsFrameTypeLookup {
    private static final Logger LOG = Logger.getLogger(StarWarsFrameTypeLookup.class.getName());
    static final String LOOKUP_TABLE_FILE = "swra2bsheaderid.dat";
    @Nonnull
    static final int[] LOOKUP_TABLE;

    @Nonnull
    static int[] readTable(@Nonnull InputStream is) throws IOException {
        int iEntryCount = IO.readSInt32LE(is);
        int[] aiLookupTable = new int[iEntryCount];
        for (int i = 0; i < iEntryCount; ++i) {
            aiLookupTable[i] = IO.readSInt32LE(is);
        }
        if (is.read() != -1) {
            throw new RuntimeException("Unexpected extra data");
        }
        return aiLookupTable;
    }

    static int extractLookupValue(@Nonnull byte[] abBitstream) {
        int iRandomVersion = IO.readUInt16LE(abBitstream, 6);
        int iBytes10_11_lastBit0 = IO.readUInt16LE(abBitstream, 10) & 0xFFFFFFFE;
        return iRandomVersion << 16 | iBytes10_11_lastBit0;
    }

    static int getFrameType(@Nonnull byte[] abBitstream) {
        return StarWarsFrameTypeLookup.getFrameType(LOOKUP_TABLE, abBitstream);
    }

    private static int getFrameType(@Nonnull int[] aiLookupTable, @Nonnull byte[] abBitstream) {
        int i32bit_lastBit0 = StarWarsFrameTypeLookup.extractLookupValue(abBitstream);
        return StarWarsFrameTypeLookup.getFrameType(aiLookupTable, i32bit_lastBit0);
    }

    static int getFrameType(@Nonnull int[] aiLookupTable, int i32bit_lastBit0) {
        assert ((i32bit_lastBit0 & 1) == 0);
        int i32bit_lastBit1 = i32bit_lastBit0 | 1;
        assert (i32bit_lastBit0 < i32bit_lastBit1);
        int iMin = 0;
        int iMax = aiLookupTable.length;
        while (iMax >= iMin) {
            int iMid = iMin + iMax >>> 1;
            int iMidValue = aiLookupTable[iMid];
            if (iMidValue < i32bit_lastBit0) {
                iMin = iMid + 1;
                continue;
            }
            if (iMidValue > i32bit_lastBit1) {
                iMax = iMid - 1;
                continue;
            }
            assert (iMidValue == i32bit_lastBit0 || iMidValue == i32bit_lastBit1);
            return (iMidValue & 1) == 0 ? 3 : 2;
        }
        return -1;
    }

    static {
        InputStream is = null;
        try {
            is = StarWarsFrameTypeLookup.class.getResourceAsStream(LOOKUP_TABLE_FILE);
            if (is == null) {
                LOG.severe("Star Wars: Rebel Assault II: The Hidden Empire frame type lookup table missing");
                LOOKUP_TABLE = new int[0];
            } else {
                LOOKUP_TABLE = StarWarsFrameTypeLookup.readTable(is);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IO.closeSilently(is, LOG);
        }
    }
}

