/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.starwars;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.modules.starwars.StarWarsFrameTypeLookup;
import jpsxdec.psxvideo.bitstreams.ArrayBitReader;
import jpsxdec.psxvideo.bitstreams.BitStreamCompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv2;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv3;
import jpsxdec.psxvideo.bitstreams.IBitStreamWith1QuantizationScale;
import jpsxdec.psxvideo.bitstreams.IByteOrder;
import jpsxdec.psxvideo.bitstreams.ZeroRunLengthAcLookup_STR;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;

public class BitStreamUncompressor_StarWars
extends BitStreamUncompressor
implements IBitStreamWith1QuantizationScale {
    private static final IByteOrder LITTLE_ENDIAN_FIRST4_SWAP = new IByteOrder(){

        @Override
        public int getByteOffset(int iByteIndex) {
            if (iByteIndex < 2) {
                iByteIndex += 2;
            } else if (iByteIndex < 4) {
                iByteIndex -= 2;
            }
            return iByteIndex ^ 1;
        }
    };
    @Nonnull
    private final StarWarsHeader _header;

    @CheckForNull
    public static StarWarsHeader makeStarWarsHeader(@Nonnull byte[] abFrameData, int iDataSize) {
        if (iDataSize < 12) {
            return null;
        }
        short iHalfMdecCodeCountCeil32 = IO.readSInt16LE(abFrameData, 0);
        int iMagic3800 = IO.readUInt16LE(abFrameData, 2);
        short iQscale = IO.readSInt16LE(abFrameData, 4);
        int iRandomVersion = IO.readUInt16LE(abFrameData, 6);
        if (iMagic3800 != 14336 || iQscale < 1 || iHalfMdecCodeCountCeil32 < 0) {
            return null;
        }
        int iFrameType = StarWarsFrameTypeLookup.getFrameType(abFrameData);
        if (iFrameType != 2 && iFrameType != 3) {
            return null;
        }
        return new StarWarsHeader(iHalfMdecCodeCountCeil32, iQscale, iRandomVersion, iFrameType == 2);
    }

    @Nonnull
    public static BitStreamUncompressor_StarWars makeStarWars(@Nonnull byte[] abBitstream) throws BinaryDataNotRecognized {
        return BitStreamUncompressor_StarWars.makeStarWars(abBitstream, abBitstream.length);
    }

    @Nonnull
    public static BitStreamUncompressor_StarWars makeStarWars(@Nonnull byte[] abBitstream, int iDataSize) throws BinaryDataNotRecognized {
        BitStreamUncompressor_StarWars bsu = BitStreamUncompressor_StarWars.makeStarWarsNoThrow(abBitstream, iDataSize);
        if (bsu == null) {
            throw new BinaryDataNotRecognized();
        }
        return bsu;
    }

    @CheckForNull
    public static BitStreamUncompressor_StarWars makeStarWarsNoThrow(@Nonnull byte[] abBitstream, int iDataSize) throws BinaryDataNotRecognized {
        StarWarsHeader header = BitStreamUncompressor_StarWars.makeStarWarsHeader(abBitstream, iDataSize);
        if (header == null) {
            return null;
        }
        return BitStreamUncompressor_StarWars.makeStarWars(abBitstream, iDataSize, header);
    }

    @Nonnull
    static BitStreamUncompressor_StarWars makeStarWars(@Nonnull byte[] abBitstream, int iDataSize, @Nonnull StarWarsHeader header) {
        BitStreamUncompressor.IFrameEndPaddingBits endingBits;
        BitStreamUncompressor.IQuantizationDcReader qscaleDcReader;
        if (header.isVersion2Not3()) {
            qscaleDcReader = new BitStreamUncompressor_STRv2.QuantizationDcReader_STRv12(header.getQuantizationScale());
            endingBits = BitStreamUncompressor_STRv2.FRAME_END_PADDING_BITS_STRV2;
        } else {
            qscaleDcReader = new BitStreamUncompressor_STRv3.QuantizationDcReader_STRv3(header.getQuantizationScale());
            endingBits = BitStreamUncompressor_STRv3.FRAME_END_PADDING_BITS_STRV3;
        }
        ArrayBitReader bitReader = new ArrayBitReader(abBitstream, LITTLE_ENDIAN_FIRST4_SWAP, 8, iDataSize);
        return new BitStreamUncompressor_StarWars(header, bitReader, qscaleDcReader, endingBits);
    }

    private BitStreamUncompressor_StarWars(@Nonnull StarWarsHeader header, @Nonnull ArrayBitReader bitReader, @Nonnull BitStreamUncompressor.IQuantizationDcReader qDcReader, @Nonnull BitStreamUncompressor.IFrameEndPaddingBits padding) {
        super(bitReader, ZeroRunLengthAcLookup_STR.AC_VARIABLE_LENGTH_CODES_MPEG1, qDcReader, BitStreamUncompressor_STRv2.AC_ESCAPE_CODE_STR, padding);
        this._header = header;
    }

    @Override
    public int getQuantizationScale() {
        return this._header.getQuantizationScale();
    }

    @Override
    public String toString() {
        return super.toString() + " " + this._header;
    }

    @Override
    @Nonnull
    public BitStreamCompressor makeCompressor() throws UnsupportedOperationException {
        if (this._header.isVersion2Not3()) {
            return new BitStreamCompressor_StarWarsv2(this._context.getTotalBlocksRead());
        }
        return new BitStreamCompressor_StarWarsv3(this._context.getTotalBlocksRead());
    }

    public static class BitStreamCompressor_StarWarsv3
    extends BitStreamUncompressor_STRv3.BitStreamCompressor_STRv3 {
        public BitStreamCompressor_StarWarsv3(int iMacroBlockCount) {
            super(iMacroBlockCount, LITTLE_ENDIAN_FIRST4_SWAP);
        }
    }

    public static class BitStreamCompressor_StarWarsv2
    extends BitStreamUncompressor_STRv2.BitStreamCompressor_STRv2 {
        public BitStreamCompressor_StarWarsv2(int iMacroBlockCount) {
            super(iMacroBlockCount, LITTLE_ENDIAN_FIRST4_SWAP);
        }
    }

    public static class StarWarsHeader {
        public static final int SIZEOF = 8;
        private final int _iHalfMdecCodeCountCeil32;
        private final int _iQuantizationScale;
        private final int _iRandomVersion;
        private final boolean _blnIsVer2Not3;

        StarWarsHeader(int iHalfMdecCodeCountCeil32, int iQuantizationScale, int iRandomVersion, boolean blnIsVer2Not3) {
            this._iQuantizationScale = iQuantizationScale;
            this._iHalfMdecCodeCountCeil32 = iHalfMdecCodeCountCeil32;
            this._iRandomVersion = iRandomVersion;
            this._blnIsVer2Not3 = blnIsVer2Not3;
        }

        public boolean isVersion2Not3() {
            return this._blnIsVer2Not3;
        }

        public int getQuantizationScale() {
            return this._iQuantizationScale;
        }

        public String toString() {
            return String.format("MDEC/2:%d Qscale:%d RandVer:%04x type:%d", this._iHalfMdecCodeCountCeil32, this._iQuantizationScale, this._iRandomVersion, this._blnIsVer2Not3 ? 2 : 3);
        }
    }
}

