/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.square.ISquareAudioSector;
import jpsxdec.modules.square.SquareAudioSectorPair;

public class SquareAudioSectorToSquareAudioSectorPair
implements IdentifiedSectorListener<ISquareAudioSector> {
    @Nonnull
    private final SectorRange _sectorRange;
    @Nonnull
    private final Listener _listener;
    @CheckForNull
    private ISquareAudioSector _leftAudioSector;

    public SquareAudioSectorToSquareAudioSectorPair(@Nonnull SectorRange sectorRange, @Nonnull Listener listener) {
        this._sectorRange = sectorRange;
        this._listener = listener;
    }

    @Override
    public Class<ISquareAudioSector> getListeningFor() {
        return ISquareAudioSector.class;
    }

    @Override
    public void feedSector(ISquareAudioSector audSector, ILocalizedLogger log) throws LoggedFailure {
        if (this._leftAudioSector != null) {
            if (SquareAudioSectorToSquareAudioSectorPair.isPair(this._leftAudioSector, audSector)) {
                if (this._listener != null) {
                    this._listener.pairDone(new SquareAudioSectorPair(this._leftAudioSector, audSector, this._leftAudioSector.getHeaderFrameNumber(), this._leftAudioSector.getSampleFramesPerSecond(), this._leftAudioSector.getSoundUnitCount(), this._leftAudioSector.getSectorNumber(), audSector.getSectorNumber()), log);
                }
                this._leftAudioSector = null;
            } else {
                if (this._listener != null) {
                    this.leftOnlyDone(log);
                }
                this._leftAudioSector = audSector;
            }
        } else if (audSector.isLeftChannel()) {
            this._leftAudioSector = audSector;
        } else if (this._listener != null) {
            this._listener.pairDone(new SquareAudioSectorPair(null, audSector, audSector.getHeaderFrameNumber(), audSector.getSampleFramesPerSecond(), audSector.getSoundUnitCount(), audSector.getSectorNumber(), audSector.getSectorNumber()), log);
        }
    }

    private void leftOnlyDone(@Nonnull ILocalizedLogger log) throws LoggedFailure {
        this._listener.pairDone(new SquareAudioSectorPair(this._leftAudioSector, null, this._leftAudioSector.getHeaderFrameNumber(), this._leftAudioSector.getSampleFramesPerSecond(), this._leftAudioSector.getSoundUnitCount(), this._leftAudioSector.getSectorNumber(), this._leftAudioSector.getSectorNumber()), log);
    }

    private static boolean isPair(@Nonnull ISquareAudioSector left, @Nonnull ISquareAudioSector right) {
        return left.getClass() == right.getClass() && left.isLeftChannel() && !right.isLeftChannel() && left.getHeaderFrameNumber() == right.getHeaderFrameNumber() && left.getSampleFramesPerSecond() == right.getSampleFramesPerSecond() && left.getSoundUnitCount() == right.getSoundUnitCount() && left.getSectorNumber() + 1 == right.getSectorNumber();
    }

    @Override
    public void endOfFeedSectors(ILocalizedLogger log) throws LoggedFailure {
        if (this._listener != null) {
            if (this._leftAudioSector != null) {
                this.leftOnlyDone(log);
            }
            this._listener.endOfSectors(log);
        }
        this._leftAudioSector = null;
    }

    public static interface Listener {
        public void pairDone(@Nonnull SquareAudioSectorPair var1, @Nonnull ILocalizedLogger var2) throws LoggedFailure;

        public void endOfSectors(@Nonnull ILocalizedLogger var1);
    }
}

