/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.adpcm.SpuAdpcmDecoder;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.modules.square.SquareAudioSectorPair;
import jpsxdec.modules.square.SquareAudioSectorToSquareAudioSectorPair;
import jpsxdec.util.Fraction;

public class SquareAudioSectorPairToAudioPacket
implements SquareAudioSectorToSquareAudioSectorPair.Listener {
    @Nonnull
    private final SpuAdpcmDecoder.Stereo _decoder;
    private final ByteArrayOutputStream _buffer = new ByteArrayOutputStream();
    @CheckForNull
    private DecodedAudioPacket.Listener _listener;

    public SquareAudioSectorPairToAudioPacket(double dblVolume) {
        this._decoder = new SpuAdpcmDecoder.Stereo(dblVolume);
    }

    public void setListener(@CheckForNull DecodedAudioPacket.Listener listener) {
        this._listener = listener;
    }

    @Override
    public void pairDone(@Nonnull SquareAudioSectorPair pair, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        this._buffer.reset();
        try {
            long lngSamplesWritten = this._decoder.getSampleFramesWritten();
            pair.decode(this._decoder, this._buffer);
            if (this._decoder.hadCorruption()) {
                log.log(Level.WARNING, I.SPU_ADPCM_CORRUPTED(pair.getStartSector(), lngSamplesWritten));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Should never happen", ex);
        }
        if (this._listener != null) {
            AudioFormat af = this._decoder.getOutputFormat(pair.getSampleFramesPerSecond());
            DecodedAudioPacket packet = new DecodedAudioPacket(-1, af, new Fraction(pair.getPresentationSector()), this._buffer.toByteArray());
            this._listener.audioPacketComplete(packet, log);
        }
    }

    @Override
    public void endOfSectors(@Nonnull ILocalizedLogger log) {
    }

    public double getVolume() {
        return this._decoder.getVolume();
    }

    @Nonnull
    public AudioFormat getFormat(int iSampleFramesPerSecond) {
        return this._decoder.getOutputFormat(iSampleFramesPerSecond);
    }
}

