/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.adpcm.SpuAdpcmDecoder;
import jpsxdec.adpcm.SpuAdpcmEncoder;
import jpsxdec.adpcm.SpuAdpcmSoundUnit;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.DiscPatcher;
import jpsxdec.i18n.I;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.square.ISquareAudioSector;
import jpsxdec.util.ByteArrayFPIS;
import jpsxdec.util.ExposedBAOS;
import jpsxdec.util.IO;

public class SquareAudioSectorPair {
    private static final Logger LOG = Logger.getLogger(SquareAudioSectorPair.class.getName());
    @CheckForNull
    private final ISquareAudioSector _leftSector;
    @CheckForNull
    private final ISquareAudioSector _rightSector;
    private final int _iHeaderFrameNumber;
    private final int _iSampleFramesPerSecond;
    private final int _iSoundUnitCount;
    private final int _iStartSector;
    private final int _iEndSector;

    public SquareAudioSectorPair(@CheckForNull ISquareAudioSector leftSector, @CheckForNull ISquareAudioSector rightSector, int iHeaderFrameNumber, int iSampleFramesPerSecond, int iSoundUnitCount, int iStartSector, int iEndSector) {
        if (leftSector == null && rightSector == null) {
            throw new IllegalArgumentException();
        }
        this._leftSector = leftSector;
        this._rightSector = rightSector;
        this._iHeaderFrameNumber = iHeaderFrameNumber;
        this._iSampleFramesPerSecond = iSampleFramesPerSecond;
        this._iSoundUnitCount = iSoundUnitCount;
        this._iStartSector = iStartSector;
        this._iEndSector = iEndSector;
    }

    public boolean matchesPrevious(@Nonnull SquareAudioSectorPair prev) {
        if (this._iSampleFramesPerSecond != prev._iSampleFramesPerSecond) {
            return false;
        }
        return this._iHeaderFrameNumber > prev._iHeaderFrameNumber;
    }

    public int getHeaderFrameNumber() {
        return this._iHeaderFrameNumber;
    }

    public int getSampleFramesPerSecond() {
        return this._iSampleFramesPerSecond;
    }

    public int getSoundUnitCount() {
        return this._iSoundUnitCount;
    }

    public int getStartSector() {
        return this._iStartSector;
    }

    public int getEndSector() {
        return this._iEndSector;
    }

    public int getPresentationSector() {
        if (this._rightSector != null) {
            return this._rightSector.getSectorNumber();
        }
        return this._leftSector.getSectorNumber() + 1;
    }

    public int decode(@Nonnull SpuAdpcmDecoder.Stereo decoder, @Nonnull OutputStream out) throws EOFException, IOException {
        InputStream right;
        InputStream left;
        if (this._leftSector == null) {
            left = new IO.ZeroInputStream();
            right = this._rightSector.getIdentifiedUserDataStream();
        } else {
            left = this._leftSector.getIdentifiedUserDataStream();
            right = this._rightSector == null ? new IO.ZeroInputStream() : this._rightSector.getIdentifiedUserDataStream();
        }
        return decoder.decode(left, right, this.getSoundUnitCount(), out);
    }

    public int replace(@Nonnull SpuAdpcmEncoder.Stereo encoder, int iMaxSoundUnitsToReplace, @Nonnull CdFileSectorReader cd, @Nonnull ILocalizedLogger log) throws DiscPatcher.WritePatchException {
        int iSoundUnitsReplaced;
        ByteArrayFPIS leftSoundUnitReader = null;
        if (this._leftSector != null) {
            leftSoundUnitReader = this._leftSector.getIdentifiedUserDataStream();
        }
        ByteArrayFPIS rightSoundUnitReader = null;
        if (this._rightSector != null) {
            rightSoundUnitReader = this._rightSector.getIdentifiedUserDataStream();
        }
        long lngStartOfSamples = encoder.getSampleFramesReadAndEncoded();
        int iSoundUnitsToReplace = Math.min(this.getSoundUnitCount(), iMaxSoundUnitsToReplace);
        ExposedBAOS encodedLeft = new ExposedBAOS();
        ExposedBAOS encodedRight = new ExposedBAOS();
        try {
            for (iSoundUnitsReplaced = 0; iSoundUnitsReplaced < iSoundUnitsToReplace; ++iSoundUnitsReplaced) {
                boolean blnAudioRemains;
                byte bLeftFlagBits = 0;
                if (leftSoundUnitReader != null) {
                    SpuAdpcmSoundUnit su = new SpuAdpcmSoundUnit(leftSoundUnitReader);
                    bLeftFlagBits = su.getFlagBits();
                }
                byte bRightFlagBits = 0;
                if (rightSoundUnitReader != null) {
                    SpuAdpcmSoundUnit su = new SpuAdpcmSoundUnit(rightSoundUnitReader);
                    bRightFlagBits = su.getFlagBits();
                }
                if (blnAudioRemains = encoder.encode1SoundUnit(bLeftFlagBits, encodedLeft, bRightFlagBits, encodedRight)) {
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("All work is being done on BAI/OS", ex);
        }
        String sDbgFormat = "Replacing {0,number,#} out of {1,number,#} bytes in sector {2} with samples starting at {3,number,#}";
        if (this._leftSector != null) {
            LOG.log(Level.INFO, sDbgFormat, new Object[]{encodedLeft.size(), this._leftSector.getAudioDataSize(), this._leftSector, lngStartOfSamples});
            log.log(Level.INFO, I.WRITING_SAMPLES_TO_SECTOR(lngStartOfSamples, this._leftSector.toString()));
            cd.addPatch(this._leftSector.getSectorNumber(), this._leftSector.getAudioDataStartOffset(), encodedLeft.toByteArray());
        }
        if (this._rightSector != null) {
            LOG.log(Level.INFO, sDbgFormat, new Object[]{encodedRight.size(), this._rightSector.getAudioDataSize(), this._rightSector, lngStartOfSamples});
            log.log(Level.INFO, I.WRITING_SAMPLES_TO_SECTOR(lngStartOfSamples, this._rightSector.toString()));
            cd.addPatch(this._rightSector.getSectorNumber(), this._rightSector.getAudioDataStartOffset(), encodedRight.toByteArray());
        }
        return iSoundUnitsReplaced;
    }
}

