/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorXaSubHeader;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedIncompatibleException;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.square.FF9Demuxer;
import jpsxdec.modules.square.ISquareAudioSector;
import jpsxdec.modules.square.SquareAKAOstruct;
import jpsxdec.modules.video.sectorbased.ISelfDemuxingVideoSector;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameReplace;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.psxvideo.bitstreams.BitStreamUncompressor_STRv2;
import jpsxdec.util.ByteArrayFPIS;
import jpsxdec.util.IO;

public abstract class SectorFF9
extends IdentifiedSector {
    private static final Logger LOG = Logger.getLogger(SectorFF9.class.getName());
    protected long _lngMagic;
    protected int _iChunkNumber;
    protected int _iChunksInThisFrame;
    protected int _iHeaderFrameNumber;

    public SectorFF9(@Nonnull CdSector cdSector, int iMagicNumber) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        if (cdSector.isCdAudioSector()) {
            return;
        }
        this._lngMagic = cdSector.readUInt32LE(0);
        if (this._lngMagic != (long)iMagicNumber) {
            return;
        }
        this._iChunkNumber = cdSector.readSInt16LE(4);
        if (this._iChunkNumber < 0) {
            return;
        }
        this._iChunksInThisFrame = cdSector.readSInt16LE(6);
        if (this._iChunksInThisFrame != 10) {
            return;
        }
        this._iHeaderFrameNumber = cdSector.readSInt32LE(8);
        if (this._iHeaderFrameNumber < 0) {
            return;
        }
        this.setProbability(100);
    }

    public int getActualChunkNumber() {
        return this._iChunkNumber;
    }

    public int getActualChunksInFrame() {
        return this._iChunksInThisFrame;
    }

    public int getHeaderFrameNumber() {
        return this._iHeaderFrameNumber;
    }

    public static class SectorFF9Audio
    extends SectorFF9
    implements ISquareAudioSector {
        public static final int FF9_AUDIO_CHUNK_MAGIC = 524640;
        public static final int FRAME_AUDIO_CHUNK_HEADER_SIZE = 208;
        private SquareAKAOstruct _akaoStruct;
        private int _iAudioDataSize;
        private int _iSampleFramesPerSecond;

        public SectorFF9Audio(@Nonnull CdSector cdSector) {
            super(cdSector, 524640);
            if (this.isSuperInvalidElseReset()) {
                return;
            }
            this._akaoStruct = new SquareAKAOstruct(cdSector, 128);
            if (this._akaoStruct.AKAO != 1329679169L || this._akaoStruct.BytesOfData == 0L) {
                this._iAudioDataSize = 0;
                this._iSampleFramesPerSecond = 0;
                this.setProbability(100);
                return;
            }
            if (this._akaoStruct.BytesOfData > 1840L) {
                return;
            }
            this._iAudioDataSize = (int)this._akaoStruct.BytesOfData;
            switch (this._iAudioDataSize) {
                case 1824: 
                case 1840: {
                    this._iSampleFramesPerSecond = 48000;
                    break;
                }
                case 1680: {
                    this._iSampleFramesPerSecond = 44100;
                    break;
                }
                default: {
                    LOG.log(Level.WARNING, "Unexpected audio data size {0} for possible FF9 sector at {1}", new Object[]{this._iAudioDataSize, cdSector});
                    return;
                }
            }
            this.setProbability(100);
        }

        @Override
        @Nonnull
        public String getTypeName() {
            return "FF9Audio";
        }

        @Override
        public int getAudioDataStartOffset() {
            return 208;
        }

        @Override
        public int getAudioDataSize() {
            return this._iAudioDataSize;
        }

        @Override
        public int getSoundUnitCount() {
            return this.getAudioDataSize() / 16;
        }

        @Override
        public int getSampleFramesPerSecond() {
            return this._iSampleFramesPerSecond;
        }

        @Override
        @Nonnull
        public ByteArrayFPIS getIdentifiedUserDataStream() {
            return new ByteArrayFPIS(this.getCdSector().getCdUserDataStream(), this.getAudioDataStartOffset(), this.getAudioDataSize());
        }

        @Override
        public boolean isLeftChannel() {
            switch (this._iChunkNumber) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public String toString() {
            return String.format("%s %s frame:%d chunk:%d/%d %s", this.getTypeName(), super.toString(), this._iHeaderFrameNumber, this._iChunkNumber, this._iChunksInThisFrame, this._akaoStruct);
        }
    }

    public static class SectorFF9Video
    extends SectorFF9
    implements ISelfDemuxingVideoSector,
    SectorBasedFrameReplace.IReplaceableVideoSector {
        public static final int VIDEO_CHUNK_MAGIC = 262496;
        public static final int FRAME_CHUNK_HEADER_SIZE = 32;
        private long _lngUsedDemuxedSize;
        private int _iWidth;
        private int _iHeight;
        private int _iRunLengthCodeCount;
        private int _iMagic3800;
        private int _iQuantizationScale;
        private int _iVersion;
        private long _lngFourBytes;

        @Override
        public int getVideoSectorHeaderSize() {
            return 32;
        }

        public SectorFF9Video(@Nonnull CdSector cdSector) {
            super(cdSector, 262496);
            if (this.isSuperInvalidElseReset()) {
                return;
            }
            CdSectorXaSubHeader sh = cdSector.getSubHeader();
            if (sh == null) {
                return;
            }
            if (sh.getSubMode().mask(40) != 40) {
                return;
            }
            this._lngUsedDemuxedSize = cdSector.readUInt32LE(12);
            if (this._lngUsedDemuxedSize == -1L) {
                return;
            }
            this._iWidth = cdSector.readSInt16LE(16);
            if (this._iWidth < 1) {
                return;
            }
            this._iHeight = cdSector.readSInt16LE(18);
            if (this._iHeight < 1) {
                return;
            }
            this._iRunLengthCodeCount = cdSector.readUInt16LE(20);
            this._iMagic3800 = cdSector.readUInt16LE(22);
            if (this._iMagic3800 != 14336) {
                return;
            }
            this._iQuantizationScale = cdSector.readSInt16LE(24);
            if (this._iQuantizationScale < 0) {
                return;
            }
            this._iVersion = cdSector.readUInt16LE(26);
            if (this._iVersion != 2) {
                return;
            }
            this._lngFourBytes = cdSector.readUInt32LE(28);
            this.setProbability(100);
        }

        @Override
        public String toString() {
            return String.format("%s %s frame:%d chunk:%d/%d %dx%d ver:%d {dur=%d rlc=%d 3800=%04x qscale=%d 4*00=%08x}", this.getTypeName(), super.toString(), this._iHeaderFrameNumber, this._iChunkNumber, this._iChunksInThisFrame, this._iWidth, this._iHeight, this._iVersion, this._lngUsedDemuxedSize, this._iRunLengthCodeCount, this._iMagic3800, this._iQuantizationScale, this._lngFourBytes);
        }

        public int getInvertedVideoChunkNumber() {
            return this._iChunkNumber - 2;
        }

        public int getVideoChunksInFrame() {
            return this._iChunksInThisFrame - 2;
        }

        public int getWidth() {
            return this._iWidth;
        }

        public int getHeight() {
            return this._iHeight;
        }

        @Override
        @Nonnull
        public FF9Demuxer createDemuxer(@Nonnull ILocalizedLogger log) {
            return new FF9Demuxer(this, log);
        }

        @Override
        public int getDemuxPieceSize() {
            return this.getCdSector().getCdUserDataSize() - this.getVideoSectorHeaderSize();
        }

        @Override
        public byte getDemuxPieceByte(int i) {
            return this.getCdSector().readUserDataByte(this.getVideoSectorHeaderSize() + i);
        }

        @Override
        public void copyDemuxPieceData(@Nonnull byte[] abOut, int iOutPos) {
            this.getCdSector().getCdUserDataCopy(this.getVideoSectorHeaderSize(), abOut, iOutPos, this.getDemuxPieceSize());
        }

        @Override
        @Nonnull
        public String getTypeName() {
            return "FF9Video";
        }

        @Override
        public void replaceVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull byte[] abCurrentVidSectorHeader) throws LocalizedIncompatibleException {
            if (!newFrame.isBitStreamClass(BitStreamUncompressor_STRv2.class)) {
                throw new LocalizedIncompatibleException(I.REPLACE_FRAME_TYPE_NOT_V2());
            }
            int iQscale = newFrame.getFrameQuantizationScale();
            IO.writeInt32LE(abCurrentVidSectorHeader, 12, newFrame.calculateUsedBytesRoundUp4() / 4);
            IO.writeInt16LE(abCurrentVidSectorHeader, 20, newFrame.calculateMdecHalfCeiling32());
            IO.writeInt16LE(abCurrentVidSectorHeader, 24, (short)iQscale);
        }
    }
}

