/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.square.ISquareAudioSector;
import jpsxdec.modules.square.SquareAKAOstruct;
import jpsxdec.modules.video.sectorbased.IVideoSectorWithFrameNumber;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.VideoSectorWithFrameNumberDemuxer;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.util.ByteArrayFPIS;

public abstract class SectorFF8
extends IdentifiedSector {
    public static final int SHARED_HEADER_SIZE = 8;
    protected final char[] _achHead = new char[4];
    protected int _iSectorNumber;
    protected int _iSectorsInAVFrame;
    protected int _iHeaderFrameNumber;

    public SectorFF8(@Nonnull CdSector cdSector) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        if (cdSector.isCdAudioSector()) {
            return;
        }
        if (this.subModeExistsAndMaskDoesNotEqual(8, 8)) {
            return;
        }
        char c = (char)cdSector.readUserDataByte(0);
        this._achHead[0] = c;
        if (this._achHead[0] != 'S') {
            return;
        }
        c = (char)cdSector.readUserDataByte(1);
        this._achHead[1] = c;
        if (this._achHead[1] != 'M') {
            return;
        }
        this._achHead[2] = c = (char)cdSector.readUserDataByte(2);
        c = (char)cdSector.readUserDataByte(3);
        this._achHead[3] = c;
        if (this._achHead[3] != '\u0001') {
            return;
        }
        this._iSectorNumber = cdSector.readUserDataByte(4);
        this._iSectorsInAVFrame = cdSector.readUserDataByte(5);
        this._iHeaderFrameNumber = cdSector.readSInt16LE(6);
        if (this._iHeaderFrameNumber < 0) {
            return;
        }
        this.setProbability(100);
    }

    public int getHeaderFrameNumber() {
        return this._iHeaderFrameNumber;
    }

    public int getFF8ChunkNumber() {
        return this._iSectorNumber;
    }

    public int getFF8ChunksInFrame() {
        return this._iSectorsInAVFrame + 1;
    }

    @Override
    public String toString() {
        return super.toString() + String.format(" frame:%d chunk:%d/%d", this._iHeaderFrameNumber, this._iSectorNumber, this._iSectorsInAVFrame);
    }

    public static class SectorFF8Audio
    extends SectorFF8
    implements ISquareAudioSector {
        private static final int FF8_AUDIO_SECTOR_BYTE_DATA_SIZE = 1680;
        public static final int AUDIO_ADDITIONAL_HEADER_SIZE = 360;
        private String _sSHUN_MORIYA;
        private SquareAKAOstruct _AKAOstruct;

        public SectorFF8Audio(@Nonnull CdSector cdSector) {
            super(cdSector);
            if (this.isSuperInvalidElseReset()) {
                return;
            }
            if (this._achHead[2] != 'N' && this._achHead[2] != 'R') {
                return;
            }
            StringBuilder sb = new StringBuilder(32);
            boolean blnOnly0xff = true;
            for (int i = 0; i < 16; ++i) {
                byte b = cdSector.readUserDataByte(240 + i);
                if (b == -1) {
                    sb.append("ff");
                    continue;
                }
                sb.append((char)b);
                blnOnly0xff = false;
            }
            this._sSHUN_MORIYA = sb.toString();
            if (!(blnOnly0xff || this._sSHUN_MORIYA.startsWith("MORIYA") || this._sSHUN_MORIYA.startsWith("SHUN.MORIYA"))) {
                return;
            }
            this._AKAOstruct = new SquareAKAOstruct(cdSector, 256);
            if (this._AKAOstruct.AKAO != 1329679169L && this._AKAOstruct.AKAO != 0xFFFFFFFFL) {
                return;
            }
            if (this._AKAOstruct.BytesOfData != 1680L && this._AKAOstruct.BytesOfData != 0xFFFFFFFFL) {
                return;
            }
            this.setProbability(100);
        }

        @Override
        @Nonnull
        public String getTypeName() {
            return "FF8Audio";
        }

        @Override
        public int getSampleFramesPerSecond() {
            return 44100;
        }

        @Override
        public int getAudioDataStartOffset() {
            return 368;
        }

        @Override
        public int getAudioDataSize() {
            return 1680;
        }

        @Override
        public int getSoundUnitCount() {
            return 105;
        }

        @Override
        public boolean isLeftChannel() {
            switch (this.getFF8ChunkNumber()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        @Nonnull
        public ByteArrayFPIS getIdentifiedUserDataStream() {
            return new ByteArrayFPIS(super.getCdSector().getCdUserDataStream(), this.getAudioDataStartOffset(), 1680);
        }

        @Override
        public String toString() {
            return String.format("%s %s MORIYA:%s %s", this.getTypeName(), super.toString(), this._sSHUN_MORIYA, this._AKAOstruct);
        }
    }

    public static class SectorFF8Video
    extends SectorFF8
    implements IVideoSectorWithFrameNumber {
        @Override
        public int getVideoSectorHeaderSize() {
            return 8;
        }

        public SectorFF8Video(@Nonnull CdSector cdSector) {
            super(cdSector);
            if (this.isSuperInvalidElseReset()) {
                return;
            }
            if (this._achHead[2] != 'J') {
                return;
            }
            this.setProbability(100);
        }

        @Override
        public int getWidth() {
            return 320;
        }

        @Override
        public int getHeight() {
            return 224;
        }

        @Override
        public int getChunkNumber() {
            return this._iSectorNumber - 2;
        }

        @Override
        public int getChunksInFrame() {
            return this._iSectorsInAVFrame - 1;
        }

        @Override
        @Nonnull
        public VideoSectorWithFrameNumberDemuxer createDemuxer(@Nonnull ILocalizedLogger log) {
            return new VideoSectorWithFrameNumberDemuxer(this, log);
        }

        @Override
        public int getDemuxPieceSize() {
            return this.getCdSector().getCdUserDataSize() - this.getVideoSectorHeaderSize();
        }

        @Override
        public byte getDemuxPieceByte(int i) {
            return this.getCdSector().readUserDataByte(this.getVideoSectorHeaderSize() + i);
        }

        @Override
        public void copyDemuxPieceData(@Nonnull byte[] abOut, int iOutPos) {
            this.getCdSector().getCdUserDataCopy(this.getVideoSectorHeaderSize(), abOut, iOutPos, this.getDemuxPieceSize());
        }

        @Override
        public String toString() {
            return String.format("%s %s 320x224", this.getTypeName(), super.toString());
        }

        @Override
        @Nonnull
        public String getTypeName() {
            return "FF8Video";
        }

        @Override
        public void replaceVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull byte[] abCurrentVidSectorHeader) {
        }
    }
}

