/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.square;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.modules.video.sectorbased.SectorAbstractVideo;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.VideoSectorCommon16byteHeader;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.util.IO;

public class SectorFF7Video
extends SectorAbstractVideo {
    public static final int FRAME_SECTOR_HEADER_SIZE = 32;
    @Nonnull
    private final VideoSectorCommon16byteHeader _header;
    private int _iWidth;
    private int _iHeight;
    private long _lngUnknown8bytes;
    private int _iUserDataStart;

    @Override
    public int getVideoSectorHeaderSize() {
        return this._iUserDataStart;
    }

    public SectorFF7Video(@Nonnull CdSector cdSector) {
        super(cdSector);
        this._header = new VideoSectorCommon16byteHeader(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        if (this.subModeExistsAndMaskDoesNotEqual(52, 0)) {
            return;
        }
        if (this._header.lngMagic != 2147549536L) {
            return;
        }
        if (!this._header.hasStandardChunkNumber()) {
            return;
        }
        if (this._header.iChunksInThisFrame < 6 || this._header.iChunksInThisFrame > 10) {
            return;
        }
        if (!this._header.hasStandardFrameNumber()) {
            return;
        }
        if (this._header.iUsedDemuxedSize < 1) {
            return;
        }
        this._iWidth = cdSector.readSInt16LE(16);
        if (this._iWidth < 1) {
            return;
        }
        this._iHeight = cdSector.readSInt16LE(18);
        if (this._iHeight < 1) {
            return;
        }
        this._lngUnknown8bytes = cdSector.readSInt64BE(20);
        int iFourZeros = cdSector.readSInt32LE(28);
        if (iFourZeros != 0) {
            return;
        }
        if (this._header.iChunkNumber == 0) {
            if (cdSector.readUInt16LE(34) == 14336) {
                return;
            }
            if (cdSector.readUInt16LE(74) != 14336) {
                return;
            }
            this._iUserDataStart = 72;
        } else {
            this._iUserDataStart = 32;
        }
        this.setProbability(50);
    }

    @Override
    public String toString() {
        String sRet = String.format("%s %s frame:%d chunk:%d/%d %dx%d {used demux=%d unknown=%016x}", this.getTypeName(), super.cdToString(), this._header.iFrameNumber, this._header.iChunkNumber, this._header.iChunksInThisFrame, this._iWidth, this._iHeight, this._header.iUsedDemuxedSize, this._lngUnknown8bytes);
        if (this._header.iChunkNumber == 0) {
            return sRet + " + Unknown 40 bytes";
        }
        return sRet;
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "FF7 Video";
    }

    @Override
    public void replaceVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull byte[] abCurrentVidSectorHeader) {
        IO.writeInt32LE(abCurrentVidSectorHeader, 12, newFrame.calculateUsedBytesRoundUp4() + 40);
    }

    @Override
    public int getChunkNumber() {
        return this._header.iChunkNumber;
    }

    @Override
    public int getChunksInFrame() {
        return this._header.iChunksInThisFrame;
    }

    @Override
    public int getHeaderFrameNumber() {
        return this._header.iFrameNumber;
    }

    @Override
    public int getHeight() {
        return this._iHeight;
    }

    @Override
    public int getWidth() {
        return this._iWidth;
    }
}

